package cn.myapps.runtime.dynaform.work.ejb;

import java.util.Collection;
import java.util.Map;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.runtime.common.service.RunTimeService;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.WorkVO;

public interface WorkProcess extends RunTimeService<Document> {

	/**
	 * 获取代办列表流程
	 * @param applicationId
	 * @param domainId
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public Collection<Map<String,Object>> getPendingFlowList(boolean isFlowAgent , String applicationId,String domainId, IUser user)throws Exception;

	/**
	 * 获取对应流程下代办列表数据
	 * @param title
	 * @param initiatorId
	 * @param flowId
	 * @param isFlowAgent
	 * @param applicationId
	 * @param domainId
	 * @param pageNo
	 * @param linesPerPage
	 * @return
	 */
	public DataPackage<WorkVO> getPendingList(String title, String initiatorId,String flowId, boolean isFlowAgent, String applicationId,String domainId,String flowname, int pageNo, int linesPerPage, IUser user)throws Exception;
	
	/**
	 * 获取经办列表流程
	 * @param isMyWorkFlow TODO
	 * @param applicationId
	 * @param domainId
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public Collection<Map<String,Object>> getProcessedRunningFlowList(String applicationId, String domainId, IUser user)throws Exception;

	/**
	 * 获取抄送导航
	 * @param applicationId
	 * @param domainId
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public Collection<Map<String,Object>> getCarboncopyRunningFlowList(String applicationId, String domainId, IUser user,boolean isRead)throws Exception;

	/**
	 * 获取对应流程下代办列表数据
	 * @param title
	 * @param initiatorId
	 * @param flowId
	 * @param applicationId
	 * @param domainId
	 * @param isMyWorkFlow TODO
	 * @param status TODO
	 * @param pageNo
	 * @param linesPerPage
	 * @param isFlowAgent
	 * @return
	 */
	public DataPackage<WorkVO> getProcessedRunningList(String title, String initiatorId,String flowId,  String applicationId,String domainId, boolean isMyWorkFlow, String status,String flowname, int pageNo, int linesPerPage, IUser user)throws Exception;

	/**
	 * 获取对应流程下抄送列表数据
	 * @param title
	 * @param initiatorId
	 * @param flowId
	 * @param applicationId
	 * @param domainId
	 * @param platformMode TODO
	 * @param pageNo
	 * @param linesPerPage
	 * @return
	 */
	public DataPackage<WorkVO> carboncopy(String title, String initiatorId,String flowId,  String applicationId,String domainId, boolean platformMode, boolean isRead,String flowname, int pageNo, int linesPerPage, IUser user)throws Exception;
	
}
