package cn.myapps.runtime.dynaform.view;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.servlet.http.HttpServletRequest;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.workcalendar.calendar.model.CalendarVO;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.view.Column;
import cn.myapps.common.model.view.ListView;
import cn.myapps.common.model.view.constant.ViewConstant;
import cn.myapps.common.model.view.type.CalendarType;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.Item;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.DepartmentField;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.dynaform.form.ejb.TreeDepartmentField;
import cn.myapps.runtime.dynaform.form.ejb.UserField;
import cn.myapps.runtime.dynaform.form.ejb.ValidateMessage;
import cn.myapps.runtime.dynaform.form.ejb.ViewDialogField;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.runtime.macro.runner.JsMessage;
import cn.myapps.util.CreateProcessException;
import cn.myapps.util.DateUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;


public class ViewHelper {

	public static final int DO_DISPLAY_VIEW = 1;

	public static final int DO_DIALOG_VIEW = 2;

	protected String applicationid = null;
	/**
	 * The inner module id
	 */
	protected String moduleid = null;
	/**
	 * The inner process process
	 */
	public ViewDesignTimeService process = null;
	private int displayType;

	// private static final Logger log = LoggerFactory.getLogger(ViewHelper.class);

	/**
	 * @SuppressWarnings 工厂方法不支持泛型
	 */
	public ViewHelper() throws Exception {
		super();
		this.process = DesignTimeServiceManager.viewDesignTimeService();
	}

	/**
	 * @return the applicationid
	 */
	public String getApplicationid() {
		return applicationid;
	}

	/**
	 * @param applicationid the applicationid to set
	 */
	public void setApplicationid(String applicationid) {
		this.applicationid = applicationid;
	}

	/**
	 * @return the moduleid
	 */
	public String getModuleid() {
		return moduleid;
	}

	/**
	 * @param moduleid the moduleid to set
	 */
	public void setModuleid(String moduleid) {
		this.moduleid = moduleid;
	}

	/**
	 * @param process the process to set
	 */
	public void setProcess(ViewDesignTimeService process) {
		this.process = process;
	}

	/**
	 * 返回全部符号
	 *
	 * @return
	 */
	public static Map<String, String> getALL_SYMBOL() {
		return ALL_SYMBOL;
	}

	public static void setALL_SYMBOL(Map<String, String> all_symbol) {
		if (all_symbol != null)
			ALL_SYMBOL = all_symbol;
	}

	public static Map<String, String> getCOMPARE_SYMBOL() {
		return COMPARE_SYMBOL;
	}

	public static void setCOMPARE_SYMBOL(Map<String, String> compare_symbol) {
		if (compare_symbol != null)
			COMPARE_SYMBOL = compare_symbol;
	}

	public static Map<String, String> getOPERATOR_SYMBOL() {
		return OPERATOR_SYMBOL;
	}

	public static void setOPERATOR_SYMBOL(Map<String, String> operator_symbol) {
		if (operator_symbol != null)
			OPERATOR_SYMBOL = operator_symbol;
	}

	public static Map<String, String> getRELATION_SYMBOL() {
		return RELATION_SYMBOL;
	}

	public static void setRELATION_SYMBOL(Map<String, String> relation_symbol) {
		if (relation_symbol != null)
			RELATION_SYMBOL = relation_symbol;
	}

	private static Map<String, String> RELATION_SYMBOL = new LinkedHashMap<String, String>();

	private static Map<String, String> OPERATOR_SYMBOL = new LinkedHashMap<String, String>();

	private static Map<String, String> COMPARE_SYMBOL = new LinkedHashMap<String, String>();

	private static Map<String, String> ALL_SYMBOL = new LinkedHashMap<String, String>();

	static {
		RELATION_SYMBOL.put("AND", "AND");
		RELATION_SYMBOL.put("OR", "OR");

		OPERATOR_SYMBOL.put("+", "+");
		OPERATOR_SYMBOL.put("-", "-");
		OPERATOR_SYMBOL.put("*", "*");
		OPERATOR_SYMBOL.put("/", "/");

		COMPARE_SYMBOL.put("LIKE", "LIKE");
		COMPARE_SYMBOL.put(">", ">");
		COMPARE_SYMBOL.put(">=", ">=");
		COMPARE_SYMBOL.put("<", "<");
		COMPARE_SYMBOL.put("<=", "<=");
		COMPARE_SYMBOL.put("=", "=");
		COMPARE_SYMBOL.put("IN", "IN");
		COMPARE_SYMBOL.put("NOT IN", "NOT IN");

		ALL_SYMBOL.putAll(RELATION_SYMBOL);
		ALL_SYMBOL.putAll(OPERATOR_SYMBOL);
		ALL_SYMBOL.putAll(COMPARE_SYMBOL);
	}


	/**
	 * 执行脚本
	 *
	 * @param parameters
	 *            页面参数
	 * @param request
	 *            HTTP请求
	 * @return
	 */
	public String runScript(Map<String, String> parameters,
							HttpServletRequest request) {
		try {
			FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();;

			String viewid = parameters.get("_viewid");
			String formid = parameters.get("formid");
			String fieldid = parameters.get("fieldid");

			WebUser user = AuthTimeServiceManager.getWebUser(request);

			Form form = (Form) formService.doView(formid);
			if (form == null) {
				return "";
			}

			FormField field = form.findField(fieldid);
			if (field != null && field instanceof ViewDialogField) {
				String script = ((ViewDialogField) field).getOkScript();
				if (!StringUtil.isBlank(script)) {
					script = StringUtil.dencodeHTML(script);
					ParamsTable params = ParamsTable.convertHTTP(request);
					params.putAll(parameters);

					Document searchDocument = getSearchDocument(viewid, params,
							user);
					IRunner runner = JavaScriptFactory.getInstance(user
							.getSessionid(), form.getApplicationid());
					runner.initBSFManager(searchDocument, params, user,
							new ArrayList<ValidateMessage>());

					Object result = runner.run(field,
							field.getScriptLable("OkScript"), script);
					if (result instanceof org.mozilla.javascript.Undefined) {
						return "";
					} else if (result instanceof JsMessage) {
						JsMessage js = (JsMessage) result;
						if (js.getTypeName().equals("Alert")) {
							return "do" + js.getTypeName() + "('"
									+ js.getContent() + "');";
						} else {
							return "do" + js.getTypeName() + "('"
									+ js.getContent() + "', result);";
						}
					}
					if(result!=null){
						return  String.valueOf(result);
					}else{
						return "";
					}

				}
			}
		} catch (Exception e) {
			return e.getMessage();
		}

		return "";
	}

	/**
	 * 根据相关视图主键查询,返回样式 id
	 *
	 * @param viewid
	 *            视图主键
	 * @return 样式 id
	 * @throws Exception
	 */
	public static String get_Styleid(String viewid) throws Exception {
		ViewDesignTimeService vp = DesignTimeServiceManager.viewDesignTimeService();
		AbstractView vw = (AbstractView) vp.doView(viewid);
		if (vw != null && vw.getStyle() != null) {
			return vw.getStyle().getId();
		} else
			return null;
	}

	/**
	 * 获取视图查询文档
	 *
	 * @param viewid
	 *            视图ID
	 * @param params
	 *            参数
	 * @param user
	 *            当前用户
	 * @return 查询文档
	 * @throws Exception
	 */
	private Document getSearchDocument(String viewid, ParamsTable params,
									   WebUser user) throws Exception {
		ViewDesignTimeService viewService = DesignTimeServiceManager.viewDesignTimeService();
		AbstractView view = (AbstractView) viewService.doView(viewid);
		if (view != null) {
			Form searchForm = view.getSearchForm();
			if (searchForm != null) {
				return searchForm.createDocument(params, user);
			}
		}

		return new Document();
	}

	/**
	 * 返回月视图信息组成的HTML字串
	 *
	 * @param view
	 *            视图对象
	 * @param params
	 *            参数体对象
	 * @param user
	 *            当前用户对象
	 * @param applicationid
	 *            软件ID
	 * @param yearIndex
	 *            年
	 * @param monthIndex
	 *            月
	 * @return 返回月视图信息组成的HTML字串
	 * @throws Exception
	 */
	public String toMonthHtml(AbstractView view, ParamsTable params, WebUser user,
							  String applicationid, int yearIndex, int monthIndex,
							  boolean isPreview) throws Exception {
		StringBuffer buf = new StringBuffer();
		String rootPath = params.getContextPath();
		buf
				.append("<table moduleType=\"calendarView\" style=\"display:none;\" calendarViewType=\"month\" dayTitle=\"{*[Day]*}{*[View]*}\" dayAlt=\"{*[Day]*}{*[View]*}\""
						+ "weekTitle=\"{*[Week]*}{*[View]*}\" weekAlt=\"{*[Week]*}{*[View]*}\" monthTitle=\"{*[Month]*}{*[View]*}\">");
		buf.append("<tr>");
		buf.append("<td>");
		buf.append(tHead(params.getParameterAsString("viewMode"), yearIndex,
				monthIndex, yearIndex + "-" + monthIndex, rootPath));
		buf.append(tMonthBodyHtml(view, params, user, applicationid, yearIndex,
				monthIndex, displayType, isPreview ? false : true));
		buf.append("</td>");
		buf.append("</tr>");
		buf.append("</table>");
		return buf.toString();
	}

	private String tHead(String viewMode, int year, int month,
						 String headString, String rootPath) {
		StringBuffer buf = new StringBuffer();
		String llab1 = "previousYear";
		String lab1 = "previousMonth";
		String llab2 = "nextYear";
		String lab2 = "nextMonth";
		if ("WEEKVIEW".equals(viewMode)) {
			llab1 = "previousMonth";
			lab1 = "previousWeek";
			llab2 = "nextMonth";
			lab2 = "nextWeek";
		} else if ("DAYVIEW".equals(viewMode)) {
			llab1 = "previousMonth";
			lab1 = "previousDay";
			llab2 = "nextMonth";
			lab2 = "nextDay";
		}

		buf.append("<table subTable=\"tHead\" viewMode=\"" ).append( viewMode
		).append( "\" llab1=\"" ).append( llab1 ).append( "\" viewMode=\"" ).append( viewMode ).append( "\" "
		).append( "lab1=\"" ).append( lab1 ).append( "\" headString=\"" ).append( headString
		).append( "\" lab2=\"" ).append( lab2 ).append( "\" llab2=\"" ).append( llab2 ).append( "\""
		).append( " title1=\"{*[" ).append( llab1 ).append( "]*}\" alt1=\"{*[" ).append( llab1
		).append( "]*}\" title2=\"{*[" ).append( lab1 ).append( "]*}\" " ).append( "alt2=\"{*[" ).append( lab1
		).append( "]*}\" title3=\"{*[" ).append( lab2 ).append( "]*}\" alt3=\"{*[" ).append( lab2
		).append( "]*}\" title4=\"{*[" ).append( llab2 ).append( "]*}\" alt4=\"{*[" ).append( llab2
		).append( "]*}\">");
		buf.append("<tr><td></td></tr>");
		buf.append("</table>");
		return buf.toString();
	}

	/**
	 *
	 * @param yearIndex
	 * @param monthIndex
	 * @return
	 * @throws Exception
	 */
	public String tMonthBodyHtml(AbstractView view, ParamsTable params, WebUser user,
								 String applicationid, int yearIndex, int monthIndex, int viewType,
								 boolean isShowDayInfo) throws Exception {
		Calendar thisMonth = CalendarVO.getThisMonth(yearIndex, monthIndex - 1);
		StringBuffer htmlBuilder = new StringBuffer();
		thisMonth.set(Calendar.DAY_OF_MONTH, 1);
		int firstIndex = thisMonth.get(Calendar.DAY_OF_WEEK) - 1;
		int maxIndex = thisMonth.getActualMaximum(Calendar.DAY_OF_MONTH);
		final Calendar cld = thisMonth;
		cld.set(Calendar.HOUR_OF_DAY, 0);
		cld.set(Calendar.MINUTE, 0);
		cld.set(Calendar.SECOND, 0);
		Date stDate = cld.getTime();
		cld.set(Calendar.DAY_OF_MONTH, cld
				.getActualMaximum(Calendar.DAY_OF_MONTH));
		cld.set(Calendar.HOUR_OF_DAY, 23);
		cld.set(Calendar.MINUTE, 59);
		cld.set(Calendar.SECOND, 59);
		Collection<Document> datas = getDatas(view, params, user,
				applicationid, stDate, cld.getTime());
		IRunner jsrun = JavaScriptFactory.getInstance(user.getSessionid(),
				view.getApplicationid());
		htmlBuilder
				.append("<table subTable=\"tMonthBody\" Sunday=\"{*[Sunday]*}\" Monday=\"{*[Monday]*}\""
				).append( " Tuesday=\"{*[Tuesday]*}\" Wednesday=\"{*[Wednesday]*}\" Thursday=\"{*[Thursday]*}\" "
		).append( "Friday=\"{*[Friday]*}\" Saturday=\"{*[Saturday]*}\""
		).append( " viewType=\""
		).append( viewType
		).append( "\" viewAction=\""
		).append( DO_DIALOG_VIEW ).append("\"><tr>");
		int day;// 日
		for (int i = 0; i < 6; i++) {
			htmlBuilder.append("<tr subTable=\"trBody\">");
			for (int j = 0; j < 7; j++) {
				day = (i * 7 + j) - firstIndex + 1;
				htmlBuilder.append("<td subTable=\"tdBody\" day=" ).append( day
				).append( " maxIndex=\"" ).append( maxIndex ).append( "\" viewType=\""
				).append( viewType ).append( "\" viewAction=\""
				).append(DO_DIALOG_VIEW + "\" yearIndex=\""
				).append( yearIndex ).append( "\" monthIndex=\"" ).append( monthIndex
				).append( "\" isShowDayInfo=\"" ).append( isShowDayInfo ).append( "\"");
				if (day > 0 && day <= maxIndex) {
					String dayInfo = getDayViewList(jsrun, view, datas, params,
							user, thisMonth, day, viewType, yearIndex,
							monthIndex);
					String taskInfo = getTaskViewList(jsrun, view, datas,
							params, user, thisMonth, day, viewType, yearIndex,
							monthIndex);
					htmlBuilder.append("><div>"
							+ (isShowDayInfo ? dayInfo : "") + "</div><div>"
							+ (isShowDayInfo ? taskInfo : "") + "</div></td>");
				} else {
					htmlBuilder.append("></td>");
				}
			}
			htmlBuilder.append("</tr>");
		}
		htmlBuilder.append("</table>");
		return htmlBuilder.toString();
	}

	public String tWeekBodyHtml(AbstractView view, ParamsTable params, WebUser user,
								String applicationid, final Calendar cld, int yearIndex,
								int monthIndex, int viewType, boolean isShowInfo) throws Exception {
		StringBuffer htmlBuilder = new StringBuffer();
		Date startDate = cld.getTime();
		cld.add(Calendar.DAY_OF_MONTH, 7);
		Collection<Document> datas = getDatas(view, params, user,
				applicationid, startDate, cld.getTime());
		cld.add(Calendar.DAY_OF_MONTH, -7);
		IRunner jsrun = JavaScriptFactory.getInstance(user.getSessionid(),
				view.getApplicationid());

		htmlBuilder
				.append("<table subTable=\"tWeekBody\" week=\"{*[Week]*}\" content=\"{*[Content]*}\" Sunday=\"{*[Sunday]*}\""
						+ "Monday=\"{*[Monday]*}\" Tuesday=\"{*[Tuesday]*}\" Wednesday=\"{*[Wednesday]*}\""
						+ "Thursday=\"{*[Thursday]*}\" Friday=\"{*[Friday]*}\" Saturday=\"{*[Saturday]*}\"><tr>");
		for (int i = 0; i < 7; i++) {
			switch (i) {
				case 0:
					htmlBuilder.append("<td timeFormat1=\""
					).append( DateUtil.format(cld.getTime(), "yyyy-MM-dd")
					).append( "\" dateUtil=\"Sd\"");
					break;
				case 1:
					htmlBuilder.append("<td timeFormat2=\""
					).append( DateUtil.format(cld.getTime(), "yyyy-MM-dd")
					).append( "\" dateUtil=\"Md\"");
					break;
				case 2:
					htmlBuilder.append("<td timeFormat3=\""
					).append( DateUtil.format(cld.getTime(), "yyyy-MM-dd")
					).append( "\" dateUtil=\"Td\"");
					break;
				case 3:
					htmlBuilder.append("<td timeFormat4=\""
					).append( DateUtil.format(cld.getTime(), "yyyy-MM-dd")
					).append("\" dateUtil=\"Wd\"");
					break;
				case 4:
					htmlBuilder.append("<td timeFormat5=\""
					).append( DateUtil.format(cld.getTime(), "yyyy-MM-dd")
					).append( "\" dateUtil=\"T4d\"");
					break;
				case 5:
					htmlBuilder.append("<td timeFormat6=\""
					).append( DateUtil.format(cld.getTime(), "yyyy-MM-dd")
					).append( "\" dateUtil=\"Fd\"");
					break;
				case 6:
					htmlBuilder.append("<td timeFormat7=\""
					).append( DateUtil.format(cld.getTime(), "yyyy-MM-dd")
					).append( "\" dateUtil=\"S6d\"");
					break;
			}
			htmlBuilder.append(" isShowInfo=\"" ).append( isShowInfo ).append( "\">");
			String info = getDayViewList(jsrun, view, datas, params, user, cld,
					cld.get(Calendar.DAY_OF_MONTH), viewType, yearIndex,
					monthIndex);
			htmlBuilder.append(isShowInfo ? info : "");

			cld.add(Calendar.DAY_OF_MONTH, 1);
		}
		htmlBuilder.append("</td></tr></table>");
		return htmlBuilder.toString();
	}

	/**
	 * 返回周视图信息组成的HTML字串
	 *
	 * @param view
	 *            视图对象
	 * @param params
	 *            参数体对象
	 * @param user
	 *            当前用户对象
	 * @param applicationid
	 *            软件ID
	 * @param yearIndex
	 *            年
	 * @param monthIndex
	 *            月
	 * @param dayIndex
	 *            日（基准日）
	 * @return 返回周视图信息组成的HTML字串
	 * @throws Exception
	 */
	public String toWeekHtml(AbstractView view, ParamsTable params, WebUser user,
							 String applicationid, int yearIndex, int monthIndex, int dayIndex,
							 boolean isPreview) throws Exception {
		StringBuffer buf = new StringBuffer();
		final Calendar cld = Calendar.getInstance();
		cld.set(Calendar.YEAR, yearIndex);
		cld.set(Calendar.MONTH, monthIndex - 1);
		cld.set(Calendar.DAY_OF_MONTH, dayIndex);
		int firstIndex = cld.get(Calendar.DAY_OF_WEEK) - 1;
		cld.add(Calendar.DAY_OF_MONTH, -firstIndex);
		cld.set(Calendar.HOUR_OF_DAY, 0);
		cld.set(Calendar.MINUTE, 0);
		cld.set(Calendar.SECOND, 0);
		Date stDate = cld.getTime();
		String body = tWeekBodyHtml(view, params, user, applicationid, cld,
				yearIndex, monthIndex, displayType, isPreview ? false : true);
		cld.add(Calendar.DAY_OF_MONTH, -1);

		String rootPath = params.getContextPath();
		buf
				.append("<table moduleType=\"calendarView\" style=\"display:none;\" calendarViewType=\"week\" dayTitle=\"{*[Day]*}{*[View]*}\" dayAlt=\"{*[Day]*}{*[View]*}\""
						+ "weekTitle=\"{*[Week]*}{*[View]*}\" weekAlt=\"{*[Week]*}{*[View]*}\" monthTitle=\"{*[Month]*}{*[View]*}\">");
		buf.append("<tr>");
		buf.append("<td>");
		buf.append(tHead(params.getParameterAsString("viewMode"), yearIndex,
				monthIndex, DateUtil.format(stDate, "yyyy-MM-dd") + "~"
						+ DateUtil.format(cld.getTime(), "yyyy-MM-dd"),
				rootPath));
		buf.append("</td>");
		buf.append("<td>");
		buf.append(body);
		buf.append("</td>");
		buf.append("</tr>");
		buf.append("</table>");
		return buf.toString();
	}

	/**
	 * 返回日视图信息组成的HTML字串
	 *
	 * @param view
	 *            视图对象
	 * @param params
	 *            参数体对象
	 * @param user
	 *            当前用户对象
	 * @param applicationid
	 *            软件ID
	 * @param yearIndex
	 *            年
	 * @param monthIndex
	 *            月
	 * @param dayIndex
	 *            日
	 * @return 返回日视图信息组成的HTML字串
	 * @throws Exception
	 */
	public String toDayHtml(AbstractView view, ParamsTable params, WebUser user,
							String applicationid, int yearIndex, int monthIndex, int dayIndex,
							boolean isPreview) throws Exception {
		StringBuffer buf = new StringBuffer();
		String rootPath = params.getContextPath();
		buf
				.append("<table moduleType=\"calendarView\" style=\"display:none;\" calendarViewType=\"day\" dayTitle=\"{*[Day]*}{*[View]*}\" dayAlt=\"{*[Day]*}{*[View]*}\""
						+ "weekTitle=\"{*[Week]*}{*[View]*}\" weekAlt=\"{*[Week]*}{*[View]*}\" monthTitle=\"{*[Month]*}{*[View]*}\">");
		buf.append("<tr>");
		buf.append("<td>");
		buf.append(tHead(params.getParameterAsString("viewMode"), yearIndex,
				monthIndex, yearIndex + "-" + monthIndex + "-" + dayIndex,
				rootPath));
		buf.append("</td>");
		buf.append("<td>");
		buf.append(tDayBodyHtml(view, params, user, applicationid, yearIndex,
				monthIndex, dayIndex, displayType, isPreview ? false : true));
		buf.append("</td>");
		buf.append("</tr>");
		buf.append("</table>");
		return buf.toString();
	}

	public String tDayBodyHtml(AbstractView view, ParamsTable params, WebUser user,
							   String applicationid, int yearIndex, int monthIndex, int dayIndex,
							   int viewType, boolean isShowInfo) throws Exception {
		Calendar cld = Calendar.getInstance();
		StringBuffer htmlBuilder = new StringBuffer();
		cld.set(Calendar.YEAR, yearIndex);
		cld.set(Calendar.MONTH, monthIndex - 1);
		cld.set(Calendar.DAY_OF_MONTH, dayIndex);
		cld.set(Calendar.HOUR_OF_DAY, 0);
		cld.set(Calendar.MINUTE, 0);
		cld.set(Calendar.SECOND, 0);
		Date stDate = cld.getTime();
		cld.add(Calendar.DAY_OF_MONTH, 1);
		Collection<Document> datas = getDatas(view, params, user,
				applicationid, stDate, cld.getTime());
		IRunner runner = JavaScriptFactory.getInstance(user.getSessionid(),
				view.getApplicationid());
		cld.add(Calendar.DAY_OF_MONTH, -1);
		int sTime = 8;
		htmlBuilder.append("<table sTime=\"" ).append( sTime
		).append( "\" subTable=\"tDayBody\" isShowInfo=\"" ).append( isShowInfo
		).append( "\" time=\"{*[Time]*}\" content=\"{*[Content]*}\">");
		htmlBuilder.append("<tr>");
		htmlBuilder.append("<td subTable=\"tdView1\">");
		htmlBuilder.append(isShowInfo ? getDayTimeList(runner, view, datas,
				params, user, cld, 8, viewType) : "");
		htmlBuilder.append("</td>");
		htmlBuilder.append("</tr>");
		cld.set(Calendar.HOUR_OF_DAY, 8);

		for (int i = 0; i < 11; i++) {
			htmlBuilder.append("<tr>");
			htmlBuilder.append("<td>"+ (sTime++) +":00 -- "+ sTime + ":00</td><td subTable=\"tdView2\">");
			htmlBuilder.append(isShowInfo ? getDayTimeList(runner, view, datas,
					params, user, cld, 1, viewType) : "");
			htmlBuilder.append("</td>");
			htmlBuilder.append("</tr>");
			cld.set(Calendar.HOUR_OF_DAY, sTime);
		}
		htmlBuilder.append("<tr>");
		htmlBuilder.append("<td subTable=\"tdView3\">");
		htmlBuilder.append(isShowInfo ? getDayTimeList(runner, view, datas,
				params, user, cld, 8, viewType) : "");
		htmlBuilder.append("</td>");
		htmlBuilder.append("</tr>");
		htmlBuilder.append("</table>");
		return htmlBuilder.toString();
	}

	private String getDayTimeList(IRunner runner, AbstractView view,
								  Collection<Document> datas, ParamsTable params, WebUser user,
								  final Calendar cld, int step, int viewType) {
		StringBuffer buf = new StringBuffer();
		String templateForm = "";
		if (ViewConstant.DISPLAY_TYPE_TEMPLATEFORM.equals(view.getDisplayType())) {
			templateForm = view.getTemplateForm();
		}
		if (datas != null) {
			Collection<ValidateMessage> errors = new ArrayList<ValidateMessage>();
			Iterator<Document> it = datas.iterator();
			try {
				StringBuffer colBuf = new StringBuffer();
				// String fieldName = view.getRelationDateColum();
				Object column = view.getViewTypeImpl().getColumnMapping().get(
						CalendarType.DEFAULT_KEY_FIELDS[0]);
				String fieldName = "";
				boolean showTitle1 = true;
				if (column instanceof String)
					fieldName = column.toString();
				else if (column instanceof Column){
					fieldName = ((Column) column).getFieldName();
					showTitle1 = ((Column) column).isShowTitle();
				}


				Date stDate = cld.getTime();
				cld.add(Calendar.HOUR, step);
				SimpleDateFormat format = new SimpleDateFormat(
						"yyyy-MM-dd HH:mm:ss");
				String filterValue1 = format.format(stDate);
				String filterValue2 = format.format(cld.getTime());
				int i = 0;
				while (it.hasNext()) {
					Document doc = it.next();
					String value = getDocDateTimeValueAsString(doc, fieldName);
					if (filterValue1.compareTo(value) <= 0
							&& filterValue2.compareTo(value) > 0) {
						runner.initBSFManager(doc, params, user, errors);
						Iterator<Column> iter = view.getColumns().iterator();
						String list = "";
						while (iter.hasNext()) {
							Column col = (Column) iter.next();
							Object result = col.getText(doc, runner, user);
							if (!(col.getWidth() != null && col.getWidth()
									.equals("0"))) {
								list += result + "&nbsp;";
							}
						}
						colBuf.append("<div moduleType=\"div1\" order=\"")
								.append(i).append("\" isReadonly=\"").append(
								view.getReadonly().booleanValue())
								.append("\" list='").append(list).append(
								"' viewType=\"").append(viewType)
								.append("\" showTitle=\"" + showTitle1 + "\"");
						if (view.getReadonly().booleanValue()) {
							colBuf.append(">");
						} else {

							switch (viewType) {
								case 1: {
									colBuf.append(" getId=\"" ).append( doc.getId()
									).append("\" getFormid=\"" ).append( doc.getFormid()
									).append( "\" templateForm=\"" ).append( templateForm
									).append( "\">");

								}
								break;
								case 2: {
									DocumentProcess proxy = (DocumentProcess) getProcess();
									Document doc2 = (Document) proxy.doView(doc
											.getId());
									IRunner jsrun = JavaScriptFactory.getInstance(
											user.getSessionid(), view
													.getApplicationid());
									jsrun
											.initBSFManager(doc2, params, user,
													errors);
									Collection<Column> columns = view.getColumns();
									StringBuffer valuesMap = new StringBuffer("{");
									Iterator<Column> it2 = columns.iterator();
									while (it2.hasNext()) {
										Column key = it2.next();
										Object value1 = key.getText(doc, jsrun,
												user);
										valuesMap
												.append("'")
												.append(key.getId())
												.append("':'")
												.append(
														StringUtil
																.encodeHTML(value1
																		.toString()))
												.append("',");
									}
									valuesMap.setLength(valuesMap.length() - 1);
									valuesMap.append("}");
									colBuf.append(" valuesMap=\""
									).append( valuesMap.toString() ).append( "\">");
								}
								break;
								default:
									;
							}

						}
						colBuf.append("</div>");
						i++;
						if (i >= 3) {
							colBuf
									.append("<div moduleType=\"div2\" filterValue1=\""
									).append( filterValue1.substring(0, 10)
							).append( "\"></div>");
							break;
						}
					}
				}
				if (colBuf.length() > 0)
					buf.append(colBuf);
			} catch (Exception e) {
				e.printStackTrace();
				buf.append("&nbsp;");
			}
		} else {
			buf.append("&nbsp;");
		}
		return buf.toString();
	}

	private String getDayViewList(IRunner runner, AbstractView view,
								  Collection<Document> datas, ParamsTable params, WebUser user,
								  final Calendar cld, int day, int viewType, int yearIndex,
								  int monthIndex) {
		StringBuffer buf = new StringBuffer();
		String templateForm = "";
		if (ViewConstant.DISPLAY_TYPE_TEMPLATEFORM.equals(view.getDisplayType())) {
			templateForm = view.getTemplateForm();
		}
		if (datas != null) {
			Collection<ValidateMessage> errors = new ArrayList<ValidateMessage>();
			Iterator<Document> it = datas.iterator();
			try {
				StringBuffer colBuf = new StringBuffer();
				// String fieldName = view.getRelationDateColum();
				Object column = view.getViewTypeImpl().getColumnMapping().get(
						CalendarType.DEFAULT_KEY_FIELDS[0]);
				String fieldName = "";
				boolean showTitle = true;
				if (column instanceof String)
					fieldName = column.toString();
				else if (column instanceof Column){
					fieldName = ((Column) column).getFieldName();
					showTitle = ((Column) column).isShowTitle();
				}

				cld.set(Calendar.DAY_OF_MONTH, day);
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
				String filterValue = format.format(cld.getTime());
				int i = 0;
				while (it.hasNext()) {
					Document doc = it.next();
					String value;
					value = doc.getValueByField(fieldName);
					Date dateTemp = format.parse(value);
					value = format.format(dateTemp);
					if (filterValue.equals(value)) {
						runner.initBSFManager(doc, params, user, errors);
						Iterator<Column> iter = view.getColumns().iterator();

						String list = "";
						while (iter.hasNext()) {
							Column col = iter.next();
							if (!isHiddenColumn(col, runner)) {
								Object result = col.getText(doc, runner, user);
								if (!(col.getWidth() != null && col.getWidth()
										.equals("0"))) {
									list += result + "&nbsp;";
								}
							}
						}
						colBuf.append("<div moduleType=\"div1\" isReadonly=\""
								+ view.getReadonly().booleanValue()
								+ "\" viewAction=\""
								+ DO_DIALOG_VIEW + "\" order=\"" + i
								+ "\" viewType=\"" + viewType + "\" list='"
								+ list + "' showTitle='" + showTitle + "'");
						colBuf.append(" yearIndex='" + yearIndex
								+ "'  monthIndex='" + monthIndex
								+ "' day='" + day + "'");
						if (view.getReadonly().booleanValue()) {
							colBuf.append(">");
						} else {
							switch (viewType) {
								case 1: {
									colBuf.append(" docGetid='" + doc.getId()
											+ "' docGetFormid='" + doc.getFormid()
											+ "' templateForm='" + templateForm
											+ "'>");
								}
								break;
								case 2: {
									DocumentProcess proxy = createDocumentProcess(view
											.getApplicationid());
									Document doc2 = (Document) proxy.doView(doc
											.getId());
									IRunner jsrun = JavaScriptFactory.getInstance(
											user.getSessionid(), view
													.getApplicationid());
									jsrun
											.initBSFManager(doc2, params, user,
													errors);
									Collection<Column> columns = view.getColumns();
									StringBuffer valuesMap = new StringBuffer("{");
									Iterator<Column> it2 = columns.iterator();
									while (it2.hasNext()) {
										Column key = it2.next();
										Object value1 = key.getText(doc, jsrun,
												user);
										valuesMap
												.append("'")
												.append(key.getId())
												.append("':'")
												.append(
														StringUtil
																.encodeHTML(value1
																		.toString()))
												.append("',");
									}
									valuesMap.setLength(valuesMap.length() - 1);
									valuesMap.append("}");
									colBuf.append("valuesMap='"
											+ valuesMap.toString() + "'>");

								}
								break;
								default:
									;
							}
						}
						colBuf.append("</div>");
						i++;
						if (i >= 4) {
							if (viewType != DO_DIALOG_VIEW) {
								colBuf
										.append("<div moduleType=\"div2\" filterValue='"
												+ filterValue + "'></div>");
							}
							break;
						}
					}
				}
				if (colBuf.length() > 0)
					buf.append(colBuf);
			} catch (Exception e) {
				e.printStackTrace();
				buf.append("&nbsp;");
			}
		} else {
			buf.append("&nbsp;");
		}
		return buf.toString();
	}

	private String getTaskViewList(IRunner runner, AbstractView view,
								   Collection<Document> datas, ParamsTable params, WebUser user,
								   final Calendar cld, int day, int viewType, int yearIndex,
								   int monthIndex) {
		StringBuffer buf = new StringBuffer();
		String templateForm = "";
		if (ViewConstant.DISPLAY_TYPE_TEMPLATEFORM.equals(view.getDisplayType())) {
			templateForm = view.getTemplateForm();
		}
		if (datas != null) {
			Collection<ValidateMessage> errors = new ArrayList<ValidateMessage>();
			Iterator<Document> it = datas.iterator();
			try {
				StringBuffer colBuf = new StringBuffer();
				// String fieldName = view.getRelationDateColum();
				Object column = view.getViewTypeImpl().getColumnMapping().get(
						CalendarType.DEFAULT_KEY_FIELDS[0]);
				String fieldName = "";
				boolean showTitle2 = true;
				if (column instanceof String)
					fieldName = column.toString();
				else if (column instanceof Column){
					fieldName = ((Column) column).getFieldName();
					showTitle2 = ((Column) column).isShowTitle();
				}

				cld.set(Calendar.DAY_OF_MONTH, day);
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
				String filterValue = format.format(cld.getTime());
				while (it.hasNext()) {
					Document doc = it.next();
					String value;
					value = doc.getValueByField(fieldName);
					if (filterValue.equals(value)) {
						runner.initBSFManager(doc, params, user, errors);
						Iterator<Column> iter = view.getColumns().iterator();

						String list = "";
						while (iter.hasNext()) {
							Column col = iter.next();
							if (!isHiddenColumn(col, runner)) {
								Object result = col.getText(doc, runner, user);
								if (!(col.getWidth() != null && col.getWidth()
										.equals("0"))) {
									list += result + "&nbsp;&nbsp;";
								}
							}
						}
						colBuf
								.append("<div moduleType=\"divType\" isReadonly=\""
								).append( view.getReadonly().booleanValue()
						).append( "\" yearIndex=\""
						).append( yearIndex
						).append( "\" monthIndex=\""
						).append( monthIndex
						).append( "\" day=\""
						).append( day
						).append( "\" list=\""
						).append( list
						).append( "\" getLoginno=\""
						).append( user.getLoginno()
						).append( "\" viewType=\""
						).append( viewType
						).append( "\" getId=\""
						).append( doc.getId()
						).append( "\" showTitle=\""
						).append( showTitle2
						).append( "\" getFormid=\""
						).append( doc.getFormid()
						).append( "\" templateForm=\""
						).append( templateForm
						).append( "\"");
						if (view.getReadonly().booleanValue()) {
							colBuf.append(">");
							colBuf.append("</div>");
						} else {
							switch (viewType) {
								case 1: {
									colBuf.append(">");
									colBuf.append("</div>");
								}
								break;
								case 2: {
									DocumentProcess proxy = createDocumentProcess(view
											.getApplicationid());
									Document doc2 = (Document) proxy.doView(doc
											.getId());
									IRunner jsrun = JavaScriptFactory.getInstance(
											user.getSessionid(), view
													.getApplicationid());
									jsrun
											.initBSFManager(doc2, params, user,
													errors);
									Collection<Column> columns = view.getColumns();
									StringBuffer valuesMap = new StringBuffer("{");
									Iterator<Column> it2 = columns.iterator();
									while (it2.hasNext()) {
										Column key = it2.next();
										Object value1 = key.getText(doc, jsrun,
												user);
										valuesMap
												.append("'")
												.append(key.getId())
												.append("':'")
												.append(
														StringUtil
																.encodeHTML(value1
																		.toString()))
												.append("',");
									}
									valuesMap.setLength(valuesMap.length() - 1);
									valuesMap.append("}");
									colBuf.append(" valuesMap=\""
									).append( valuesMap.toString() ).append( "\">");
									colBuf.append("</div>");
								}
								break;
								default:
									break;
							}
						}
					}
				}
				if (colBuf.length() > 0)
					buf.append(colBuf);
			} catch (Exception e) {
				e.printStackTrace();
				buf.append("&nbsp;");
			}
		} else {
			buf.append("&nbsp;");
		}
		return buf.toString();
	}

	private Collection<Document> getDatas(AbstractView view, ParamsTable params,
										  WebUser user, String applicationid, Date stDate, Date endDate)
			throws Exception {
		ViewDesignTimeService viewService = DesignTimeServiceManager.viewDesignTimeService();
		DataPackage<Document> datas = viewService.getDataPackage(view, params,
				user, applicationid, stDate, endDate, Integer.MAX_VALUE);
		return datas != null ? datas.datas : null;
	}



	/**
	 * 根据日期时间字段标识，查找对应日期时间字段值，以字符串返回
	 *
	 * @param doc
	 *            数据文档
	 * @param fieldName
	 *            日期时间字段标识
	 * @return 根据日期时间字段标识，查找对应日期时间字段值，以字符串返回
	 * @throws Exception
	 */
	public String getDocDateTimeValueAsString(Document doc, String fieldName)
			throws Exception {
		String value = "";
		if (fieldName.toUpperCase().trim().startsWith("$")) {
			String propName = fieldName.substring(1);
			if (propName.equalsIgnoreCase("AuditDate")) {
				if (doc.getAuditdate() != null) {
					try {
						value = DateUtil.format(doc.getAuditdate(),
								"yyyy-MM-dd HH:mm:ss");
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			} else if (propName.equalsIgnoreCase("LastModified")) {
				if (doc.getLastmodified() != null) {
					try {
						value = DateUtil.format(doc.getLastmodified(),
								"yyyy-MM-dd HH:mm:ss");
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			} else if (propName.equalsIgnoreCase("Created")) {
				if (doc.getCreated() != null) {
					try {
						value = DateUtil.format(doc.getCreated(),
								"yyyy-MM-dd HH:mm:ss");
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		} else {
			Item item = doc.findItem(fieldName);
			if (item != null && item.getType().equals(Item.VALUE_TYPE_DATE)) {
				if (item.getDatevalue() != null) {
					value = DateUtil.getDateTimeStr(item.getDatevalue());
				}
			}
		}
		return value;
	}

	public static AbstractView get_ViewById(String viewid) throws Exception {
		ViewDesignTimeService vp = DesignTimeServiceManager.viewDesignTimeService();
		return (AbstractView) vp.doView(viewid);
	}

	private static DocumentProcess createDocumentProcess(String applicationid)
			throws CreateProcessException {
		DocumentProcess process = RunTimeServiceManager.documentProcess(applicationid);
		return process;
	}

	public RunTimeService<IDocument> getProcess() throws CreateProcessException {
		return createDocumentProcess(getApplication());
	}

	public String getApplication() {
		if (application != null && application.trim().length() > 0)
			return application;

		return null;
	}

	protected String application;

	public int getDisplayType() {
		return displayType;
	}

	public void setDisplayType(int displayType) {
		this.displayType = displayType;
	}





	public boolean isHiddenColumn(Column column, IRunner runner) {
		try {
			if (column.getHiddenScript() != null
					&& column.getHiddenScript().trim().length() > 0) {
				StringBuffer label = new StringBuffer();
				label.append("View").append(".Activity(")
						.append(column.getId()).append(")." + column.getName())
						.append(".runHiddenScript");

				Object result = runner.run(column,label.toString(), column
						.getHiddenScript());// 运行脚本
				if (result != null && result instanceof Boolean) {
					return ((Boolean) result).booleanValue();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return false;
	}

	/**
	 * 创建权限字段范围下拉选项
	 *
	 * @param selectFieldName
	 *            下拉框名称
	 * @param def
	 *            默认值
	 * @return 添加选项的JS脚本
	 */
	public Map<String, String> createAuthFieldOptions(String selectFieldName,
													  String authField, String def) {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		if (ViewConstant.AUTHFIELD_AUTHOR.equals(authField)) {
			map.put(ViewConstant.AUTHFIELD_SCOPE_ITSELF,
					"{*[core.dynaform.view.authfield.scope.itself]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_SUPERIOR,
					"{*[core.dynaform.view.authfield.scope.superior]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_ALL_SUPERIOR,
					"{*[core.dynaform.view.authfield.scope.all_superior]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_LOWER,
					"{*[core.dynaform.view.authfield.scope.lower]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_ALL_LOWER,
					"{*[core.dynaform.view.authfield.scope.all_lower]*}");
		} else if (ViewConstant.AUTHFIELD_AUTHOR_DEFAULT_DEPT.equals(authField)) {
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_DEPT_DEFAULT,
					"{*[core.dynaform.view.authfield.scope.author.dept.default]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_DEPT_ALL_SUPERIOR,
					"{*[core.dynaform.view.authfield.scope.author.dept.allsuperior]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_DEPT_ALL_LOWER,
					"{*[core.dynaform.view.authfield.scope.author.dept.alllower]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_DEPT_LINE_SUPERIOR,
					"{*[core.dynaform.view.authfield.scope.author.dept.linesuperior]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_DEPT_LINE_LOWER,
					"{*[core.dynaform.view.authfield.scope.author.dept.linelower]*}");
		} else if (ViewConstant.AUTHFIELD_AUDITOR.equals(authField)) {
			map.put(ViewConstant.AUTHFIELD_SCOPE_ITSELF,
					"{*[core.dynaform.view.authfield.scope.itself]*}");
		}else if(ViewConstant.AUTHFIELD_PROCESSED.equals(authField)){
			map.put(ViewConstant.AUTHFIELD_SCOPE_ITSELF, "{*[core.dynaform.view.authfield.scope.itself]*}");
		}else if (authField.contains("departmentField")) {
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_DEPT_DEFAULT,
					"{*[core.dynaform.view.authfield.scope.author.dept.default]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_DEPT_ALL_SUPERIOR,
					"{*[core.dynaform.view.authfield.scope.author.dept.allsuperior]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_DEPT_ALL_LOWER,
					"{*[core.dynaform.view.authfield.scope.author.dept.alllower]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_DEPT_LINE_SUPERIOR,
					"{*[core.dynaform.view.authfield.scope.author.dept.linesuperior]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_DEPT_LINE_LOWER,
					"{*[core.dynaform.view.authfield.scope.author.dept.linelower]*}");
		} else if (authField.contains("treeTepartmentField")) {
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_DEPT_DEFAULT,
					"{*[core.dynaform.view.authfield.scope.author.dept.default]*}");
		} else if (authField.contains("userField")) {
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_SUPERIOR,
					"{*[core.dynaform.view.authfield.scope.superior]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_ALL_SUPERIOR,
					"{*[core.dynaform.view.authfield.scope.all_superior]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_LOWER,
					"{*[core.dynaform.view.authfield.scope.lower]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_AUTHOR_ALL_LOWER,
					"{*[core.dynaform.view.authfield.scope.all_lower]*}");
			map.put(ViewConstant.AUTHFIELD_SCOPE_ITSELF,
					"{*[core.dynaform.view.authfield.scope.itself]*}");
		} else if (authField.contains("multiUserField")) {
			map.put(ViewConstant.AUTHFIELD_SCOPE_ITSELF,
					"{*[core.dynaform.view.authfield.scope.itself]*}");
		}

		// return DWRHtmlUtils.createOptions(map, selectFieldName, def);
		return map;
	}

	public Map<String, String> createFieldOptions(String formid) {
		Map<String, String> map = new LinkedHashMap<String, String>();
		map.put(" ", " ");
		map.put(ViewConstant.AUTHFIELD_AUTHOR, "{*[Author]*}");
		map.put(ViewConstant.AUTHFIELD_AUTHOR_DEFAULT_DEPT,
				"{*[Author]*}{*[Default]*}{*[Department]*}");
		map.put(ViewConstant.AUTHFIELD_AUDITOR, "{*[Auditor]*}");
		map.put(ViewConstant.AUTHFIELD_PROCESSED, "{*[Processed]*}");
		try {
			FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
			if (!StringUtil.isBlank(formid)) {
				if (!StringUtil.isBlank(formid)) {
					Form form = (Form) formService.doView(formid);
					if (form != null) {
						Collection<FormField> fields = form.getAllFields();
						for (Iterator<FormField> it = fields.iterator(); it
								.hasNext();) {
							FormField field = it.next();
							if (field instanceof DepartmentField) {
								map.put("departmentField_" + field.getName(),
										field.getName());
							} else if (field instanceof TreeDepartmentField) {
								map.put("treeTepartmentField_"
										+ field.getName(), field.getName());
							} else if (field instanceof UserField) {
								if ("multiSelect".equals(((UserField) field)
										.getSelectMode()))
									map
											.put("multiUserField_"
													+ field.getName(), field
													.getName());
								else if ("selectOne".equals(((UserField) field)
										.getSelectMode()))
									map.put("userField_" + field.getName(),
											field.getName());
							}
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return map;
	}



	/**
	 * 通过视图Id获取所在模块的Id
	 *
	 * @return ModuleId
	 *
	 * @throws Exception
	 */
	public String getModuleById(String viewId) throws Exception {

		ViewDesignTimeService process = DesignTimeServiceManager.viewDesignTimeService();
		AbstractView view = (AbstractView) process.doView(viewId);

		if(view != null){
			return view.getModule().getId();
		}
		return null;
	}

	/**
	 * 执行视图选择框确定回调脚本
	 *
	 * @param parameters
	 *            页面参数
	 * @param request
	 *            HTTP请求
	 * @return
	 */
	public String runViewDialogCallbackscript(Map<String, String> parameters,
											  HttpServletRequest request) {
		try {
			FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();;

			String formid = parameters.get("formid");
			String fieldid = parameters.get("fieldid");
			String docid = parameters.get("content.id");

			WebUser user = AuthTimeServiceManager.getWebUser(request);

			Form form = (Form) formService.doView(formid);
			if (form == null) {
				return "";
			}

			FormField field = form.findField(fieldid);
			if (field != null && field instanceof ViewDialogField) {
				String script = ((ViewDialogField) field).getCallbackScript();
				if (!StringUtil.isBlank(script)) {
					script = StringUtil.dencodeHTML(script);
					ParamsTable params = ParamsTable.convertHTTP(request);
					params.putAll(parameters);

					Document doc = null;
					if (!StringUtil.isBlank(docid)) {
						doc = (Document) MemoryCacheUtil
								.getFromPrivateSpace(docid, user);
						if (doc != null) {
							doc.setId(docid);
						}
					}
					doc = form.createDocument(doc, params,
							user);

					IRunner runner = JavaScriptFactory.getInstance(user
							.getSessionid(), form.getApplicationid());
					runner.initBSFManager(doc, params, user,
							new ArrayList<ValidateMessage>());

					Object result = runner.run(field,
							field.getScriptLable("callbackScript"), script);
					if (result instanceof org.mozilla.javascript.Undefined) {
						return "";
					}
					if(result!=null){
						return  String.valueOf(result);
					}else{
						return "";
					}

				}
			}
		} catch (Exception e) {
			return e.getMessage();
		}

		return "";
	}

	public String convertValuesMapToPage(Map<String, String> valuesMap)
			throws Exception {
		StringBuffer html = new StringBuffer();
		for (Iterator<Entry<String, String>> iter = valuesMap.entrySet()
				.iterator(); iter.hasNext();) {
			Entry<String, String> entry = iter.next();
			html.append("<input type='hidden' name='").append(entry.getKey())
					.append("' value='").append(entry.getValue()).append("'")
					.append(" />");
		}
		return html.toString();
	}


	public Map<String, String> get_viewListByModules4TabField(String moduleId)
			throws Exception {
		Map<String, String> map = new LinkedHashMap<String, String>();
		map.put("", "{*[Select]*}");

		ViewDesignTimeService vp = DesignTimeServiceManager.viewDesignTimeService();
		Collection<AbstractView> viewList = vp.getViewsByModule(moduleId, null);
		if (viewList != null) {
			for(AbstractView view : viewList){
				if(view instanceof ListView){
					map.put(view.getId(), view.getName());
				}
			}
		}
		return map;
	}
}
