package cn.myapps.runtime.dynaform.upload.servlet;

import cn.myapps.common.util.PropertyUtil;
import com.kinggrid.pdfviewer.PdfFileResource;
import org.apache.commons.io.IOUtils;

import java.io.*;
import java.util.*;

public class PdfResource extends PdfFileResource {

    private final static Map<String, String> PRE_MAP = new HashMap<String, String>();

    private String tmpFile;

    /**
     * 返回需要盖章或查看PDF：文件模式
     */
    public String getPdfFile() {
        return PropertyUtil.getPath() + documentId;
    }

    /**
     * 返回需要盖章或查看PDF：文件流模式
     */
    public InputStream getPdfFileStream() {
        System.out.println("文件流模式：getPdfFileStream");
        // 文件模式，返回null
        String fileName = PropertyUtil.getPath() + documentId;
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(fileName);
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return fileInputStream;
    }

    /**
     * 盖章后文件保存
     */
    public OutputStream getSavePdfFileSteam() {
        System.out.println(" 盖章后文件保存： getSavePdfFileSteam");
        tmpFile = PropertyUtil.getPath() + File.separator + UUID.randomUUID().toString();
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(tmpFile);
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(),e);
        }
        return fileOutputStream;
    }

    /**
     * 文档名称，记录日志时会使用
     */
    public String getDocumentName(){
        System.out.println(" 文档名称，记录日志时会使用：getDocumentName");
        return "document.pdf";
    }

    /**
     *  加盖、删除印章等操作成功会执行该方法
     *	1、可以实现覆盖原文档
     *  2、删除原文档等
     */
    public void success() {
        System.out.println(" 文档名称，记录日志时会使用： success");
        System.out.println("success action = " +  action);
        // 覆盖盖章后的文档
        if(tmpFile != null){
            saveFile();
        }
    }

    /**
     * 加盖、删除印章等操作失败时，删除临时文件
     */
    public void fail() {
        System.out.println("失败：fail");
        System.out.println("fail action = " +  action);
        if(tmpFile != null){
            File file = new File(tmpFile);
            if(file.exists())file.delete();
        }
    }

    /**
     * 覆盖原文档
     */
    private void saveFile(){
        System.out.println("覆盖原文档：saveFile");
        System.out.println("documentId = " + documentId);
        System.out.println("userId = " + userId);
        // 原文档路径
        String fileName = PropertyUtil.getPath() + documentId;
        FileOutputStream fileOutputStream = null;
        FileInputStream in = null;
        File file = new File(tmpFile);
        try{
            in = new FileInputStream(tmpFile);
            fileOutputStream = new FileOutputStream(fileName);
            IOUtils.copy(in, fileOutputStream);
        } catch (IOException e) {
            throw new RuntimeException(e.getMessage(),e);
        } finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(fileOutputStream);
            if(file.exists()) file.delete();
        }
    }

    /**
     * 域签名、电子签章，密钥盘签名时会先执行该方法，
     * 1、实现保存盖章未签名的文档
     * 2、签名完成后，需要在未签名的文档上（通过getPrePdfFile）加上签名值，覆盖该文档
     * 3、再执行success
     */
    public void preSuccess(){
        // 最好使用缓存机制（如：ehcache）, 超过30秒删除该缓存
        System.out.println("preSuccess");
        PRE_MAP.put(documentId, tmpFile);
    }

    public String getPrePdfFile(){
        System.out.println("getPrePdfFile");
        tmpFile = PRE_MAP.remove(documentId);
        return tmpFile;
    }

    @Override
    public List<String> getGBEsids() {
        System.out.println("getGBEsids");
        List<String> list = new ArrayList<String>();
        list.add("36000000000278");
        return list;
    }
}
