package cn.myapps.runtime.dynaform.form.ejb;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

import cn.myapps.runtime.dynaform.form.service.WordEditEnv;

@PersistJobDataAfterExecution // 当job执行结束，持久化job信息到数据库
@DisallowConcurrentExecution // 保证job的唯一性（单例）
public class WordFieldIsEditJob extends QuartzJobBean {
	
	public final static Logger LOG = LoggerFactory.getLogger(WordFieldIsEditJob.class);

	@Override
	protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
		try {
			Map<String,WordFieldIsEdit> map = WordEditEnv.wordFieldIsEdit;
			Date curDate = new Date(); // 当前日期
			if(!map.isEmpty()){
				Set<Entry<String, WordFieldIsEdit>> set = map.entrySet();
				for (Iterator<Entry<String, WordFieldIsEdit>> iterator = set.iterator(); iterator.hasNext();) {
					Entry<String, WordFieldIsEdit> entry = (Entry<String, WordFieldIsEdit>) iterator
							.next();
					String wordid = entry.getKey();
					WordFieldIsEdit word = entry.getValue();
					//把word激活时间与当前时间差2分钟以上的移除掉
					if(curDate.getTime() - word.getEditTime().getTime() >= WordFieldIsEdit.JOB_PEIROD){
						WordEditEnv.wordFieldIsEdit.remove(wordid);
					}
				}
			}
		} catch (Exception e) {
			LOG.error("WordFieldIsEdit Job Error: ", e);
		}
	}

}
