package cn.myapps.runtime.dynaform.form.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.dynaform.form.service.WordFieldRunTimeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

/**
 * wordfield RESTful 接口
 * @author spy
 */
@Api(tags = "work文档执行模块")
@Component
@RequestMapping(path = "/api/runtime/forms/wordfield", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class WordFieldController extends AbstractRuntimeController{
	
	@Autowired
	private WordFieldRunTimeService wordfieldService;
	
	/**
	 * 检查word文档是否可编辑
	 * @param wordid
	 * 		word文档id
	 * @return 
	 * @throws Exception
	 */
	@GetMapping("/edit")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "检查word文档是否可编辑", notes = "检查word文档是否可编辑")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "wordid",value = "word文档id",required = true,paramType = "query",dataType = "string")
	})
	public Resource checkWordFieldIsEdit(String wordid) throws Exception{
		JSONObject result = wordfieldService.checkWordFieldIsEdit(wordid, getUser());
		return success("ok", result);
	}
	
	/**
	 * 退出word文档编辑
	 * @param wordid
	 * 		word文档id
	 * @return
	 * @throws Exception
	 */
	@PutMapping("/exixtEdit")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "退出word文档编辑", notes = "退出word文档编辑")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "wordid",value = "word文档id",required = true,paramType = "query",dataType = "string")
	})
	public Resource exixtEdit(String wordid) throws Exception{
		wordfieldService.exixtEdit(wordid, getUser());
		return success("ok", null);
	}
}
