package cn.myapps.runtime.dynaform.form.controller;

import java.util.List;
import java.util.Map;

import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.stylerepository.StyleRepositoryVO;
import cn.myapps.runtime.dynaform.document.ejb.Document;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
/**
 * 表单模板信息
 */
@JsonInclude(Include.NON_EMPTY)
public class FormModel {
	
	/**
	 * 文档对象
	 */
	private Document document = null;

	/**
	 * 表单按钮集合
	 */
	private List<Activity> activities;

	/**
	 * 样式
	 */
	private StyleRepositoryVO style;

	/**
	 * 流程处理人
	 */
	private String approvers;

	/**
	 * 表单HTML模板
	 */
	private Map<String, Object> formTemplate;

	public FormModel(Document doc) {
		super();
		this.document = doc;
	}

	public Document getDocument() {
		return document;
	}

	public void setDocument(Document document) {
		this.document = document;
	}

	public List<Activity> getActivities() {
		return activities;
	}

	public void setActivities(List<Activity> activities) {
		this.activities = activities;
	}

	public StyleRepositoryVO getStyle() {
		return style;
	}

	public void setStyle(StyleRepositoryVO style) {
		this.style = style;
	}

	public String getApprovers() {
		return approvers;
	}

	public void setApprovers(String approvers) {
		this.approvers = approvers;
	}

	/**
	 * @return the formTemplate
	 */
	public Map<String, Object> getFormTemplate() {
		return formTemplate;
	}

	/**
	 * @param formTemplate the formTemplate to set
	 */
	public void setFormTemplate(Map<String, Object> formTemplate) {
		this.formTemplate = formTemplate;
	}
}
