package cn.myapps.runtime.dynaform.form.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.comment.CommentVO;
import cn.myapps.runtime.comment.CommentProcess;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;
import java.util.Date;

@Api(tags = "评论模块")
@Component
@RequestMapping(path = "/api/runtime/{applicationId}")
public class CommentController extends AbstractRuntimeController {

    /**
     * 获取评论统计
     * @param applicationId 软件id
     * @param flag         评论标识
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/flags/{flag}/comments/count")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取评论统计", notes = "获取评论统计")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "flag", value = "评论标识", required = true, paramType = "path", dataType = "string")})
    public Resource getCommentsCount(@PathVariable String applicationId, @PathVariable String flag) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess(applicationId);
        CommentVO comment = commentProcess.findByParentId(flag);
        if(comment == null){
            comment = new CommentVO();
            WebUser user = getUser();
            comment.setApplicationid(applicationId);
            comment.setFlag(flag);
            comment.setDomainid(user.getDomainid());
            comment.setUserId(user.getId());
            comment.setUserName(user.getName());
            comment.setCreateDate(new Date());
            comment.setParentId(flag);
            commentProcess.doCreate(comment);
        }
        JSONObject result = new JSONObject();
        result.put("commentNum", commentProcess.countCommentsByFlagAndParentId(flag, ""));
        result.put("likeNum", comment.getLikeNum());
        result.put("id", comment.getId());
        return success("ok", result);
    }

    /**
     * 获取评论列表
     * @param applicationId 软件id
     * @param flag         评论标识
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/flags/{flag}/comments")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取评论列表", notes = "获取评论列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "flag", value = "评论标识", required = true, paramType = "path", dataType = "string")})
    public Resource getComments(@PathVariable String applicationId, @PathVariable String flag) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess(applicationId);
        Collection<CommentVO> comments = commentProcess.getComments(flag);

        UserProcess userService = AuthTimeServiceManager.userRuntimeService();
        for(CommentVO comment : comments){
            UserVO user = (UserVO)userService.doView(comment.getUserId());
            if(user != null){
                comment.setAvatar(user.getAvatarUri());
            }
        }
        return success("ok", comments);
    }

    /**
     * 获取回复列表
     * @param applicationId 软件id
     * @param commentId     评论id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/comments/{commentId}/answers")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取回复列表", notes = "获取回复列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "commentId", value = "评论id", required = true, paramType = "path", dataType = "string")})
    public Resource getAnswers(@PathVariable String applicationId, @PathVariable String commentId) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess(applicationId);
        Collection<CommentVO> comments = commentProcess.getAnswers(commentId);

        UserProcess userService = AuthTimeServiceManager.userRuntimeService();
        for(CommentVO comment : comments){
            UserVO user = (UserVO)userService.doView(comment.getUserId());
            if(user != null){
                comment.setAvatar(user.getAvatarUri());
            }
        }
        return success("ok", comments);
    }

    /**
     * 新增评论
     * @param applicationId 软件id
     * @param flag         评论标识
     * @return
     * @throws Exception
     */
    @PostMapping(path = "/flags/{flag}/comments")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取文档", notes = "获取文档")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "flag", value = "评论标识", required = true, paramType = "path", dataType = "string")})
    public Resource createComment(@PathVariable String applicationId, @PathVariable String flag, @RequestBody CommentVO comment) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess(applicationId);
        WebUser user = getUser();
        comment.setApplicationid(applicationId);
        comment.setFlag(flag);
        comment.setDomainid(user.getDomainid());
        comment.setUserId(user.getId());
        comment.setUserName(user.getName());
        comment.setCreateDate(new Date());
        commentProcess.doCreate(comment);
        return success("ok", comment);
    }

    /**
     * 点赞
     * @param applicationId 软件id
     * @param commentId     评论id
     * @return
     * @throws Exception
     */
    @PutMapping(path = "/comments/{commentId}/like")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "点赞", notes = "点赞")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "commentId", value = "评论id", required = true, paramType = "path", dataType = "string")})
    public Resource likeComment(@PathVariable String applicationId, @PathVariable String commentId) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess(applicationId);
        CommentVO comment = commentProcess.find(commentId);
        comment.setLikeNum(comment.getLikeNum()+1);
        commentProcess.doUpdate(comment);
        return success("ok", comment.getLikeNum());
    }

    /**
     * 觉得不行
     * @param applicationId 软件id
     * @param commentId     评论id
     * @return
     * @throws Exception
     */
    @PutMapping(path = "/comments/{commentId}/unlike")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "觉得不行", notes = "觉得不行")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "commentId", value = "评论id", required = true, paramType = "path", dataType = "string")})
    public Resource unlikeComment(@PathVariable String applicationId, @PathVariable String commentId) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess(applicationId);
        CommentVO comment = commentProcess.find(commentId);
        comment.setUnlikeNum(comment.getUnlikeNum()+1);
        commentProcess.doUpdate(comment);
        return success("ok", comment.getUnlikeNum());
    }
}
