package cn.myapps.runtime.domain.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.model.SystemModuleConfig;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author spy
 */
@Api(tags = "企业域模块")
@Component
@RequestMapping(path = {"/api/runtime","/api/portal/domain"}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class DomainController extends AbstractRuntimeController{

    /**
     * 获取企业域列表
     * @return
     * @throws Exception
     */
    @GetMapping("/domains")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取企业域列表", notes = "获取企业域列表")
    public Resource getDomianList() throws Exception{
        DomainVO domainVO = getUser().getDomain();

        List<Map<String, String>> result = new ArrayList<Map<String,String>>();

        Map<String, String> map = new HashMap<String, String>();
        map.put("id", domainVO.getId());
        map.put("name", domainVO.getName());
        result.add(map);
        return success("ok", result);
    }


    /**
     * 获取km的团队和专委会是否点击打开
     */
    @GetMapping(path = "/domains/realmAndTeam", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取环信配置信息", notes = "获取环信配置信息")
    public Map doGetKMTeamAndRealm() {
        Map<String,Object> maps=new HashMap<String,Object>();
        try {
        	IUser user = getUser();
            String domainId = user.getDomainid();
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainId);

            if (domain.isEnable(SystemModuleConfig.KMTEAM)) {
                maps.put("kmTeam", true);
            }else{
                maps.put("kmTeam", false);
            }
            if (domain.isEnable(SystemModuleConfig.KMREALM)) {
                maps.put("kmRealm", true);
            }else{
                maps.put("kmRealm", false);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return maps;
    }

    @GetMapping(value = "/{domainId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "根据企业域id获取企业域信息", notes = "根据企业域id获取企业域信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainId",value = "企业域id",required = true,paramType = "path",dataType = "string")
    })
    public DomainVO getDoamin(@PathVariable String domainId) throws Exception{
        DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
        DomainVO domainVO = (DomainVO) domainProcess.doView(domainId);

        DomainVO domain = (DomainVO) BeanUtils.cloneBean(domainVO);
        if(!StringUtil.isBlank(domain.getLogoUrl())){
            String logoUrl = domain.getLogoUrl();
            if(logoUrl.indexOf("/upload/") > -1){
                logoUrl = "/upload" + logoUrl.substring(logoUrl.lastIndexOf("/"), logoUrl.length());
            } else {
                logoUrl = logoUrl.substring(logoUrl.lastIndexOf("/"), logoUrl.length());
            }
            domain.setLogoUrl(logoUrl);
        }
        return domain;
    }
}
