package cn.myapps.runtime.department.service;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.tree.DepartmentNode;
import cn.myapps.common.data.tree.Node;
import cn.myapps.common.data.tree.UserNode;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.common.utils.Pager;

import java.util.*;

public class DepartmentRunTimeServiceImpl implements DepartmentRunTimeService {
	
	@Override
	public List<Node> getDepartmentListTree(IUser webUser, String parentId, String applicationId, int level, boolean belong)
			throws Exception {
		List<Node> avatars = new ArrayList<Node>();
		DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
		if (StringUtil.isBlank(parentId)) {
			if (level < 0) {
				if (belong) {
					
//					Collection<DepartmentVO> userDepartmentList = webUser.getDepartments();
					Collection<DepartmentVO> userDepartmentList = process.queryByUser(webUser.getId());
					for (Iterator<DepartmentVO> iterator = userDepartmentList.iterator(); iterator.hasNext();) {
						DepartmentVO departmentVO = iterator.next();
						DepartmentNode d = new DepartmentNode();
						d.setId(departmentVO.getId());
						d.setName(departmentVO.getName());
						d.setCode(departmentVO.getCode());
						d.setLevel(departmentVO.getLevel());
						avatars.add(d);
						return avatars;
					}
				}
				DepartmentVO departmentVO = process.getRootDepartmentByDomainId(webUser.getDomainid());
				DepartmentNode d = new DepartmentNode();
				d.setId(departmentVO.getId());
				d.setName(departmentVO.getName());
				d.setCode(departmentVO.getCode());
				d.setLevel(departmentVO.getLevel());
				avatars.add(d);
				return avatars;
			}else {
				return null;
			}
		} else {
			if (level < 0) {
				List<DepartmentVO> departments = (List<DepartmentVO>) process.getDatasByParent(parentId);
				for (Iterator<DepartmentVO> iterator = departments.iterator(); iterator.hasNext();) {
					DepartmentVO departmentVO = iterator.next();
					DepartmentNode d = new DepartmentNode();
					d.setId(departmentVO.getId());
					d.setName(departmentVO.getName());
					d.setCode(departmentVO.getCode());
					d.setLevel(departmentVO.getLevel());
					avatars.add(d);
				}
				return avatars;
			} else {
				List<DepartmentVO> departments = (List<DepartmentVO>) process.getDatasByParent(parentId);
				for (Iterator<DepartmentVO> iterator = departments.iterator(); iterator.hasNext();) {
					DepartmentVO departmentVO = iterator.next();
					DepartmentNode d = new DepartmentNode();
					d.setId(departmentVO.getId());
					d.setName(departmentVO.getName());
					d.setCode(departmentVO.getCode());
					d.setLevel(departmentVO.getLevel());
					
					if (level == departmentVO.getLevel()) {
						avatars.add(d);
						continue;
					}
				}
				return avatars;
			}
		}
	}
	
	@Override
	public Map<String, Object> getDepartmentAndUsers(String applicationId, String deptId, IUser user, boolean isFromMail, Integer pageSize, Integer pageNum) throws Exception{
		List<Node> avatars = new ArrayList<Node>();
		DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
		if (StringUtil.isBlank(deptId)) {
			List<DepartmentVO> departments = (List<DepartmentVO>) process.queryByDomain(user.getDomainid());
			for (Iterator<DepartmentVO> iterator = departments.iterator(); iterator.hasNext();) {
				DepartmentVO departmentVO = iterator.next();
				DepartmentNode d = new DepartmentNode();
				d.setId(departmentVO.getId());
				d.setName(departmentVO.getName());
				d.setCode(departmentVO.getCode());
				d.setLevel(departmentVO.getLevel());
				avatars.add(d);
			}
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("datas", avatars);
			return map;
		}else {
			UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
			DepartmentVO parent = (DepartmentVO) process.doView(deptId);
			List<UserVO> users = (List<UserVO>) userProcess.queryByDepartment(deptId);
			for(Iterator<UserVO> iterator = users.iterator(); iterator.hasNext(); ){
				UserVO userVO= iterator.next();
				if(isFromMail && StringUtil.isBlank(userVO.getEmail())){
					continue;
				}
				UserNode u = new UserNode();
				u.setId(userVO.getId());
				u.setName(userVO.getName());
				u.setMobile(userVO.getTelephone());
				u.setMobile2(userVO.getTelephone2());
				u.setEmail(userVO.getEmail());
				u.setLoginNo(userVO.getLoginno());
				u.setAvatar(userVO.getAvatarUri());
				u.setDeptId(parent.getId());
				u.setDept(parent.getName());
				u.setDomainId(userVO.getDomainid());
				avatars.add(u);
			}
			Pager<Node> pager = Pager.create(avatars, pageSize);
			List<Node> datas = pager.getPagedList(pageNum);
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("datas", datas);
			map.put("pageCount", pager.getPageCount());
			map.put("linesPerPage", pageSize);
			map.put("rowCount", avatars.size());
			map.put("pageNum", pageNum);
			return map;
		}
	}
	
	@Override
	public List<Node> searchDeptTree(String applicationId, String domainId, String keyword, IUser user) throws Exception{
		List<Node> avatars = new ArrayList<Node>();
		DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
//		String hql = "from " + DepartmentVO.class.getName() + " where name like :keyword ";
//		Map<String,Object> sqlParameterMap = new HashMap<String,Object>();
//		sqlParameterMap.put("keyword", "%"+keyword+"%");
//		Collection<DepartmentVO> departments = process.doQueryByHQL(hql, 1, Integer.MAX_VALUE,sqlParameterMap);
		Collection<DepartmentVO> departments = process.doQueryByDomainLikeName(domainId, keyword);
		for (DepartmentVO dept : departments) {
			DepartmentNode d = new DepartmentNode();
			d.setId(dept.getId());
			d.setName(dept.getName());
			d.setCode(dept.getCode());
			d.setLevel(dept.getLevel());
			if (dept.getSuperior()!=null) {
				d.setParentid(dept.getSuperior().getId());
			}
			avatars.add(d);
		}
		return avatars;
	}
	
}
