package cn.myapps.runtime.department.service;

import java.util.List;
import java.util.Map;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.tree.Node;

public interface DepartmentRunTimeService {

	/**
	 * 根据父级部门id获取部门集合
	 * @param webUser
	 * 			用户
	 * @param parentId
	 * 			父级部门id
	 * @param applictaionId
	 * 			软件id
	 * @return
	 * 			树形结构部门集合
	 * @throws Exception
	 */
	List<Node> getDepartmentListTree(IUser webUser, String parentId, String applicationId, int level, boolean belong) throws Exception;

	/**
	 * 根据父级部门id获取部门用户集合
	 * @param applicationId
	 * 		软件id
	 * @param deptId
	 * 		部门id
	 * @param isFromMail
	 * 	    是否邮件调用
	 * @param pageSize
	 * 		每页显示数据数
	 * @param pageNum
	 * 		当前页
	 * @return
	 * 		部门或用户集合
	 * @throws Exception
	 */
	Map<String, Object> getDepartmentAndUsers(String applicationId, String deptId, IUser user, boolean isFromMail, Integer pageSize, Integer pageNum) throws Exception;

	/**
	 * 部门搜索功能
	 * @param applicationId
	 * 		软件id
	 * @param domainId
	 * 		企业域id
	 * @param keyword
	 * 		搜索关键字
	 * @param user
	 * @return
	 * 		部门集合
	 * @throws Exception
	 */
	List<Node> searchDeptTree(String applicationId, String domainId, String keyword, IUser user)
			throws Exception;

}
