package cn.myapps.runtime.department.controller;


import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentHelper;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.department.service.DepartmentRunTimeService;
import io.swagger.annotations.Api;

/**
 * 部门RESTful接口
 * @author oliver
 */
@Api(tags = "部门执行模块")
@Component
@RequestMapping(path = "/api/runtime/department", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class DepartmentController extends AbstractRuntimeController{

    @Autowired
    private DepartmentRunTimeService deptService;

    /**
     * 根据企业域获取部门集合
     * @return
     * @throws Exception
     */
    @GetMapping("/list")
    @ResponseStatus(HttpStatus.OK)
    public Resource getDepartmentListByDomain() throws Exception {
    	IUser user = getUser();
        DepartmentHelper departmentHelper = new DepartmentHelper();
        Collection<DepartmentVO> departmentList = departmentHelper.getDepartmentListByDomain(user.getDomainid());
        return success("ok", departmentList);
    }
}
