package cn.myapps.runtime.chart.service;

import java.util.Collection;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.chart.Chart;
import cn.myapps.runtime.common.service.RunTimeFileService;
import cn.myapps.runtime.dynaform.document.model.IDocument;

public interface ChartService extends RunTimeFileService<Chart> {

	public String getAllChart(String applicationid,String moduleid,String flag,String userid) throws Exception;

	public String getChart(String id) throws Exception;
	public Collection<Chart> getChartByApplication(String applicationId) throws Exception;
	/**
	 * 根据数据文档对象的ID标识查找数据文档对象.
	 *
	 * @param pk
	 *            数据文档对象ID标识.
	 * @return 数据文档对象.
	 * @throws Exception
	 */
	public Chart doView(String pk) throws Exception;

	/**
	 * 将Chart编译成EChart所需要的option字符串，输出给网页端构建图表
	 * @param chart
	 * @return
	 */
	public Object buildEChartOption(Chart chart, ParamsTable params, IUser user, IDocument doc) throws Exception;
	
	/**
	 * 创建数据文档对象
	 *
	 * @param object
	 *            数据文档对象.
	 * @throws Exception
	 */
	public void doCreate(Chart object) throws Exception;
	
	/**
	 * 更新数据文档对象.
	 *
	 * @param object
	 *            数据文档对象.
	 * @throws Exception
	 */
	public void doUpdate(Chart object) throws Exception;
	
	/**
	 * 移除数据文档对象
	 *
	 * @param vo
	 *            数据文档对象.
	 * @throws Exception
	 */
	@Deprecated
	public void doRemove(Chart vo) throws Exception;
	
	/**
	 * 移除数据文档对象
	 *
	 * @param pk
	 *            数据文档对象ID标识.
	 * @throws Exception
	 */
	public void doRemove(String pk) throws Exception;
}
