package cn.myapps.runtime.application.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.RoleConstant;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.application.Application;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.requests.RefreshDesignRequest;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Application Restful 接口
 * 
 * @author ahan
 *
 */
@Api(tags = "软件执行模块")
@Component
@RequestMapping(path = "/api/runtime", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ApplicationController extends AbstractRuntimeController {

	private static final Logger LOG = LoggerFactory.getLogger(ApplicationController.class);

	private ApplicationDesignTimeService service = null;

	public ApplicationController() {
		try {
			service = DesignTimeServiceManager.applicationDesignTimeService();
		} catch (Exception e) {
			LOG.error(e.getMessage());
		}
	}

	/**
	 * 获取软件列表
	 */
	@GetMapping("/applications")
	@ApiOperation(value = "获取软件列表", notes = "获取软件列表")
	public Resource doGetApplications() throws Exception {
		try {
			JSONObject result = new JSONObject();
			IUser webUser = getUser();
			List<Application> list = service.getListByWebUser(webUser);

			String domainId = webUser.getDomainid();
			DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
			DomainVO domain = (DomainVO) domainProcess.doView(domainId);

			List<String> kmRoleIds = AuthTimeServiceManager.userRuntimeService().listKmRoleIdsByUserId(webUser.getId());
			if (domain.isEnable(Application.KM_APPLICATION_ID) && kmRoleIds.size() != 0
					&& (kmRoleIds.contains(RoleConstant.ID_SUPER) || kmRoleIds.contains(RoleConstant.ID_DEPARTMENT_ADMIN)
					|| kmRoleIds.contains(RoleConstant.ID_COMMITTEE_ADMIN) || kmRoleIds.contains(RoleConstant.ID_NORMAL))) {
				Application app = new Application();
				app.setId("km");
				app.setName("知识文档管理");
				list.add(app);
			}

			if (domain.isEnable(Application.QM_APPLICATION_ID)) {
				Application app = new Application();
				app.setId("qm");
				app.setName("调查问卷");
				list.add(app);
			}
			result.put("applications", list);
			result.put("flowCenter", domain.isEnable(Application.FC_APPLICATION_ID));
			return success("ok", result);
		} catch (Exception ex) {
			return error(ex);
		}
	}

	/**
	 * 获取系统软件列表
	 */
	@GetMapping("/applications/sysapplications")
	@ApiOperation(value = "获取系统软件列表", notes = "获取系统软件列表")
	public Resource doGetSysApplications() {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		try {
			String domainId = getUser().getDomainid();
			DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
			DomainVO domain = (DomainVO) domainProcess.doView(domainId);

			if (domain.isEnable(Application.KM_APPLICATION_ID)) {
				Map<String, Object> map = new HashMap<String, Object>();
				map.put("id", "km");
				map.put("name", "知识文档管理");
				list.add(map);
			}
//			if (systemModuleConfig.isPmEnable()) {
//				Map<String, Object> map = new HashMap<String, Object>();
//				map.put("id", "pm");
//				map.put("name", "任务");
//				list.add(map);
//			}
//			if (systemModuleConfig.isQmEnable()) {
//				Map<String, Object> map = new HashMap<String, Object>();
//				map.put("id", "qm");
//				map.put("name", "调查问卷");
//				list.add(map);
//			}
		} catch (Exception e) {
			LOG.error(e.getMessage());
		}
		return success("ok", list);
	}

	@PutMapping("/applications/{id}/components/do-refresh")
	@ApiOperation(value = "更新组件的刷新", notes = "更新组件的刷新")
	public Resource doUpdateAppComponents(@PathVariable String id,
										  @RequestBody RefreshDesignRequest request) {
		boolean result = DesignTimeSerializableCache.doRefreshWrapperObject(id, request);

		return Resource.ok(result);
	}
}
