package cn.myapps.runtime.activity.service;

import java.io.OutputStream;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.form.FormDataPacket;

/**
 * Activity Service 接口
 * 
 * @author ahan
 *
 */
public interface ActivityRunTimeService {

	/**
	 * 执行运行前脚本
	 * @param id
	 *     按钮id
	 * @return
	 * @throws Exception
	 */
	JSONObject runbeforeactionscript(String applicationId,String id, Document doc, ParamsTable params, IUser user) throws Exception;

	/**
	 * 执行运行后脚本
	 * @param id
	 *      按钮id
	 * @return
	 * @throws Exception
	 */
	JSONObject runafteractionscript(String id, String applicationId, String content, ParamsTable params, IUser user) throws Exception;

	/**
	 * 执行自定义按钮动作执行脚本
	 * @param id
	 *      按钮id
	 * @return
	 * @throws Exception
	 */
	JSONObject execute(String applicationId, String id, String content, ParamsTable params, IUser user) throws Exception;
	
	/**
	 * 归档操作
	 * @param applicationId
	 * 		软件id
	 * @param docId
	 * 		文档id
	 * @param user
	 * 		用户对象
	 * @param params
	 * 		参数表
	 * @return
	 * @throws Exception
	 */
	String archive(String applicationId, String docId, IUser user, ParamsTable params) throws Exception;

	/**
	 * 保存文档并启动流程
	 * @param applicationId
	 * 		软件id
	 * @param Document
	 * 		文档对象
	 * @param user
	 * 		当前登陆用户
	 * @param params
	 * 		参数表
	 * @param attitude
	 * 		提交意见
	 * @param versions
	 * 		文档版本
	 * @param flowId
	 * 		流程id
	 * @throws Exception
	 */
	Document saveStartWorkFlow(String applicationId, Document doc, IUser user, ParamsTable params) throws Exception;

	/**
	 * 复制按钮
	 * @param applicationId
	 * 		软件id
	 * @param doc
	 * 		文档
	 * @param user
	 * 		当前用户信息
	 * @param params
	 * 		参数表
	 * @return
	 * @throws Exception
	 */
	Document copy(String applicationId, Document doc, IUser user, ParamsTable params) throws Exception;

	/**
	 * 清楚所有数据按钮
	 * @param applicationId
	 * 		软件id
	 * @param user
	 * 		用户对象
	 * @param formId
	 * 		表单id
	 * @throws Exception
	 */
	void clear(String applicationId, IUser user, String formId) throws Exception;

	/**
	 * 导出excel
	 * @param viewId	
	 * 		视图id
	 * @param actId
	 * 		按钮id
	 * @param user
	 * 		当前登陆用户对象
	 * @param params
	 * 		参数表
	 * @return
	 * @throws Exception
	 */
	String exportExcel(String viewId, String actId,
			IUser user, ParamsTable params,OutputStream outputStream,String[] ids)
			throws Exception;
	

	/**
	 * 通过邮件或手机短信分享按钮
	 * @param applicationId
	 * 		软件id
	 * @param docId
	 * 		文档id
	 * @param user
	 * 		当前登陆用户对象
	 * @param params
	 * 		参数表
	 * @return
	 * 		成功返回已发送，失败返回null
	 * @throws Exception
	 */
	String share(String applicationId, String docId, IUser user,
			ParamsTable params, String transpond, String handleUrl, String receiverid,  Boolean email, Boolean msm) throws Exception;

	/**
	 * 批量提交按钮
	 * @param applicationId
	 * 		软件id
	 * @param limistStrList
	 * 		下一个节点限制列表
	 * @param docIds
	 * 		文档id数组
	 * @param actId
	 * 		按钮id
	 * @param attitude
	 * 		意见
	 * @param remark
	 * 		评论
	 * @param params
	 * 		参数表
	 * @param user
	 * 		当前登陆用户
	 * @return
	 * @throws Exception
	 */
	net.sf.json.JSONObject batchApprove(String applicationId, String limistStrList,
			String[] docIds, String actId, String attitude, String remark, ParamsTable params, IUser user) throws Exception;

	
	/**
	 * 打印
	 * @param applicationId
	 * 		软件id
	 * @param formId
	 * 		表单id
	 * @param docId
	 * 		文档id
	 * @param params
	 * 		参数表
	 * @param user
	 * 		当前登陆用户对象
	 * @return
	 * @throws Exception
	 */
	FormDataPacket print(String applicationId, String formId, String docId, ParamsTable params, IUser user) throws Exception;

	/**
	 * 导入Excel
	 * @param impmappingconfigid
	 * 		模板id
	 * @param path
	 * 		上传文件路径
	 * @param user
	 * 		当前登陆用户对象
	 * @param params
	 * 		参数表
	 * @param actId
	 * 		按钮id
	 * @param viewId
	 * 		视图id
	 * @throws Exception
	 */
	String improtExcel(String applicationId, String impmappingconfigid, String path, IUser user,
			ParamsTable params, String actId, String viewId) throws Exception;

	/**
	 * 导入Excel
	 * @param impmappingconfigid
	 * 		模板id
	 * @param path
	 * 		上传文件路径
	 * @param user
	 * 		当前登陆用户对象
	 * @param params
	 * 		参数表
	 * @param actId
	 * 		按钮id
	 * @param viewId
	 * 		视图id
	 * @throws Exception
	 */
	String validationExcel(String applicationId, String impmappingconfigid, String path, IUser user,
						   ParamsTable params, String actId, String viewId) throws Exception;

	/**
	 * 执行地址脚本
	 * @param applicationId
	 *  	软件id
	 * @param actId
	 * 		按钮id
	 * @param docId
	 * 		文档id
	 * @return
	 * @throws Exception
	 */
	JSONObject executeAddress(String applicationId, String actId, ParamsTable params,
			IUser user, String docId) throws Exception;
}
