/*
 * DynamicReports - Free Java reporting library for creating reports dynamically
 *
 * Copyright (C) 2010 - 2018 Ricardo Mariaca and the Dynamic Reports Contributors
 * http://www.dynamicreports.org
 *
 * This file is part of DynamicReports.
 *
 * DynamicReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DynamicReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with DynamicReports. If not, see <http://www.gnu.org/licenses/>.
 */
package cn.myapps.report.examples.templatedesign;

import cn.myapps.report.examples.Templates;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import static net.sf.dynamicreports.report.builder.DynamicReports.col;
import static net.sf.dynamicreports.report.builder.DynamicReports.report;
import static net.sf.dynamicreports.report.builder.DynamicReports.type;

/**
 * <p>JasperTemplateDesignReport1 class.</p>
 *
 * @author Ricardo Mariaca (r.mariaca@dynamicreports.org)
 * @version $Id: $Id
 */
public class JasperTemplateDesignReport1 {

    /**
     * <p>Constructor for JasperTemplateDesignReport1.</p>
     */
    public JasperTemplateDesignReport1() {
        build();
    }

    /**
     * <p>main.</p>
     *
     * @param args an array of {@link java.lang.String} objects.
     */
    public static void main(String[] args) {
        new JasperTemplateDesignReport1();
    }

    private void build() {
        try {
        //InputStream is = JasperTemplateDesignReport1.class.getResourceAsStream("templatedesign1.jrxml");

            DRDataSource dataSource = new DRDataSource("item", "quantity", "unitprice");
            for (int i = 0; i < 10; i++) {
                dataSource.add("Book", (int) (Math.random() * 10) + 1, (int) (Math.random() * 100) + 1);
            }
            
        File file = new File("D:/myapp_v4.2_workspace/trunk2018/obpm-demo/uploads/reports/templatedesign1.jrxml");
        InputStream is = new FileInputStream(file);
       
            report().setTemplate(Templates.reportTemplate)
                    .setTemplateDesign(is)
                    .columns(col.column("Item", "item", type.stringType()), col.column("Quantity", "quantity", type.integerType()), col.column("Unit price", "unitprice", type.integerType()))
                    .title(Templates.createTitleComponent("JasperTemplateDesign1"))
                    .setDataSource(dataSource)
                    .show();
        } catch (DRException e) {
            e.printStackTrace();
        } catch (Exception e ) {
        	e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource("item", "quantity", "unitprice");
        for (int i = 0; i < 10; i++) {
            dataSource.add("Book", (int) (Math.random() * 10) + 1, (int) (Math.random() * 100) + 1);
        }
        return dataSource;
    }
}
