package cn.myapps.report.examples;

import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;

import java.math.BigDecimal;

public class UnitPriceSubtotal extends AbstractSimpleExpression<BigDecimal> {
    private static final long serialVersionUID = 1L;
    private DRIValue<Integer> quantitySum;
    private DRIValue<BigDecimal> priceSum;

    public UnitPriceSubtotal(DRIValue<Integer> quantitySum, DRIValue<BigDecimal> priceSum) {

        this.quantitySum = quantitySum;
        this.priceSum = priceSum;
    }

    @Override
    public BigDecimal evaluate(ReportParameters reportParameters) {
        Integer quantitySumValue = reportParameters.getValue(quantitySum);
        BigDecimal priceSumValue = reportParameters.getValue(priceSum);
        return priceSumValue.divide(new BigDecimal(quantitySumValue), 2, BigDecimal.ROUND_HALF_UP);
    }
}
