package cn.myapps.report.examples;

import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.renderer.category.BarRenderer;

import java.awt.*;
import java.io.Serializable;

public class ChartCustomizer implements DRIChartCustomizer, Serializable {
    private static final long serialVersionUID = 1L;

    private String name;

    public ChartCustomizer(String name) {
        this.name = name;
    }

    @Override
    public void customize(JFreeChart chart, ReportParameters reportParameters) {
        BarRenderer renderer = (BarRenderer) chart.getCategoryPlot().getRenderer();
        if("ChartCustomizerReport".equals(name)){
            //设置阴影颜色
            renderer.setShadowPaint(Color.LIGHT_GRAY);
            //设置阴影是否可见
            renderer.setShadowVisible(true);
            CategoryAxis domainAxis = chart.getCategoryPlot().getDomainAxis();
            //设置x轴的标签倾斜
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions(Math.PI / 6.0));
        }else if("ChartLayoutReport".equals(name)) {
            renderer.setBaseItemLabelGenerator(new StandardCategoryItemLabelGenerator());
            renderer.setBaseItemLabelsVisible(true);
        }
    }
}
