package cn.myapps.report.examples;

import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;

import java.util.Date;

import static net.sf.dynamicreports.report.builder.DynamicReports.type;

public class CategoryExpression extends AbstractSimpleExpression<String> {
    private static final long serialVersionUID = 1L;
    private DRIValue<Date> date;

    public CategoryExpression(DRIValue<Date> date) {
        this.date = date;
    }

    @Override
    public String evaluate(ReportParameters reportParameters) {
        return type.dateYearToMonthType().valueToString(date, reportParameters);
    }
}
