package cn.myapps.conf;

import cn.myapps.components.HmacComponent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import cn.myapps.authtime.user.service.UserRunTimeService;
import cn.myapps.authtime.user.service.UserRunTimeServiceImpl;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.activity.service.ActivityRunTimeService;
import cn.myapps.runtime.activity.service.ActivityRunTimeServiceImpl;
import cn.myapps.runtime.department.service.DepartmentRunTimeService;
import cn.myapps.runtime.department.service.DepartmentRunTimeServiceImpl;
import cn.myapps.runtime.dynaform.form.service.FormRunTimeService;
import cn.myapps.runtime.dynaform.form.service.FormRunTimeServiceImpl;
import cn.myapps.runtime.dynaform.form.service.WordFieldRunTimeService;
import cn.myapps.runtime.dynaform.form.service.WordFieldRunTimeServiceImpl;
import cn.myapps.runtime.dynaform.view.service.ViewHelperRunTimeService;
import cn.myapps.runtime.dynaform.view.service.ViewHelperRunTimeServiceImpl;
import cn.myapps.runtime.flowcenter.service.FlowCenterRumTimeService;
import cn.myapps.runtime.flowcenter.service.FlowCenterRunTimeServiceImpl;
import cn.myapps.runtime.form.service.FormHelperRunTimeService;
import cn.myapps.runtime.form.service.FormHelperRunTimeServiceImpl;
import cn.myapps.runtime.rest.workflow.service.WorkflowExecuteService;
import cn.myapps.runtime.rest.workflow.service.WorkflowExecuteServiceImpl;
import cn.myapps.runtime.widget.service.PageWidgetRunTimeService;
import cn.myapps.runtime.widget.service.PageWidgetRunTimeServiceImpl;
import cn.myapps.runtime.workflow.service.WorkflowRunTimeService;
import cn.myapps.runtime.workflow.service.WorkflowRunTimeServiceImpl;

/**
 * RunTime Service层配置类
 * 
 * @author ahan
 *
 */
@Configuration
public class RunTimeServiceConfig {
	
	@Bean
	public ActivityRunTimeService activityService() {
		return new ActivityRunTimeServiceImpl();
	}

	@Bean
	public FormRunTimeService formRunTimeService(){
		return new FormRunTimeServiceImpl();
	}

	@Bean
	public ViewDesignTimeService viewRunTimeService(){
		return DesignTimeServiceManager.viewDesignTimeService();
	}

	@Bean
	public WorkflowRunTimeService workflowService(){
		return new WorkflowRunTimeServiceImpl();
	}
	
	@Bean
	public UserRunTimeService userService(){
		return new UserRunTimeServiceImpl();
	}
	
/*    @Bean
    public Environment environment(){
    	return Environment.getInstance();
    }*/
    
    @Bean
    public DepartmentRunTimeService deptService(){
    	return new DepartmentRunTimeServiceImpl();
    }
    
    @Bean
    public WordFieldRunTimeService wordfieldService(){
    	return new WordFieldRunTimeServiceImpl();
    }

	@Bean
	public PageWidgetRunTimeService pageWidgetRunTimeService(){
		return new PageWidgetRunTimeServiceImpl();
	}
	
	@Bean
    public FlowCenterRumTimeService flowCenterService(){
    	return new FlowCenterRunTimeServiceImpl();
    }
	
//	@Bean
//	public MessageRunTimeService messageService(){
//		return new MessageRunTimeServiceImpl();
//	}
	
	@Bean
	public WorkflowExecuteService workflowExecuteService(){
		return new WorkflowExecuteServiceImpl();
	}

	@Bean
	public ViewHelperRunTimeService viewHelperRunTimeService(){ return new ViewHelperRunTimeServiceImpl(); }

	@Bean
	public FormHelperRunTimeService formHelperRunTimeService(){ return new FormHelperRunTimeServiceImpl(); }

	@Bean
	public HmacComponent hmacComponent() {
		return new HmacComponent();
	}
}
