package cn.myapps.conf;

import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.notice.Notice;
import cn.myapps.runtime.notice.Notification;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

import java.util.Map;


@FeignClient(name = "obpm-message")
@Component
public interface NoticeApi {
	@PostMapping(path = "/message/api/message/notice", consumes = "application/json", produces = "application/json")
	public void createNotice(@RequestBody Notice noticeJson);

	@PostMapping(path = "/message/api/message/notification", consumes = "application/json", produces = "application/json")
	public void createNotification(@RequestBody Notification notification);

	@PostMapping(path = "/message/api/message/messages/create", consumes = "application/json", produces = "application/json")
	public void createMessage(@RequestParam("receiverids") String receiverids,@RequestParam("title") String title,
							  @RequestParam("content") String content,@RequestParam("userId") String userId);

	@GetMapping(path = "/message/api/message/notice", consumes = "application/json", produces = "application/json")
	Map<String, Object> getNotices(@RequestParam String readStatus, @RequestParam int _currpage, @RequestParam int _rowcount);

	@DeleteMapping(path = "/message/api/message/notice", consumes = "application/json", produces = "application/json")
	void removeNotice(@RequestParam("noticeId") String noticeId);

	@PutMapping(path = "/message/api/message/notice/read", consumes = "application/json", produces = "application/json")
	void readNotice(@RequestParam("noticeId") String noticeId);

	@GetMapping(value = "/api/runtime/department/list")
	Resource getDepartmentUsers();
}
