package cn.myapps.conf;

import cn.myapps.base.web.filter.SecurityFilter;
import cn.myapps.base.web.interceptor.ActionInterceptor;
import cn.myapps.base.web.listener.SessionListener;
import cn.myapps.common.RequestBodyParamResolverImpl;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.components.HmacComponent;
import cn.myapps.interceptor.PersistenceHandlerInterceptor;
import cn.myapps.listener.ApplicationContextEventListener;
import cn.myapps.runtime.dynaform.form.QRCodeFiledScanEventHandlerServlet;
import cn.myapps.runtime.dynaform.form.QRCodeFiledScanEventReadyServlet;
import cn.myapps.runtime.dynaform.upload.servlet.*;
import cn.myapps.runtime.onlinetakephoto.OnLineTakePhotoServlet;
import cn.myapps.runtime.rest.security.RestSecurityHandlerInterceptor;
import cn.myapps.support.tray.action.BreakpointUploadServlet;
import cn.myapps.util.CheckCodeServlet;
import com.bcxin.intercepters.HmacAuthInterceptor;
import com.bcxin.saas.core.InjectResolver;
import org.apache.axis.transport.http.AdminServlet;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.util.List;

@Configuration
public class MyappsMvcConfig extends WebMvcConfigurerAdapter {
	private final HmacAuthInterceptor hmacAuthInterceptor;

	public MyappsMvcConfig(HmacAuthInterceptor hmacAuthInterceptor) {
		this.hmacAuthInterceptor = hmacAuthInterceptor;
	}

	@Bean
	public CommonsMultipartResolver multipartResolver() {
		CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
		multipartResolver.setMaxUploadSize(-1);// 不限制上传文件大小
		return multipartResolver;
	}

	@Override//全局统一异常处理
	public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {
		resolvers.add(new CommonsExceptionResolver());
	}

	@Override
	public void addResourceHandlers(ResourceHandlerRegistry registry) {
		registry.addResourceHandler("/**").addResourceLocations("classpath:/static/").addResourceLocations("/");
		String uploadsFolderPath = PropertyUtil.getPath() + "/uploads/";
		registry.addResourceHandler("/uploads/**")
				.addResourceLocations("file:///" + uploadsFolderPath);

		super.addResourceHandlers(registry);
	}


	@Override
	public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {

		argumentResolvers.add(new RequestBodyParamResolverImpl());

		super.addArgumentResolvers(argumentResolvers);
	}

	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		super.addInterceptors(registry);

		System.err.println("good girl, this is MyappsMvcConfig.java =====AAA");

		//旧的action拦截器，要删掉，好像还有message在用
		registry.addInterceptor(new ActionInterceptor()).addPathPatterns("/**/*.action")
				.excludePathPatterns("/static/**");

		//获取restful接口的拦截器
		registry.addInterceptor(new RestSecurityHandlerInterceptor()).addPathPatterns("/api/runtime/**", "/api/runtime-ex/**").addPathPatterns("/rest/bpm/**")
				.excludePathPatterns("/static/**").excludePathPatterns("/runtime/app/**");

		//DAO资源清理拦截器,关闭数据库连接等
		registry.addInterceptor(new PersistenceHandlerInterceptor()).addPathPatterns("/**")
				.excludePathPatterns("/static/**");

		registry.addInterceptor(hmacAuthInterceptor)
				.addPathPatterns("/magic-api/callback/**");
	}

	@Bean
	public FilterRegistrationBean filterRegistrationBean3() {
		FilterRegistrationBean bean = new FilterRegistrationBean();
		bean.setFilter(new cn.myapps.runtime.common.filter.MultiLanguageFilter());
		bean.addUrlPatterns("/api/runtime/*");
		bean.addUrlPatterns("/api/runtime-ex/*");
		bean.addUrlPatterns("/api/authtime/*");
		return bean;
	}

	@Bean // checkCodeServlet 验证码
	public ServletRegistrationBean getCheckCodeServletRegistrationBean() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new CheckCodeServlet());
		bean.addUrlMappings("/checkCodeImg"); // 访问路径值
		return bean;
	}

	@Bean // FrontFileAndImageUploadServlet 文件上传
	public ServletRegistrationBean getServletRegistrationBean3() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new FrontFileAndImageUploadServlet());
		bean.addUrlMappings("/api/portal/FrontFileAndImageUploadServlet"); // 访问路径值
		return bean;
	}

	@Bean // SignUploadServlet 文件上传
	public ServletRegistrationBean getServletRegistrationBean5() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new SignUploadServlet());
		bean.addUrlMappings("/api/portal/share/component/sign/upload"); // 访问路径值
		return bean;
	}

	@Bean // FrontFileAndImageUploadServlet 文件上传
	public ServletRegistrationBean getServletRegistrationBean6() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new UploadServlet());
		bean.addUrlMappings("/api/UploadServlet"); // 访问路径值
		return bean;
	}

	@Bean
	public FilterRegistrationBean filterRegistrationBeanSecurityFilter() {
		FilterRegistrationBean bean = new FilterRegistrationBean();
		bean.setFilter(new SecurityFilter());
		bean.addUrlPatterns("/*");
		bean.setOrder(2);
		return bean;
	}

	//spring 容器启动监听器
	@Bean
	public ApplicationContextEventListener applicationStartListener() {
		return new ApplicationContextEventListener();
	}

	// SessionListener
	@Bean
	public ServletListenerRegistrationBean getSessionListener() {
		ServletListenerRegistrationBean bean = new ServletListenerRegistrationBean(new SessionListener());
		return bean;
	}

	// 拍照
	@Bean
	public ServletRegistrationBean getServletRegistrationBean8() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new OnLineTakePhotoServlet());
		bean.addUrlMappings("/api/onLineTakePhotoServlet"); // 访问路径值
		return bean;
	}

	@Bean // FileDownloadServlet 文件下载
	public ServletRegistrationBean getServletRegistrationBean9() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new AdminServlet());
		bean.addUrlMappings("/api/servlet/AdminServlet"); // 访问路径值
		return bean;
	}

	@Bean // BreakpointUploadServlet 托盘文件上传
	public ServletRegistrationBean getServletRegistrationBean10() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new BreakpointUploadServlet());
		bean.addUrlMappings("/api/tray/service/upload"); // 访问路径值
		return bean;
	}

	@Bean // QRCodeFiledScanEventReadyServlet 二维码
	public ServletRegistrationBean getServletRegistrationBean11() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new QRCodeFiledScanEventReadyServlet());
		bean.addUrlMappings("/api/portal/document/qrcodefield/ready"); // 访问路径值
		return bean;
	}

	@Bean // QRCodeFiledScanEventHandlerServlet 二维码
	public ServletRegistrationBean getServletRegistrationBean12() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new QRCodeFiledScanEventHandlerServlet());
		bean.addUrlMappings("/api/portal/document/qrcodefield/handle"); // 访问路径值
		return bean;
	}

	@Bean // AppUploadServlet app上传头像
	public ServletRegistrationBean getServletRegistrationBean13() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new AppUploadServlet());
		bean.addUrlMappings("/runtime/app/upload"); // 访问路径值
		return bean;
	}

	@Bean // CloudReadServlet 金格移动端签章（云阅读）
	public ServletRegistrationBean getServletRegistrationBean15() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new CloudReadServlet());
		bean.addUrlMappings("/api/iwebpdf"); // 访问路径值
		return bean;
	}

	@Bean
	public InjectResolver injectResolver(BeanFactory beanFactory) {
		return new InjectResolver() {
			@Override
			public <T> T resolve(Class<T> tClass) {
				return beanFactory.getBean(tClass);
			}

			@Override
			public <T> T resolve(String beanName) {
				return (T) beanFactory.getBean(beanName);
			}
		};
	}
}
