package cn.myapps.base.web.filter;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.constans.Web;
import jespa.http.HttpSecurityFilter;

/**
 * @author spy
 */
public class ADSecurityFilter extends HttpSecurityFilter{

	/* (non-Javadoc)
	 * @see jespa.http.HttpSecurityService#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		HttpServletRequest hreq = (HttpServletRequest) request;
		String uri = hreq.getRequestURI();
		if (isExcludeURI(uri,hreq)) {
			chain.doFilter(request, response);
			return;
		} else {
			if (isForegroundURI(uri)) { // 是否为前台
				String username = PropertyUtil.get("sso.ad.jespa");
				
				if (Web.AUTHENTICATION_TYPE_SSO.equals(PropertyUtil
						.get(Web.AUTHENTICATION_TYPE)) && !StringUtil.isBlank(username)) {
					//单点登录
					super.doFilter(request, response, chain);
				} else {
					chain.doFilter(request, response);
				}
			}
		}
		
	}
	
	/**
	 * 是否不作检验的URI
	 * 
	 * @param uri
	 * @return 是返回true,否则返回false
	 */
	private boolean isExcludeURI(String uri,HttpServletRequest request) {
		return uri.indexOf("mobile") >= 0 || uri.indexOf("help") >= 0
				|| uri.startsWith(request.getContextPath()+"/extend/")
				|| uri.startsWith(request.getContextPath()+"/common/")
				|| uri.startsWith(request.getContextPath()+"/tray/service/")
				|| uri.indexOf("login.action") >= 0
				|| uri.indexOf(".html") >= 0
				|| uri.indexOf("loginWithCiphertext.action") >= 0
				|| uri.indexOf("loginInDialog.action") >= 0
				|| uri.indexOf("loginInDialog.jsp") >= 0
				|| uri.indexOf("loginSMS.action") >= 0
				|| uri.indexOf("urlLogin.action") >= 0
				|| uri.indexOf("logout.jsp") >= 0 || uri.equals("")
				|| uri.equals("/")
				|| (uri.endsWith("/admin/login.jsp"))
				|| (uri.indexOf("timeOut.jsp") >= 0)
				|| (uri.indexOf("login_error.jsp") >= 0)
				|| (uri.indexOf("frame.jsp") >= 0)
				|| ((uri.indexOf(".action") < 0 && uri.indexOf(".jsp") < 0 && uri.indexOf("/portal/LinkForScript") < 0 && uri.indexOf("/portal/document/qrcodefield/handle") < 0) )
				|| uri.indexOf("step1_login.jsp") >= 0
				|| uri.indexOf("login.jsp") >= 0
				|| uri.indexOf("login_debug.jsp") >= 0
				|| uri.startsWith(request.getContextPath()+"/index.jsp")
				|| uri.indexOf("core/multilanguage/change") >= 0
				|| uri.indexOf("desktop") >= 0
				|| uri.endsWith("/checkcookie.jsp")
				|| uri.indexOf("/core/macro/debuger/") >= 0
				|| uri.indexOf("loginUsbKey.action") >= 0
//				|| uri.indexOf("sso.action") >= 0
				|| uri.indexOf("smsauth.action") >= 0
				|| uri.indexOf("resource/css/style.jsp") >= 0
				|| uri.indexOf("/saas/register") >= 0
				|| uri.indexOf("/portal/share/server-info.jsp") >= 0
				|| uri.indexOf("saas/multilanguage/change") >= 0
				|| uri.indexOf("saas/changeLanguageKm") >= 0
				|| uri.indexOf("/weioa365/services") >= 0
				|| uri.indexOf("/portal/document/qrcodefield/ready") >= 0
				|| uri.indexOf("/portal/dynaform/document/fileDownload") >= 0	//微信端文件下载超时
				|| uri.indexOf("/weixin/") >= 0 
				|| uri.indexOf("/lanxin/") >= 0
				|| uri.indexOf("/portal/component/user/") >= 0
				|| uri.indexOf("/rest/bpm/") >= 0
				|| uri.indexOf("/monitors/workflows/") >= 0
				|| uri.indexOf("/runtime/app/") >= 0;
				
	}
	
	/**
	 * 是否前台URI
	 * 
	 * @param uri
	 * @return 是返回true,否则返回false
	 */
	private boolean isForegroundURI(String uri) {
		// 检查以"/portal"或"/mobile"开始的URI(*.action、*.jsp、*.html);
		return uri.indexOf("/portal/") >= 0 || uri.indexOf("/mobile/") >= 0 || uri.indexOf("/pm/")>= 0 || uri.indexOf("/km/")>= 0 || uri.indexOf("/kms/")>= 0 || uri.indexOf("/kmswap/")>= 0 || uri.indexOf("/rm/") >= 0 
				|| uri.indexOf("/message/")>=0
				|| uri.indexOf("/attendance/")>=0
				|| uri.indexOf("/saas/weioa/")>=0
				|| uri.indexOf("/contacts/")>=0 || uri.indexOf("/qm/") >=0
				|| uri.indexOf("/bcxin/") >= 0 || uri.indexOf("/v2/sync") >= 0|| uri.indexOf("/v3/extends") >= 0
				|| uri.indexOf("/jasperreport/") >= 0;
	}
}
