/*
 * Decompiled with CFR 0.152.
 */
package com.test;

import com.kinggrid.pdfviewer.PdfFileResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;

public class MyPdfFileResource
extends PdfFileResource {
    private static final Map<String, String> PRE_MAP = new HashMap<String, String>();
    private String tmpFile;

    @Override
    public String getPdfFile() {
        return this.request.getServletContext().getRealPath("/files/" + this.documentId);
    }

    @Override
    public InputStream getPdfFileStream() {
        return null;
    }

    @Override
    public OutputStream getSavePdfFileSteam() {
        FileOutputStream fileOutputStream;
        String dir = this.request.getServletContext().getRealPath("/files");
        this.tmpFile = dir + File.separator + UUID.randomUUID().toString();
        try {
            fileOutputStream = new FileOutputStream(this.tmpFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return fileOutputStream;
    }

    @Override
    public String getDocumentName() {
        return "document.pdf";
    }

    @Override
    public void success() {
        System.out.println("success action = " + this.action);
        if (this.tmpFile != null) {
            this.saveFile();
        }
    }

    @Override
    public void fail() {
        File file;
        System.out.println("fail action = " + this.action);
        if (this.tmpFile != null && (file = new File(this.tmpFile)).exists()) {
            file.delete();
        }
    }

    private void saveFile() {
        String dir = this.request.getServletContext().getRealPath("/files");
        System.out.println("documentId = " + this.documentId);
        System.out.println("userId = " + this.userId);
        System.out.println(dir);
        String fileName = dir + File.separator + this.documentId;
        FileOutputStream fileOutputStream = null;
        FileInputStream in = null;
        File file = new File(this.tmpFile);
        try {
            in = new FileInputStream(this.tmpFile);
            fileOutputStream = new FileOutputStream(fileName);
            IOUtils.copy((InputStream)in, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(fileOutputStream);
                if (file.exists()) {
                    file.delete();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void preSuccess() {
        PRE_MAP.put(this.documentId, this.tmpFile);
    }

    @Override
    public String getPrePdfFile() {
        this.tmpFile = PRE_MAP.remove(this.documentId);
        return this.tmpFile;
    }

    @Override
    public List<String> getGBEsids() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("36010000000230");
        return list;
    }
}

