/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.utils;

import com.KGitextpdf.text.pdf.security.DigestAlgorithms;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.commons.KGDateUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.util.encoders.Hex;

public class CertUtils {
    public static Certificate convertCertToCertificate(byte[] cert) throws CertificateException, NoSuchProviderException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509", "KGBC");
        X509Certificate certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(cert));
        return certificate;
    }

    public static JSONObject parseCert(byte[] cert) throws IOException {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)cert);
        org.kg.bouncycastle.asn1.x509.Certificate certificate = org.kg.bouncycastle.asn1.x509.Certificate.getInstance((Object)seq);
        JSONObject object = new JSONObject();
        object.put("version", (Object)certificate.getVersionNumber());
        byte[] serialNumber = Hex.encode((byte[])certificate.getSerialNumber().getValue().toByteArray());
        object.put("serialNumber", (Object)new String(serialNumber));
        String subjectDN = CertUtils.getCN(certificate.getSubject().toString());
        String issuerDN = CertUtils.getCN(certificate.getIssuer().toString());
        object.put("subjectDN", (Object)subjectDN);
        object.put("issuerDN", (Object)issuerDN);
        String algorithm = certificate.getSignatureAlgorithm().getAlgorithm().toString();
        String algName = DigestAlgorithms.getDigest((String)algorithm);
        if (algName.equals(algorithm)) {
            algName = "SM3";
        }
        String oid = certificate.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().toString();
        String sigName = null;
        if ("1.2.840.113549.1.1.1".equals(oid)) {
            sigName = "RSA";
        } else if ("1.2.840.10045.2.1".equals(oid)) {
            sigName = "SM2";
        } else {
            throw new RuntimeException("\u76ee\u524d\u4e0d\u652f\u6301\u7b7e\u540d\u7b97\u6cd5oid\uff1a" + oid);
        }
        object.put("sigAlg", (Object)(algName + "with" + sigName));
        object.put("notBefore", (Object)KGDateUtils.dateTime((Date)certificate.getStartDate().getDate()));
        object.put("notAfter", (Object)KGDateUtils.dateTime((Date)certificate.getEndDate().getDate()));
        return object;
    }

    public static String getCN(String str) {
        int index;
        String upper = str.toUpperCase();
        int spIndex = upper.indexOf(",", index = upper.indexOf("CN="));
        if (spIndex == -1) {
            spIndex = upper.indexOf("+", index);
        }
        if (spIndex != -1) {
            return str.substring(index + 3, spIndex);
        }
        return str.substring(index + 3);
    }
}

