/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.pdf.electronicseal.impl;

import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.security.PdfPKCS7;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.encrypt.KGSignature;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.MsgServerUtils;
import com.kinggrid.pdfviewer.pdf.electronicseal.VerifyDigitalSignature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DLSequence;

public class VerifyDigitalSignatureImpl
implements VerifyDigitalSignature {
    @Override
    public boolean verify(byte[] cert, byte[] sigData, String newDigest, PdfDictionary annot, Map<String, String> sealMap, JSONObject obj) {
        try {
            boolean sigEffectiveness = false;
            KGBase64 base64 = new KGBase64();
            if (Contants.SERVER_SIG_P1) {
                if (this.isSm2(cert)) {
                    try {
                        String sigdataString = new String(sigData, "utf-8");
                        if (sigdataString.startsWith("ISSERVERSIGN")) {
                            String[] param = sigdataString.split("@");
                            sigData = base64.decode(param[2]);
                        }
                        MsgServerUtils.verifySignature(newDigest, sigData, cert, sealMap.get("KeySerial"));
                        sigEffectiveness = true;
                    }
                    catch (KGServerInterfaceErrorException e) {
                        sigEffectiveness = false;
                    }
                } else {
                    PdfPKCS7 pdfPKCS7 = new PdfPKCS7(sigData, new PdfName("KG"), "KGBC");
                    byte[] extSignature = pdfPKCS7.getDigest();
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate oCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert));
                    sigEffectiveness = KGSignature.verify((Certificate)oCert, (byte[])extSignature, (byte[])newDigest.getBytes(), (String)pdfPKCS7.getDigestAlgorithm());
                }
            } else {
                try {
                    MsgServerUtils.verifySignature(newDigest, sigData, cert, sealMap.get("KeySerial"));
                    sigEffectiveness = true;
                }
                catch (KGServerInterfaceErrorException e) {
                    sigEffectiveness = false;
                }
            }
            return sigEffectiveness;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String esType(PdfDictionary annot, Map<String, String> sealMap) {
        return null;
    }

    private boolean isSm2(byte[] cert) throws CertificateException, IOException {
        ASN1InputStream asn1InputStream = new ASN1InputStream(cert);
        ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
        asn1InputStream.close();
        DLSequence signAlgorithmObject = (DLSequence)sequence.getObjectAt(1);
        ASN1ObjectIdentifier object = (ASN1ObjectIdentifier)signAlgorithmObject.getObjectAt(0);
        return object.toString().equals("1.2.156.10197.1.501") || object.toString().equals("1.2.156.10197.1.301");
    }
}

