/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.pdf;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfString;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.executes.electronicseal.KGMessageDigest;
import com.kinggrid.pdf.utils.HashPDFDoc10;
import com.kinggrid.pdf.utils.KGPdfUtils;
import com.kinggrid.pdfviewer.Contants;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.kg.bouncycastle.crypto.CipherParameters;
import org.kg.bouncycastle.crypto.engines.RC4Engine;
import org.kg.bouncycastle.crypto.params.KeyParameter;
import org.kg.bouncycastle.util.encoders.Hex;

public class PdfUtils {
    public static KGPdfHummer getPdfHummer(String fileName, InputStream in, OutputStream out, String pwd) throws IOException, DocumentException {
        KGPdfHummer pdfHummer = null;
        byte[] password = null;
        if (pwd != null && pwd.length() > 0) {
            password = pwd.getBytes("UTF-8");
        }
        pdfHummer = fileName != null ? KGPdfHummer.createInstance((String)fileName, (byte[])password, (boolean)true, (OutputStream)out, (boolean)true) : KGPdfHummer.createInstance((InputStream)in, (byte[])password, (OutputStream)out, (boolean)true);
        return pdfHummer;
    }

    public static KGPdfHummer getPdfHummerOfdqzqRead(String fileName, InputStream in, OutputStream out, String pwd) throws IOException, DocumentException {
        KGPdfHummer pdfHummer = null;
        byte[] password = null;
        if (pwd != null && pwd.length() > 0) {
            password = pwd.getBytes("UTF-8");
        }
        pdfHummer = fileName != null ? KGPdfHummer.createInstance((String)fileName, (byte[])password, (boolean)true, (OutputStream)out, (boolean)false) : KGPdfHummer.createInstance((InputStream)in, (byte[])password, (OutputStream)out, (boolean)false);
        return pdfHummer;
    }

    public static KGPdfHummer getPdfHummerOfRead(String fileName, InputStream in, String pwd) throws IOException, DocumentException {
        byte[] password = null;
        if (pwd != null && pwd.length() > 0) {
            password = pwd.getBytes("UTF-8");
        }
        KGPdfHummer pdfHummer = null;
        pdfHummer = fileName != null ? KGPdfHummer.createInstance((String)fileName, (byte[])password, (boolean)true) : KGPdfHummer.createInstance((InputStream)in, (byte[])password);
        return pdfHummer;
    }

    public static KGPdfHummer getPdfHummerOfSig(String fileName, InputStream in, OutputStream out, String pwd) throws IOException, DocumentException {
        byte[] password = null;
        if (pwd != null && pwd.length() > 0) {
            password = pwd.getBytes("UTF-8");
        }
        KGPdfHummer pdfHummer = null;
        File tmpDic = new File(Contants.USER_TMP);
        pdfHummer = fileName != null ? KGPdfHummer.createSignature((String)fileName, (byte[])password, (boolean)true, (OutputStream)out, (File)tmpDic, (boolean)true) : KGPdfHummer.createSignature((InputStream)in, (byte[])password, (OutputStream)out, (File)tmpDic, (boolean)true);
        return pdfHummer;
    }

    public static void close(Closeable able) {
        try {
            if (able != null) {
                able.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Map<String, Object> getAnnotOfXY(PdfReader pdfReader, int page, float x, float y) {
        HashMap<String, Integer> map = null;
        Rectangle pageRect = pdfReader.getPageSizeWithRotation(page);
        float _x = x;
        float _y = pageRect.getHeight() - y;
        PdfDictionary pageDic = pdfReader.getPageN(page);
        int pageRotation = pdfReader.getPageRotation(page);
        if (pageRotation == 90) {
            _x = y;
            _y = x;
        } else if (pageRotation == 180) {
            _x = pageRect.getWidth() - _x;
            _y = y;
        } else if (pageRotation == 270) {
            _x = _y;
            _y = pageRect.getWidth() - x;
        }
        PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
        if (annots == null) {
            return null;
        }
        for (int i = annots.size() - 1; i >= 0; --i) {
            PdfDictionary annot = annots.getAsDict(i);
            PdfArray pdfArray = annot.getAsArray(PdfName.RECT);
            Rectangle rectangle = new Rectangle(pdfArray.getAsNumber(0).floatValue(), pdfArray.getAsNumber(1).floatValue(), pdfArray.getAsNumber(2).floatValue(), pdfArray.getAsNumber(3).floatValue());
            rectangle.normalize();
            if (!(_x >= rectangle.getLeft()) || !(_x <= rectangle.getRight()) || !(_y >= rectangle.getBottom()) || !(_y <= rectangle.getTop())) continue;
            map = new HashMap<String, Integer>();
            map.put("idx", i);
            map.put("annot", (Integer)annot);
            break;
        }
        return map;
    }

    public static Map<String, Object> getPdfDictionaryOfXY(PdfReader pdfReader, int page, float x, float y) {
        HashMap<String, Integer> map = null;
        Rectangle pageRect = pdfReader.getPageSizeWithRotation(page);
        float _x = x;
        float _y = pageRect.getHeight() - y;
        PdfDictionary pageDic = pdfReader.getPageN(page);
        int pageRotation = pdfReader.getPageRotation(page);
        if (pageRotation == 90) {
            _x = y;
            _y = x;
        } else if (pageRotation == 180) {
            _x = pageRect.getWidth() - _x;
            _y = y;
        } else if (pageRotation == 270) {
            _x = _y;
            _y = pageRect.getWidth() - x;
        }
        PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
        if (annots != null) {
            for (int i = annots.size() - 1; i >= 0; --i) {
                PdfDictionary annot = annots.getAsDict(i);
                PdfName subtype = annot.getAsName(PdfName.SUBTYPE);
                PdfName ft = annot.getAsName(PdfName.FT);
                if (!KGElectronicSealName.SEAL.equals((Object)subtype) && (!PdfName.WIDGET.equals((Object)subtype) || !PdfName.SIG.equals((Object)ft))) continue;
                PdfArray pdfArray = annot.getAsArray(PdfName.RECT);
                Rectangle rectangle = new Rectangle(pdfArray.getAsNumber(0).floatValue(), pdfArray.getAsNumber(1).floatValue(), pdfArray.getAsNumber(2).floatValue(), pdfArray.getAsNumber(3).floatValue());
                rectangle.normalize();
                if (!(_x >= rectangle.getLeft()) || !(_x <= rectangle.getRight()) || !(_y >= rectangle.getBottom()) || !(_y <= rectangle.getTop())) continue;
                map = new HashMap<String, Integer>();
                map.put("idx", i);
                map.put("annot", (Integer)annot);
                break;
            }
        }
        return map;
    }

    public static JSONObject parseKgProperty(PRStream kgProperty) throws IOException, org.dom4j.DocumentException {
        JSONObject sealObj = new JSONObject();
        byte[] data = PdfReader.getStreamBytes((PRStream)kgProperty);
        KGBase64 base64 = new KGBase64();
        base64.setBase64Table("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@*-");
        byte[] encData = base64.decode(new String(data));
        RC4Engine rc4_engine = new RC4Engine();
        KeyParameter params_a = new KeyParameter("www.goldgrid.com".getBytes());
        rc4_engine.init(false, (CipherParameters)params_a);
        byte[] temp = new byte[encData.length];
        rc4_engine.processBytes(encData, 0, encData.length, temp, 0);
        rc4_engine.reset();
        String keypProperty = new String(temp, "UTF-8").substring(39);
        Document document = DocumentHelper.parseText((String)keypProperty);
        sealObj.put("signName", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureName").getText());
        sealObj.put("appName", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureApp").getText());
        sealObj.put("unitName", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureUnit").getText());
        sealObj.put("userName", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureUser").getText());
        sealObj.put("keySN", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureKeySN").getText());
        sealObj.put("signSN", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureSN").getText());
        if (document.selectSingleNode("/KGSignaturePDF/ScanStamp") != null) {
            sealObj.put("scanStamp", (Object)document.selectSingleNode("/KGSignaturePDF/ScanStamp").getText());
        }
        if (document.selectSingleNode("/KGSignaturePDF/ScanUserid") != null) {
            sealObj.put("scanUserId", (Object)document.selectSingleNode("/KGSignaturePDF/ScanUserid").getText());
        }
        if (document.selectSingleNode("/KGSignaturePDF/ScanUserid") != null) {
            sealObj.put("scanUserName", (Object)document.selectSingleNode("/KGSignaturePDF/ScanUserName").getText());
        }
        return sealObj;
    }

    public static JSONObject parseISP(PRStream isp) throws IOException, org.dom4j.DocumentException {
        JSONObject sealObj = new JSONObject();
        byte[] data = PdfReader.getStreamBytes((PRStream)isp);
        KGBase64 base64 = new KGBase64();
        String ispstr = new String(base64.decode(new String(data)), "GBK");
        String[] ispArray = ispstr.split(";");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String kv : ispArray) {
            int idx = kv.indexOf(58);
            map.put(kv.substring(0, idx), kv.substring(idx + 1));
        }
        sealObj.put("appName", (Object)("iWebPDF 2015+ " + (String)map.get("SignatureApp")));
        sealObj.put("keySN", map.get("SignatureKeySN"));
        sealObj.put("userName", map.get("SignatureUser"));
        sealObj.put("unitName", map.get("SignatureUnit"));
        sealObj.put("signSN", map.get("SignatureSN"));
        sealObj.put("signName", map.get("SignatureName"));
        sealObj.put("createTime", (Object)"");
        return sealObj;
    }

    public static JSONObject verifyEletronicSeal(PdfReader pdfReader, PdfDictionary annot, KGMessageDigest messageDigest, String hash) throws IOException {
        String new_hash = null;
        String newNewHash = null;
        boolean effectiveness = false;
        JSONObject jObject = new JSONObject();
        PdfDictionary info = annot.getAsDict(PdfName.INFO);
        PdfNumber proversion = info.getAsNumber(KGElectronicSealName.PROVERSION);
        PdfNumber subVersion = info.getAsNumber(KGElectronicSealName.SUBVERSION);
        if (proversion.intValue() == 10) {
            PdfString oldNewHash = info.getAsString(KGElectronicSealName.NEWHASH);
            LinkedHashMap refsMap = new LinkedHashMap();
            new_hash = HashPDFDoc10.getHash((PdfReader)pdfReader, (KGMessageDigest)messageDigest, (boolean)false, refsMap);
            if (oldNewHash != null) {
                newNewHash = info.getAsNumber(KGElectronicSealName.KGFLAGS) == null ? KGPdfUtils.calc10NewHash((PdfDictionary)annot, (String)new_hash, (KGMessageDigest)messageDigest) : KGPdfUtils.calc10NewHash((PdfReader)pdfReader, (PdfDictionary)annot, (String)new_hash, (KGMessageDigest)messageDigest, (boolean)true, refsMap);
                if (newNewHash.equals(oldNewHash.toString())) {
                    effectiveness = true;
                }
                if (subVersion.intValue() == 2) {
                    new_hash = newNewHash;
                }
            } else if (hash.equals(new_hash)) {
                effectiveness = true;
            }
        } else {
            byte[] hash_byte = KGPdfUtils.calculatePdfHash4Elec((PdfReader)pdfReader, (KGMessageDigest)messageDigest);
            new_hash = new String(Hex.encode((byte[])hash_byte));
            if (hash.equals(new_hash)) {
                effectiveness = true;
            }
        }
        jObject.put("effectiveness", (Object)effectiveness);
        jObject.put("new_hash", (Object)new_hash);
        return jObject;
    }
}

