/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.pdf;

import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicExecute;
import com.kinggrid.pdf.signinter.DigitalSignatureByServer;

public class KGPdfElectronicSigOnline
extends KGPdfElectronicExecute {
    private PdfIndirectReference refCertSignMsg;
    private PdfIndirectReference refCertContext;
    private DigitalSignatureByServer digitalSignature;

    public void execute(PdfStamper pdfStamper, PdfAnnotation annotation, int pagen, String hash) {
        try {
            if (this.refCertSignMsg != null && this.refCertContext != null) {
                annotation.put(new PdfName("certContext"), (PdfObject)this.refCertContext);
                annotation.put(new PdfName("certSignMsg"), (PdfObject)this.refCertSignMsg);
                pdfStamper.markUsed((PdfObject)annotation);
                return;
            }
            byte[] hashData = hash.getBytes("GBK");
            byte[] digest = this.digitalSignature.sign(hashData);
            byte[] certBytes = this.digitalSignature.getCertificate()[0].getEncoded();
            KGBase64 base64 = new KGBase64();
            String certContext = "-----BEGIN CERTIFICATE-----\n" + base64.encode(certBytes) + "\n-----END CERTIFICATE-----\n";
            String certSignMsg = base64.encode(digest);
            if (certSignMsg != null) {
                byte[] streambyte = certSignMsg.getBytes("UTF-16LE");
                PdfStream certSignMsgStream = new PdfStream(streambyte);
                PdfIndirectObject refObj = pdfStamper.getWriter().addToBody((PdfObject)certSignMsgStream);
                this.refCertSignMsg = refObj.getIndirectReference();
                annotation.put(new PdfName("certSignMsg"), (PdfObject)this.refCertSignMsg);
            }
            if (certContext != null) {
                byte[] streambyte1;
                byte[] tmp = streambyte1 = certContext.getBytes("UTF-16LE");
                streambyte1 = new byte[tmp.length * 2];
                System.arraycopy(tmp, 0, streambyte1, 0, tmp.length);
                PdfStream certContextStream = new PdfStream(streambyte1);
                PdfIndirectObject refObj1 = pdfStamper.getWriter().addToBody((PdfObject)certContextStream);
                this.refCertContext = refObj1.getIndirectReference();
                annotation.put(new PdfName("certContext"), (PdfObject)this.refCertContext);
            }
            pdfStamper.markUsed((PdfObject)annotation);
        }
        catch (KGServerInterfaceErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public DigitalSignatureByServer getDigitalSignature() {
        return this.digitalSignature;
    }

    public void setDigitalSignature(DigitalSignatureByServer digitalSignature) {
        this.digitalSignature = digitalSignature;
    }
}

