/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.ofd.gm;

import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdfviewer.ofd.gm.Seal;
import java.io.IOException;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERGeneralizedTime;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERUTF8String;
import org.kg.bouncycastle.asn1.DLSequence;

public class SealUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Seal getSeal(byte[] bytes) throws IOException {
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(bytes);){
            ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
            asn1InputStream.close();
            ASN1Sequence signInfo = (ASN1Sequence)sequence.getObjectAt(0);
            String esID = signInfo.getObjectAt(1).toString();
            DLSequence signHeader = (DLSequence)signInfo.getObjectAt(0);
            DERInteger signType = (DERInteger)signHeader.getObjectAt(1);
            DLSequence propertyInfo = (DLSequence)signInfo.getObjectAt(2);
            DERUTF8String sealName = (DERUTF8String)propertyInfo.getObjectAt(1);
            DLSequence picInfo = (DLSequence)signInfo.getObjectAt(3);
            DERIA5String sealPicType = (DERIA5String)picInfo.getObjectAt(0);
            DEROctetString sealPicData = (DEROctetString)picInfo.getObjectAt(1);
            DERInteger sealPicWidth = (DERInteger)picInfo.getObjectAt(2);
            DERInteger sealPicHeight = (DERInteger)picInfo.getObjectAt(3);
            Seal seal = new Seal();
            KGBase64 base64 = new KGBase64();
            if ("4".equals(signType.toString())) {
                DLSequence certList = (DLSequence)propertyInfo.getObjectAt(3);
                DEROctetString cert = (DEROctetString)certList.getObjectAt(0);
                String str = base64.encode(cert.getOctets());
                String createDate = ((DERGeneralizedTime)propertyInfo.getObjectAt(4)).getTimeString();
                String validStart = ((DERGeneralizedTime)propertyInfo.getObjectAt(5)).getTimeString();
                String validEnd = ((DERGeneralizedTime)propertyInfo.getObjectAt(6)).getTimeString();
                DEROctetString signCertInfo = (DEROctetString)sequence.getObjectAt(1);
                seal.setCreateDate(KGDateUtils.dateTime((Date)KGDateUtils.parseZ2Date((String)createDate)));
                seal.setValidStart(KGDateUtils.dateTime((Date)KGDateUtils.parseZ2Date((String)validStart)));
                seal.setValidEnd(KGDateUtils.dateTime((Date)KGDateUtils.parseZ2Date((String)validEnd)));
                seal.setProductCertData(base64.encode(signCertInfo.getOctets()));
                seal.setSignatureCertData(str);
                seal.setSealType("GB");
            } else {
                seal.setSealType("GM");
            }
            seal.setEsid(esID);
            seal.setSealName(sealName.toString());
            seal.setWidth(Integer.parseInt(sealPicWidth.toString()));
            seal.setHeight(Integer.parseInt(sealPicHeight.toString()));
            seal.setSignData(base64.encode(sealPicData.getOctets()));
            seal.setSealPicType(sealPicType.getString());
            Seal seal2 = seal;
            return seal2;
        }
    }
}

