/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.ofd;

import com.kgofd.commons.KGCommonUtils;
import com.kgofd.ofd.KGOfdHummer;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERSequence;

public class OfdUtils {
    public static KGOfdHummer getOfdHummer(String fileName, String pwd, String outPath) throws IOException, ZipException {
        byte[] password = null;
        if (pwd != null && pwd.length() > 0) {
            password = pwd.getBytes("UTF-8");
        }
        return KGOfdHummer.createInstance((String)fileName, password, (String)outPath);
    }

    public static KGOfdHummer getOfdHummer(String fileName, String pwd) throws IOException, ZipException {
        byte[] password = null;
        if (pwd != null && pwd.length() > 0) {
            password = pwd.getBytes("UTF-8");
        }
        return KGOfdHummer.createInstance((String)fileName, password, null);
    }

    public static Map<String, Object> getOfdSignOfXY(ZipFile zipFile, int page, float x, float y) throws ZipException, Exception {
        Document ofdDocument = KGOfdUtils.getDocument((ZipFile)zipFile, (String)"OFD.xml");
        Element signaturesElement = (Element)ofdDocument.selectSingleNode("/ofd:OFD/ofd:DocBody/ofd:Signatures");
        if (signaturesElement == null) {
            return null;
        }
        Element docRootElement = (Element)ofdDocument.selectSingleNode("/ofd:OFD/ofd:DocBody/ofd:DocRoot");
        String documentXmlPath = docRootElement.getTextTrim();
        Document documentDocument = KGOfdUtils.getDocument((ZipFile)zipFile, (String)KGCommonUtils.converPath((String)documentXmlPath, (String)""));
        List pages = documentDocument.selectNodes("/ofd:Document/ofd:Pages/ofd:Page");
        Element pageElement = (Element)pages.get(page - 1);
        String id = pageElement.attributeValue("ID");
        String signaturesPath = signaturesElement.getTextTrim();
        signaturesPath = KGCommonUtils.converPath((String)signaturesPath, (String)"");
        Document signaturesDocument = KGOfdUtils.getDocument((ZipFile)zipFile, (String)signaturesPath);
        List signatures = signaturesDocument.selectNodes("/ofd:Signatures/ofd:Signature");
        x /= 2.8346457f;
        y /= 2.8346457f;
        int maxIdx = 0;
        HashMap<String, Object> map = null;
        block0: for (int i = signatures.size() - 1; i >= 0; --i) {
            Element signatureElement = (Element)signatures.get(i);
            String signatureXmlPath = signatureElement.attributeValue("BaseLoc");
            String idx = signatureElement.attribute("ID").getValue();
            if (i == signatures.size() - 1) {
                maxIdx = Integer.valueOf(idx);
            }
            signatureXmlPath = KGCommonUtils.converPath((String)signatureXmlPath, (String)signaturesPath);
            String signPath = signatureXmlPath.substring(0, signatureXmlPath.lastIndexOf("/"));
            Document signatureDocument = KGOfdUtils.getDocument((ZipFile)zipFile, (String)(signPath + "/Signature.xml"));
            String signedValuePath = signatureDocument.selectSingleNode("/ofd:Signature/ofd:SignedValue").getText();
            signedValuePath = KGCommonUtils.converPath((String)signedValuePath, (String)signatureXmlPath);
            List stampAnnots = signatureDocument.selectNodes("/ofd:Signature/ofd:SignedInfo/ofd:StampAnnot");
            if (stampAnnots == null || stampAnnots.size() == 0) continue;
            for (Element stampAnnot : stampAnnots) {
                String pageRef = stampAnnot.attributeValue("PageRef");
                if (!id.equals(pageRef)) continue;
                float[] boundarys = OfdUtils.parseString2Float(stampAnnot.attributeValue("Boundary"));
                float tlx = boundarys[0];
                float tly = boundarys[1];
                float brx = 0.0f;
                float bry = 0.0f;
                if (stampAnnot.attributeValue("Clip") != null) {
                    float[] clips = OfdUtils.parseString2Float(stampAnnot.attributeValue("Clip"));
                    tlx = boundarys[0] + clips[0];
                    tly = boundarys[1] + clips[1];
                    brx = tlx + clips[2];
                    bry = tly + clips[3];
                } else {
                    brx = tlx + boundarys[2];
                    bry = tly + boundarys[3];
                }
                if (!(x > tlx) || !(x < brx) || !(y > tly) || !(y < bry)) continue;
                map = new HashMap<String, Object>();
                map.put("signPath", signPath);
                map.put("signedValuePath", signedValuePath);
                map.put("idx", idx);
                map.put("maxIdx", maxIdx);
                continue block0;
            }
        }
        return map;
    }

    public static float[] parseString2Float(String str) {
        String[] strs = str.split(" ");
        float[] nums = new float[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            nums[i] = Float.parseFloat(strs[i]);
        }
        return nums;
    }

    public static byte[] sigData64bit2Ans1(byte[] signData) throws IOException {
        byte[] r = null;
        byte[] s = null;
        if (signData[0] < 0) {
            r = new byte[33];
            System.arraycopy(signData, 0, r, 1, 32);
        } else {
            r = new byte[32];
            System.arraycopy(signData, 0, r, 0, 32);
        }
        if (signData[32] < 0) {
            s = new byte[33];
            System.arraycopy(signData, 32, s, 1, 32);
        } else {
            s = new byte[32];
            System.arraycopy(signData, 32, s, 0, 32);
        }
        ASN1EncodableVector encodable = new ASN1EncodableVector();
        encodable.add((ASN1Encodable)new ASN1Integer(new BigInteger(r)));
        encodable.add((ASN1Encodable)new ASN1Integer(new BigInteger(s)));
        DERSequence sequence = new DERSequence(encodable);
        return sequence.getEncoded();
    }

    public static byte[] sigDataAns1To64bit(byte[] signData) throws IOException {
        int srcPos;
        int dest;
        ASN1Sequence sequense = ASN1Sequence.getInstance((Object)signData);
        ASN1Integer ans1Int0 = (ASN1Integer)sequense.getObjectAt(0);
        ASN1Integer ans1Int1 = (ASN1Integer)sequense.getObjectAt(1);
        byte[] sig1 = ans1Int0.getValue().toByteArray();
        byte[] sig2 = ans1Int1.getValue().toByteArray();
        byte[] buff = new byte[64];
        if (sig1.length < 32) {
            dest = 32 - sig1.length;
            System.arraycopy(sig1, 0, buff, dest, sig1.length);
        } else {
            srcPos = sig1.length == 32 ? 0 : sig1.length - 32;
            System.arraycopy(sig1, srcPos, buff, 0, 32);
        }
        if (sig2.length < 32) {
            dest = 32 - sig2.length;
            System.arraycopy(sig2, 0, buff, dest, sig2.length);
        } else {
            srcPos = sig2.length == 32 ? 0 : sig2.length - 32;
            System.arraycopy(sig2, srcPos, buff, 32, 32);
        }
        return buff;
    }
}

