/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action.ofd;

import com.alibaba.fastjson.JSONObject;
import com.kgofd.commons.KGCommonUtils;
import com.kgofd.commons.KGDateUtils;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.encrypt.KGSM3Digest;
import com.kgofd.encrypt.SM2;
import com.kgofd.ofd.KGOfdHummer;
import com.kgofd.ofd.utils.KGOfdUtils;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.License;
import com.kinggrid.pdfviewer.PVHttpUtil;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.ofd.OfdUtils;
import com.kinggrid.pdfviewer.utils.StampUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.kg.bouncycastle.asn1.ASN1GeneralizedTime;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.ASN1String;
import org.kg.bouncycastle.asn1.ASN1UTCTime;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.x509.Certificate;
import org.kg.bouncycastle.asn1.x509.X509CertificateStructure;
import org.kg.bouncycastle.util.encoders.Hex;

public class VerifySealOfdAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        String documentId = params.getString("documentId");
        int page = params.getIntValue("page");
        float x = params.getFloatValue("x");
        float y = params.getFloatValue("y");
        if (pdfFileResource == null) {
            pdfFileResource = PdfFileResourceManager.getPdfFileResource();
        }
        pdfFileResource.init(request, response, action, documentId, "1");
        KGOfdHummer hummer = null;
        JSONObject retObj = new JSONObject();
        try {
            hummer = OfdUtils.getOfdHummer(pdfFileResource.getPdfFile(), params.getString("pdfPwd"));
            ZipFile zipFile = hummer.getZipFile();
            Map<String, Object> map = OfdUtils.getOfdSignOfXY(zipFile, page, x, y);
            if (map != null) {
                String signedValuePath = (String)map.get("signedValuePath");
                JSONObject sealObj = this.parseSeal(signedValuePath, zipFile, params);
                sealObj.put("idx", (Object)((String)map.get("idx")));
                retObj.put("status", (Object)true);
                retObj.put("seal", (Object)sealObj);
            } else {
                retObj.put("status", (Object)false);
                retObj.put("message", (Object)"\u5370\u7ae0\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u52a0\u8f7d\u6587\u6863\uff01");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        retObj.put("companyName", (Object)License.getCompanyName());
        response.getWriter().write(retObj.toJSONString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject parseSeal(String signedValuePath, ZipFile zipFile, JSONObject params) throws ZipException, IOException, DocumentException {
        JSONObject sealObj = new JSONObject();
        String signPath = signedValuePath.substring(0, signedValuePath.lastIndexOf("/"));
        sealObj.put("signPath", (Object)signPath);
        sealObj.put("stampType", (Object)"0");
        Object datZis = null;
        Object asn1Is = null;
        Object dat = null;
        try {
            Date date;
            FileHeader fileHeader = zipFile.getFileHeader(signedValuePath);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (ZipInputStream in = zipFile.getInputStream(fileHeader);){
                int len = -1;
                byte[] buff = new byte[8192];
                while ((len = in.read(buff)) != -1) {
                    out.write(buff, 0, len);
                }
            }
            byte[] sesSignature = out.toByteArray();
            ASN1Sequence sequence = DERSequence.getInstance((Object)sesSignature);
            ASN1Sequence toSign = (ASN1Sequence)sequence.getObjectAt(0);
            ASN1Sequence eseal = (ASN1Sequence)toSign.getObjectAt(1);
            ASN1Sequence esealInfo = (ASN1Sequence)eseal.getObjectAt(0);
            ASN1Sequence header = (ASN1Sequence)esealInfo.getObjectAt(0);
            String sealID = ((ASN1String)esealInfo.getObjectAt(1)).toString();
            sealObj.put("sealID", (Object)sealID);
            DERInteger signType = (DERInteger)header.getObjectAt(1);
            int version = signType.getValue().intValue();
            sealObj.put("signType", (Object)version);
            String sealVid = ((ASN1String)header.getObjectAt(2)).getString();
            sealObj.put("sealVid", (Object)sealVid);
            ASN1Sequence property = (ASN1Sequence)esealInfo.getObjectAt(2);
            BigInteger type = ((ASN1Integer)property.getObjectAt(0)).getValue();
            sealObj.put("type", (Object)type.toString());
            String sealName = ((ASN1String)property.getObjectAt(1)).getString();
            sealObj.put("sealName", (Object)sealName);
            if (version == 4) {
                date = ((ASN1GeneralizedTime)property.getObjectAt(5)).getDate();
                sealObj.put("validStart", (Object)KGDateUtils.dateTime((Date)date));
                date = ((ASN1GeneralizedTime)property.getObjectAt(6)).getDate();
                sealObj.put("validEnd", (Object)KGDateUtils.dateTime((Date)date));
            } else {
                date = ((ASN1UTCTime)property.getObjectAt(4)).getAdjustedDate();
                String validStart = KGDateUtils.date((Date)date);
                sealObj.put("validStart", (Object)validStart);
                date = ((ASN1UTCTime)property.getObjectAt(5)).getAdjustedDate();
                String validEnd = KGDateUtils.date((Date)date);
                sealObj.put("validEnd", (Object)validEnd);
            }
            byte[] toSignData = toSign.getEncoded();
            byte[] signData = null;
            Date date2 = null;
            byte[] certData = null;
            if (version == 4) {
                KGBase64 base64;
                PVHttpUtil pvHttpUtil;
                Map<String, Object> map;
                if (Contants.CHECK_SEAL_STATS && !"0".equals((map = (pvHttpUtil = new PVHttpUtil()).checkSealStats(Contants.URL, (base64 = new KGBase64()).encode(sequence.getEncoded()))).get("code"))) {
                    throw new RuntimeException("\u9a8c\u8bc1\u5370\u7ae0\u72b6\u6001\u6709\u6548\u6027\u5931\u8d25\uff1a" + map.get("message"));
                }
                signData = ((DERBitString)sequence.getObjectAt(3)).getBytes();
                try {
                    date2 = ((ASN1GeneralizedTime)toSign.getObjectAt(2)).getDate();
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                signData = ((DERBitString)sequence.getObjectAt(3)).getBytes();
                certData = ((DEROctetString)sequence.getObjectAt(1)).getOctets();
            } else {
                signData = ((DERBitString)sequence.getObjectAt(1)).getBytes();
                String signString = new String(((DERBitString)toSign.getObjectAt(2)).getBytes());
                date2 = signString.length() == 15 ? KGDateUtils.parseUTC2Date((String)signString, (String)"yyyyMMddHHmmss") : KGDateUtils.parseUTC2Date((String)signString, (String)"yyMMddHHmmss");
                signData = ((DERBitString)sequence.getObjectAt(1)).getBytes();
                certData = ((DEROctetString)toSign.getObjectAt(5)).getOctets();
            }
            String stampId = StampUtils.getStampID(date2, sesSignature);
            sealObj.put("stampID", (Object)stampId);
            String signDate = KGDateUtils.dateTime((Date)date2);
            sealObj.put("signDate", (Object)signDate);
            ASN1Sequence certSeq = ASN1Sequence.getInstance((Object)certData);
            X509CertificateStructure cert = X509CertificateStructure.getInstance((Object)certSeq);
            String userName = cert.getIssuer().toString();
            int idx = userName.indexOf(",");
            if (idx == -1) {
                idx = userName.length();
            }
            userName = userName.substring(userName.indexOf("=") + 1, idx);
            sealObj.put("userName", (Object)userName);
            if (signData.length != 64) {
                signData = OfdUtils.sigDataAns1To64bit(signData);
            }
            boolean effectiveness = this.verifySign(signPath, zipFile, toSignData, signData, cert, signDate);
            sealObj.put("effectiveness", (Object)effectiveness);
            JSONObject cer = this.parseCert(certData);
            cer.put("sigEffectiveness", (Object)effectiveness);
            sealObj.put("cert", (Object)cer);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (asn1Is != null) {
                asn1Is.close();
            }
            if (dat != null) {
                dat.close();
            }
            if (datZis != null) {
                datZis.close();
            }
        }
        return sealObj;
    }

    public boolean verifySign(String signPath, ZipFile zipFile, byte[] toSignData, byte[] signData, X509CertificateStructure certificateStructure, String signDate) throws ZipException, DocumentException, IOException {
        byte[] byPuk = certificateStructure.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        byte[] pk = new byte[64];
        System.arraycopy(byPuk, 1, pk, 0, 64);
        SM2 sm2 = new SM2(true);
        boolean result = sm2.Verify(toSignData, signData, pk);
        if (!result) {
            return false;
        }
        if (!this.cerValid(signDate, certificateStructure)) {
            return false;
        }
        Document signatureDocument = KGOfdUtils.getDocument((ZipFile)zipFile, (String)(signPath + "/Signature.xml"));
        String signaturePath = zipFile.getFileHeader(signPath + "/Signature.xml").getFileName();
        Element referencesEle = (Element)signatureDocument.selectSingleNode("/ofd:Signature/ofd:SignedInfo/ofd:References");
        String checkMethod = referencesEle.attributeValue("CheckMethod");
        List referenceNodes = signatureDocument.selectNodes("/ofd:Signature/ofd:SignedInfo/ofd:References/ofd:Reference");
        FileHeader fileHeader = null;
        ZipInputStream zis = null;
        for (int j = 0; j < referenceNodes.size(); ++j) {
            String checkValue;
            byte[] digestData;
            KGBase64 base64;
            String code;
            Element referenceEle = (Element)referenceNodes.get(j);
            String fileRef = referenceEle.attributeValue("FileRef");
            if (!fileRef.equals("OFD.xml")) {
                fileRef = KGCommonUtils.converPath((String)fileRef, (String)signaturePath);
            }
            if (!checkMethod.equals("1.2.156.10197.1.401") || (code = (base64 = new KGBase64()).encode(digestData = KGSM3Digest.getSm3Digest((ZipInputStream)(zis = zipFile.getInputStream(fileHeader = zipFile.getFileHeader(fileRef)))))).equals(checkValue = referenceEle.element("CheckValue").getTextTrim())) continue;
            return false;
        }
        return true;
    }

    private JSONObject parseCert(byte[] in) throws IOException, ParseException {
        JSONObject object = new JSONObject();
        ASN1InputStream aIn = new ASN1InputStream(in);
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        aIn.close();
        Certificate certificate = Certificate.getInstance((Object)seq);
        object.put("version", (Object)certificate.getVersionNumber());
        byte[] serialNumber = Hex.encode((byte[])certificate.getSerialNumber().getValue().toByteArray());
        object.put("serialNumber", (Object)new String(serialNumber));
        String subjectDN = this.getCN(certificate.getSubject().toString());
        String issuerDN = this.getCN(certificate.getIssuer().toString());
        object.put("subjectDN", (Object)subjectDN);
        object.put("issuerDN", (Object)issuerDN);
        object.put("sigAlg", (Object)certificate.getSignatureAlgorithm().getAlgorithm().getId());
        Date startDate = certificate.getStartDate().getDate();
        Date endDate = certificate.getEndDate().getDate();
        object.put("notBefore", (Object)KGDateUtils.dateTime((Date)startDate));
        object.put("notAfter", (Object)KGDateUtils.dateTime((Date)endDate));
        return object;
    }

    private String getCN(String str) {
        int index;
        String upper = str.toUpperCase();
        int spIndex = upper.indexOf(",", index = upper.indexOf("CN="));
        if (spIndex == -1) {
            spIndex = upper.indexOf("+", index);
        }
        if (spIndex != -1) {
            return str.substring(index + 3, spIndex);
        }
        return str.substring(index + 3);
    }

    public boolean cerValid(String ssignDate, X509CertificateStructure certificateStructure) {
        boolean ret = false;
        Date startDate = certificateStructure.getStartDate().getDate();
        Date endDate = certificateStructure.getEndDate().getDate();
        Date date = KGDateUtils.parse2Date((String)ssignDate, (String)"yyyy-MM-dd HH:mm:ss");
        if (startDate.before(date) && endDate.after(date)) {
            ret = true;
        }
        return ret;
    }
}

