/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action.ofd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kgofd.kgcore.KGHttpUtils;
import com.kgofd.kgcore.LogEntity;
import com.kgofd.ofd.KGExecute;
import com.kgofd.ofd.KGOfdHummer;
import com.kgofd.ofd.executes.AbstractSign;
import com.kgofd.ofd.executes.OfdElectronicSeal;
import com.kgofd.ofd.executes.OfdElectronicSeal4KG;
import com.kgofd.ofd.executes.entity.QfzSealData;
import com.kgofd.ofd.signinter.SignatureInter;
import com.kgofd.ofd.signinter.SignatureInterByKey;
import com.kgofd.ofd.signinter.SignatureInterByServer;
import com.kgofd.ofd.signinter.impl.SignatureInterByGBImpl;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.MsgServerUtils;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.action.ofd.OfdDigitalSignature;
import com.kinggrid.pdfviewer.ofd.OfdUtils;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.IOUtils;
import org.dom4j.DocumentException;

public class StampSealOfdAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        String documentId = params.getString("documentId");
        String stampType = params.getString("stampType");
        JSONArray seals = params.getJSONArray("seals");
        if (seals == null || seals.size() == 0) {
            return;
        }
        String keySN = seals.getJSONObject(0).getString("keySN");
        JSONObject retObj = new JSONObject();
        if (pdfFileResource == null) {
            pdfFileResource = PdfFileResourceManager.getPdfFileResource();
        }
        pdfFileResource.init(request, response, action, documentId, "1");
        JSONObject stampobj = null;
        try {
            if (Contants.VERIFY_CAPTCHA) {
                MsgServerUtils.verifyCaptcha(keySN, params.getString("captcha"));
            }
            if (!"0".equals(stampType)) {
                retObj.put("status", (Object)false);
                retObj.put("message", (Object)("stampType\u53c2\u6570\u5f02\u5e38\uff1a" + stampType));
                response.getWriter().write(retObj.toJSONString());
                return;
            }
            stampobj = this.dzqz(request, response, seals, pdfFileResource, params);
        }
        catch (Throwable e) {
            pdfFileResource.fail();
            if (e instanceof KGServerInterfaceErrorException) {
                retObj.put("status", (Object)false);
                retObj.put("message", (Object)e.getMessage());
                response.getWriter().write(retObj.toJSONString());
                return;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        retObj.put("status", (Object)true);
        JSONArray sigobj = stampobj.getJSONArray("sigobj");
        if (sigobj != null && sigobj.size() > 0) {
            retObj.put("sigObj", (Object)sigobj);
            pdfFileResource.preSuccess();
        } else {
            pdfFileResource.success();
        }
        response.getWriter().write(retObj.toJSONString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject dzqz(HttpServletRequest request, HttpServletResponse response, JSONArray seals, PdfFileResource pdfFileResource, JSONObject params) throws ZipException, IOException, DocumentException {
        JSONObject retobj = new JSONObject();
        KGOfdHummer hummer = null;
        KGBase64 base64 = new KGBase64();
        String certOrigin = params.getString("certOrigin");
        String tmpFile = Contants.USER_TMP + File.separator + UUID.randomUUID().toString();
        try {
            hummer = OfdUtils.getOfdHummer(pdfFileResource.getPdfFile(), null, tmpFile);
            ArrayList<OfdElectronicSeal4KG> ofdElectronicSeals = new ArrayList<OfdElectronicSeal4KG>();
            for (int i = 0; i < seals.size(); ++i) {
                JSONObject obj = seals.getJSONObject(i);
                OfdElectronicSeal4KG ofdElectronicSeal4KG = new OfdElectronicSeal4KG();
                this.setPosition(obj, (AbstractSign)ofdElectronicSeal4KG);
                String sealData = obj.getString("sealData");
                byte[] sealmsg = base64.decode(sealData.split(";")[0]);
                ofdElectronicSeal4KG.setSealMsg(sealmsg);
                OfdDigitalSignature signatureInter = null;
                if ("0".equals(certOrigin)) {
                    String sealType = params.getString("sealType");
                    signatureInter = "GB".equals(sealType) || "1".equals(Contants.CENTRALIZED_SEAL_ORIGIN) ? new SignatureInterByGBImpl(Contants.STAMP_SYSTEM_URL, Contants.SALT, Contants.APPID, obj.getString("esid"), "1", "title") : new SignatureInterByServer(ofdElectronicSeal4KG, Contants.URL, obj.getString("keySN"));
                } else if ("1".equals(certOrigin)) {
                    if ("GB".equals(obj.getString("sealType"))) {
                        signatureInter = new OfdDigitalSignature(sealmsg);
                    } else {
                        String certData = params.getString("cert");
                        signatureInter = new SignatureInterByKey(certData, ofdElectronicSeal4KG);
                    }
                } else {
                    throw new RuntimeException("certOrigin\u53c2\u6570\u5f02\u5e38\uff1a" + certOrigin);
                }
                ofdElectronicSeal4KG.setInfomation((SignatureInter)signatureInter);
                if (Contants.SAVELOG) {
                    LogEntity logEntity = new LogEntity();
                    logEntity.setLogType("00");
                    logEntity.setLogSort("13");
                    logEntity.setKeySN(obj.getString("keySN"));
                    logEntity.setSignSN(obj.getString("signSN"));
                    logEntity.setDocumentID(params.getString("documentId"));
                    logEntity.setDocumentName(pdfFileResource.getDocumentName());
                    logEntity.setLogIP(this.getIpAddress(request));
                    if (Contants.VERIFY_CAPTCHA) {
                        logEntity.setLogMemo("\u76d6\u7ae0\u6210\u529f\u3010\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1" + obj.getString("phone") + "\u3011");
                    }
                    KGHttpUtils http = new KGHttpUtils();
                    http.saveLog(Contants.URL, logEntity);
                }
                hummer.addExecute((KGExecute)ofdElectronicSeal4KG);
                ofdElectronicSeals.add(ofdElectronicSeal4KG);
            }
            hummer.doExecute();
            if ("1".equals(certOrigin)) {
                JSONArray sigobjArray = new JSONArray();
                for (OfdElectronicSeal ofdElectronicSeal : ofdElectronicSeals) {
                    String toSignData = base64.encode(ofdElectronicSeal.getToSignDataByte());
                    String signDirPath = ofdElectronicSeal.getSignDirPath();
                    JSONObject sigobj = new JSONObject();
                    sigobj.put("toSignData", (Object)toSignData);
                    sigobj.put("signDirPath", (Object)signDirPath);
                    if (ofdElectronicSeal.getInter() instanceof SignatureInterByKey) {
                        sigobj.put("sealType", (Object)"GM");
                    } else {
                        sigobj.put("sealType", (Object)"GB");
                    }
                    sigobjArray.add((Object)sigobj);
                }
                retobj.put("sigobj", (Object)sigobjArray);
            }
            retobj.put("status", (Object)true);
        }
        catch (Throwable e) {
            retobj.put("status", (Object)false);
            File file = new File(tmpFile);
            if (file.exists()) {
                file.delete();
            }
            throw new RuntimeException("OFD\u7b7e\u7ae0\u5f02\u5e38\uff01", e);
        }
        File file = new File(tmpFile);
        FileInputStream input = null;
        OutputStream out = null;
        try {
            input = new FileInputStream(file);
            out = pdfFileResource.getSavePdfFileSteam();
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
        finally {
            if (input != null) {
                PdfUtils.close(input);
            }
            if (out != null) {
                PdfUtils.close(out);
            }
            if (file.exists()) {
                file.delete();
            }
        }
        return retobj;
    }

    private void setPosition(JSONObject obj, AbstractSign abstractSign) {
        if (obj.getBooleanValue("isStampOfQfz")) {
            JSONArray qfzSealArray = obj.getJSONArray("qfzSeal");
            TreeMap qfzSealMap = new TreeMap();
            for (int i = 0; i < qfzSealArray.size(); ++i) {
                JSONObject qfzSealObject = qfzSealArray.getJSONObject(i);
                int page = qfzSealObject.getIntValue("page");
                float height = qfzSealObject.getFloatValue("height") / this.px2mm();
                float top = qfzSealObject.getFloatValue("top") / this.px2mm();
                JSONArray sealdataArray = qfzSealObject.getJSONArray("sealdata");
                ArrayList<QfzSealData> qfzSealDatas = new ArrayList<QfzSealData>();
                for (int j = 0; j < sealdataArray.size(); ++j) {
                    JSONObject sealdataObejct = sealdataArray.getJSONObject(j);
                    float left = sealdataObejct.getFloatValue("left") / this.px2mm();
                    float width = sealdataObejct.getFloatValue("width") / this.px2mm();
                    QfzSealData qfzSealData = new QfzSealData();
                    qfzSealData.setLeft(left);
                    qfzSealData.setTop(top);
                    qfzSealData.setWidth(width);
                    qfzSealData.setHeight(height);
                    qfzSealDatas.add(qfzSealData);
                }
                qfzSealMap.put(page, qfzSealDatas);
            }
            abstractSign.qfz(qfzSealMap);
        } else {
            String numbPages = obj.getString("page");
            abstractSign.setPagen(numbPages);
            float left = obj.getFloatValue("left");
            float top = obj.getFloatValue("top");
            abstractSign.setXY(left / 2.8346457f, top / 2.8346457f);
        }
    }

    public String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private float px2mm() {
        return 2.8346457f;
    }
}

