/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action.annot;

import com.KGitextpdf.text.DocumentException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.executes.postil.AddPostil;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AddAnnotAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        JSONArray annotsArray;
        OutputStream out;
        InputStream in;
        KGPdfHummer hummer;
        JSONObject retObj;
        block9: {
            String documentId = params.getString("documentId");
            if (pdfFileResource == null) {
                pdfFileResource = PdfFileResourceManager.getPdfFileResource();
            }
            pdfFileResource.init(request, response, action, documentId);
            retObj = new JSONObject();
            hummer = null;
            in = null;
            out = null;
            String pdfFile = pdfFileResource.getPdfFile();
            in = pdfFileResource.getPdfFileStream();
            out = pdfFileResource.getSavePdfFileSteam();
            hummer = PdfUtils.getPdfHummer(pdfFile, in, out, params.getString("pdfPwd"));
            annotsArray = params.getJSONArray("annots");
            if (annotsArray != null) break block9;
            PdfUtils.close(in);
            PdfUtils.close(out);
            if (hummer != null) {
                hummer.close();
            }
            return;
        }
        try {
            AddPostil addPostil = new AddPostil();
            addPostil.setAnnotsArray(annotsArray);
            hummer.addExecute((KGExecute)addPostil);
            hummer.doExecute();
        }
        catch (DocumentException e) {
            try {
                pdfFileResource.fail();
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                PdfUtils.close(in);
                PdfUtils.close(out);
                if (hummer != null) {
                    hummer.close();
                }
                throw throwable;
            }
        }
        PdfUtils.close(in);
        PdfUtils.close(out);
        if (hummer != null) {
            hummer.close();
        }
        pdfFileResource.success();
        retObj.put("status", (Object)true);
        response.getWriter().write(retObj.toJSONString());
    }
}

