/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.kgcore.KGHttpUtils;
import com.kinggrid.kgcore.SealInformation;
import com.kinggrid.kgcore.enmu.KGServerTypeEnum;
import com.kinggrid.kgcore.gm.SealGM;
import com.kinggrid.kgcore.gm.SealUtil;
import com.kinggrid.pdf.utils.ConnectStampSystemUtil;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.MsgServerUtils;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.ofd.gm.Seal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetSealsAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        String docType = request.getParameter("docType");
        if (pdfFileResource == null) {
            pdfFileResource = PdfFileResourceManager.getPdfFileResource();
        }
        String keysn = pdfFileResource.getkeySN(params.getString("keySN"));
        String sealType = params.getString("sealType");
        JSONObject retObj = new JSONObject();
        if (sealType == null || sealType.length() == 0) {
            sealType = "PT";
        }
        if ("PT".equals(sealType) && "1".equals(docType)) {
            retObj.put("status", (Object)false);
            retObj.put("message", (Object)"OFD\u6587\u6863\u4e0d\u652f\u6301sealType\u4e3aPT\uff01");
            response.getWriter().write(retObj.toJSONString());
            return;
        }
        if ("GB".equals(sealType) || "1".equals(Contants.CENTRALIZED_SEAL_ORIGIN)) {
            List<String> esids = pdfFileResource.getGBEsids();
            retObj = this.getSealsFromStampSystem(esids);
        } else if ("0".equals(Contants.CENTRALIZED_SEAL_ORIGIN)) {
            retObj = this.getSealsFromISignatureServer(keysn, params.getString("password"), params);
        }
        retObj.put("sigWithDifferentCert", (Object)Contants.SIG_WITH_DIFFERENT_CERT);
        response.getWriter().write(retObj.toJSONString());
    }

    private JSONObject getSealsFromStampSystem(List<String> esids) {
        JSONObject retObj = new JSONObject();
        JSONArray seals = new JSONArray();
        try {
            ConnectStampSystemUtil connectStampSystemUtil = null;
            for (int i = 0; i < esids.size(); ++i) {
                String esid = esids.get(i);
                connectStampSystemUtil = new ConnectStampSystemUtil(Contants.STAMP_SYSTEM_URL, Contants.SALT, Contants.APPID, esid);
                JSONObject sealObject = connectStampSystemUtil.getSealByEsid();
                JSONObject sealObj = new JSONObject();
                KGBase64 base64 = new KGBase64();
                String sealData = sealObject.getString("sealData");
                Seal seal = com.kinggrid.pdfviewer.ofd.gm.SealUtil.getSeal(base64.decode(sealData));
                sealObj.put("keySN", (Object)sealObject.getString("keySn"));
                sealObj.put("unitName", (Object)sealObject.getString("orgName"));
                sealObj.put("esid", (Object)esid);
                sealObj.put("signName", (Object)seal.getSealName());
                sealObj.put("width", (Object)Float.valueOf((float)seal.getWidth() * 2.8346457f));
                sealObj.put("height", (Object)Float.valueOf((float)seal.getHeight() * 2.8346457f));
                String imgType = seal.getSealPicType();
                sealObj.put("imgExt", (Object)imgType);
                sealObj.put("signSN", (Object)"");
                String imgdata = seal.getSignData();
                sealObj.put("imgdata", (Object)("data:image/" + imgType + ";base64," + imgdata));
                sealObj.put("sealType", (Object)seal.getSealType());
                sealObj.put("sealData", (Object)sealData);
                sealObj.put("sealtag", (Object)"GB");
                sealObj.put("version", (Object)4);
                seals.add((Object)sealObj);
            }
        }
        catch (Exception e) {
            retObj.put("status", (Object)false);
            retObj.put("message", (Object)e.getMessage());
            return retObj;
        }
        retObj.put("status", (Object)true);
        retObj.put("seals", (Object)seals);
        return retObj;
    }

    private JSONObject getSealsFromISignatureServer(String keysn, String pwd, JSONObject params) {
        JSONObject retObj = new JSONObject();
        KGHttpUtils httpUtils = new KGHttpUtils();
        String authOrizeCode = params.getString("appCode");
        if (authOrizeCode != null && !authOrizeCode.equals("")) {
            httpUtils.setAuthOrizeCode(authOrizeCode);
        }
        List<Object> seals = null;
        try {
            if (!Contants.VERIFY_CAPTCHA) {
                MsgServerUtils.verifyPwd(keysn, pwd);
            }
            seals = "PT".equals(params.getString("sealType")) ? httpUtils.getServerSeal(Contants.URL, KGServerTypeEnum.AUTO, keysn, null) : httpUtils.getServerGMSeal(Contants.URL, null, keysn, null);
            String filterSealNames = params.getString("filterSealNames");
            if (filterSealNames != null && !"".equals(filterSealNames)) {
                seals = this.filterSeal(seals, filterSealNames);
            }
        }
        catch (Exception e) {
            String message = null;
            if (!(e instanceof KGServerInterfaceErrorException)) {
                throw new RuntimeException(e);
            }
            message = e.getMessage();
            retObj.put("status", (Object)false);
            retObj.put("message", (Object)message);
            return retObj;
        }
        if (seals == null || seals.size() == 0) {
            retObj.put("status", (Object)false);
            retObj.put("message", (Object)"\u6ca1\u6709\u53ef\u7528\u7684\u5370\u7ae0\uff01");
            return retObj;
        }
        KGBase64 base64 = new KGBase64();
        JSONArray array = new JSONArray();
        for (SealInformation seal : seals) {
            int version = 0;
            String sealData = seal.getSealData();
            if (sealData != null && sealData.length() != 0) {
                SealGM sealInfo = SealUtil.getSealInfo((byte[])base64.decode(sealData));
                version = sealInfo.getVersion();
            }
            String sealtag = "PT";
            if (version != 0) {
                sealtag = "GM";
            }
            JSONObject sealObj = new JSONObject();
            sealObj.put("version", (Object)version);
            sealObj.put("keySN", (Object)seal.getKeySN());
            sealObj.put("userName", (Object)seal.getImgUserName());
            sealObj.put("unitName", (Object)seal.getImgUnitName());
            sealObj.put("signSN", (Object)seal.getSignSN());
            sealObj.put("signName", (Object)seal.getImgSignName());
            sealObj.put("width", (Object)Float.valueOf(Float.valueOf(seal.getImgWidth()).floatValue() * 28.346457f));
            sealObj.put("height", (Object)Float.valueOf(Float.valueOf(seal.getImgHeight()).floatValue() * 28.346457f));
            String imgType = seal.getImgFileExt().substring(1);
            sealObj.put("imgdata", (Object)("data:image/" + imgType + ";base64," + base64.encode(seal.getImgValue())));
            sealObj.put("imgExt", (Object)imgType);
            sealObj.put("sealData", (Object)seal.getSealData());
            sealObj.put("phone", (Object)seal.getPhone());
            sealObj.put("sealtag", (Object)sealtag);
            array.add((Object)sealObj);
        }
        retObj.put("status", (Object)true);
        retObj.put("seals", (Object)array);
        return retObj;
    }

    private List<SealInformation> filterSeal(List<SealInformation> seals, String filterSealNames) {
        ArrayList<SealInformation> filterSeals = new ArrayList<SealInformation>();
        JSONArray namesArray = JSONObject.parseArray((String)filterSealNames);
        block0: for (int i = 0; i < namesArray.size(); ++i) {
            String sealName = namesArray.getString(i);
            for (SealInformation sealInformation : seals) {
                if (!sealInformation.getImgSignName().equals(sealName)) continue;
                filterSeals.add(sealInformation);
                continue block0;
            }
        }
        return filterSeals;
    }
}

