/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.img.ImageUtils;
import com.kinggrid.kgcore.IMsgServer;
import com.kinggrid.kgcore.KGHttpUtils;
import com.kinggrid.kgcore.SealInformation;
import com.kinggrid.kgcore.enmu.KGServerTypeEnum;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetPrepareSealAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        String sealNames = params.getString("sealNames");
        if (sealNames == null || sealNames.length() == 0) {
            throw new IllegalArgumentException("\u5370\u7ae0\u540d\u79f0\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        JSONObject retObj = new JSONObject();
        JSONArray sealsArray = new JSONArray();
        List<SealInformation> sealInformations = this.getSealInformations(sealNames);
        for (SealInformation sealInformation : sealInformations) {
            JSONObject sealObj = new JSONObject();
            KGBase64 base64 = new KGBase64();
            sealObj.put("keysn", (Object)sealInformation.getKeySN());
            sealObj.put("sealName", (Object)sealInformation.getImgSignName());
            sealObj.put("width", (Object)Float.valueOf(Float.valueOf(sealInformation.getImgWidth()).floatValue() * 28.346457f));
            sealObj.put("height", (Object)Float.valueOf(Float.valueOf(sealInformation.getImgHeight()).floatValue() * 28.346457f));
            byte[] grayImage = this.getGrayImage(sealInformation.getImgValue());
            sealObj.put("imgdata", (Object)("data:image/png;base64," + base64.encode(com.kinggrid.pdfviewer.utils.ImageUtils.imgToTransparence(grayImage))));
            sealsArray.add((Object)sealObj);
        }
        retObj.put("status", (Object)true);
        retObj.put("seals", (Object)sealsArray);
        response.getWriter().write(retObj.toJSONString());
    }

    private byte[] getGrayImage(byte[] image) {
        byte[] grayImage = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(image));
            grayImage = ImageUtils.imageToGray((BufferedImage)bufferedImage, (Color)new Color(105, 105, 105));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return grayImage;
    }

    private List<SealInformation> getSealInformations(String sealNames) {
        KGHttpUtils kgHttpUtils = new KGHttpUtils();
        IMsgServer msgServer = new IMsgServer();
        msgServer.setCharset("GBK");
        msgServer.SetMsgByName("OPTION", "GETNETFILESIGNATURESLIST");
        msgServer.SetMsgByName("SIGNATURENAME", sealNames);
        kgHttpUtils.sendPacktToServer(Contants.URL, msgServer);
        String userInfo = msgServer.GetMsgByName("USERINFO");
        String netFileSignatures = msgServer.GetMsgByName("NETFILESIGNATURES");
        if (netFileSignatures == null || netFileSignatures.length() == 0) {
            throw new IllegalArgumentException("\u5370\u7ae0\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<SealInformation> list = new ArrayList<SealInformation>();
        String[] tmp = userInfo.split(";");
        String[] signDatas = netFileSignatures.split(";");
        String signData = null;
        SealInformation sealInformation = null;
        if (signDatas != null && signDatas.length > 0) {
            for (int i = 0; i < signDatas.length; ++i) {
                sealInformation = new SealInformation();
                sealInformation.setKeySN(tmp[i].split(",")[0]);
                sealInformation.setKeySerial(tmp[i].split(",")[0]);
                signData = signDatas[i];
                String[] signParams = signData.split(",");
                if (signParams.length > 2) {
                    sealInformation.setImgSignName(signParams[1]);
                }
                kgHttpUtils.parserSignData(signData, KGServerTypeEnum.AUTO, sealInformation);
                list.add(sealInformation);
            }
        }
        return list;
    }
}

