/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.KGitextpdf.text.pdf.PRAcroForm;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.utils.KGPdfUtils;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.MsgServerUtils;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DeleteSealAction
implements PdfActionInter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        Map<String, Object> map;
        PdfStamper pdfStamper;
        PdfReader pdfReader;
        OutputStream out;
        InputStream in;
        KGPdfHummer hummer;
        JSONObject retObj;
        String keySN;
        int page;
        block43: {
            String documentId = params.getString("documentId");
            page = params.getIntValue("page");
            float x = params.getFloatValue("x");
            float y = params.getFloatValue("y");
            if (pdfFileResource == null) {
                pdfFileResource = PdfFileResourceManager.getPdfFileResource();
            }
            pdfFileResource.init(request, response, action, documentId);
            keySN = pdfFileResource.getkeySN(params.getString("keySN"));
            retObj = new JSONObject();
            hummer = null;
            in = null;
            out = null;
            if (Contants.VERIFY_CAPTCHA) {
                MsgServerUtils.verifyCaptcha(keySN, params.getString("captcha"));
            }
            if (Contants.VERIFYPWD) {
                MsgServerUtils.verifyPwd(keySN, params.getString("password"));
            }
            String pdfFile = pdfFileResource.getPdfFile();
            in = pdfFileResource.getPdfFileStream();
            out = pdfFileResource.getSavePdfFileSteam();
            hummer = PdfUtils.getPdfHummer(pdfFile, in, out, params.getString("pdfPwd"));
            pdfReader = hummer.getPdfReader();
            pdfStamper = hummer.getPdfStamper();
            map = PdfUtils.getPdfDictionaryOfXY(pdfReader, page, x, y);
            if (map != null) break block43;
            retObj.put("status", (Object)false);
            retObj.put("message", (Object)"\u5370\u7ae0\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u52a0\u8f7d\u6587\u6863\uff01");
            response.getWriter().write(retObj.toJSONString());
            hummer.getPdfStamper().close();
            PdfUtils.close(in);
            PdfUtils.close(out);
            if (hummer != null) {
                hummer.close();
            }
            if (retObj.getBooleanValue("status")) {
                pdfFileResource.success();
            } else {
                pdfFileResource.fail();
            }
            return;
        }
        try {
            int idx = (Integer)map.get("idx");
            PdfDictionary annot = (PdfDictionary)map.get("annot");
            PdfName subtype = annot.getAsName(PdfName.SUBTYPE);
            PdfName ft = annot.getAsName(PdfName.FT);
            if (KGElectronicSealName.SEAL.equals((Object)subtype)) {
                Map sealMsg;
                PdfIndirectReference parentRef = annot.getAsIndirectObject(PdfName.PARENT);
                PdfIndirectReference pageRef = annot.getAsIndirectObject(PdfName.P);
                PdfDictionary pageDic = null;
                if (parentRef != null) {
                    pageDic = (PdfDictionary)PdfReader.getPdfObject((PdfObject)pageRef);
                    annot = (PdfDictionary)PdfReader.getPdfObject((PdfObject)parentRef);
                    idx = -1;
                    for (int i = 0; i < pdfReader.getNumberOfPages(); ++i) {
                        PdfDictionary dic = pdfReader.getPageN(i + 1);
                        if (dic.getIndRef().getNumber() != pageDic.getIndRef().getNumber()) continue;
                        page = i + 1;
                        break;
                    }
                } else {
                    pageDic = pdfReader.getPageN(page);
                }
                if (keySN.equals((sealMsg = KGPdfUtils.parseSeal((PdfDictionary)annot)).get("KeySerial"))) {
                    PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
                    if (idx == -1) {
                        for (int i = 0; i < annots.size(); ++i) {
                            PdfDictionary dic = annots.getAsDict(i);
                            if (dic.getIndRef().getNumber() != annot.getIndRef().getNumber()) continue;
                            annots.remove(i);
                        }
                    } else {
                        annots.remove(idx);
                    }
                    int numb = pdfReader.getCatalog().getAsNumber(KGElectronicSealName.SEALNUM).intValue();
                    PdfDictionary root = pdfReader.getCatalog();
                    root.put(KGElectronicSealName.SEALNUM, (PdfObject)new PdfNumber(--numb));
                    pdfStamper.markUsed((PdfObject)annots);
                    pdfStamper.markUsed((PdfObject)pageDic);
                    pdfStamper.markUsed((PdfObject)root);
                    retObj.put("status", (Object)true);
                    PdfArray childlist = annot.getAsArray(KGElectronicSealName.CHILDLIST);
                    if (childlist != null) {
                        JSONObject delSeals = this.deleteDzqzChildlist(pdfReader, pdfStamper, childlist);
                        JSONArray delarray = delSeals.getJSONArray(String.valueOf(page - 1));
                        if (delarray != null) {
                            delarray.add((Object)(annot.getIndRef().getNumber() + "R"));
                        } else {
                            delarray = new JSONArray();
                            delarray.add((Object)(annot.getIndRef().getNumber() + "R"));
                            delSeals.put(String.valueOf(String.valueOf(page - 1)), (Object)delarray);
                        }
                        retObj.put("delSeals", (Object)delSeals);
                    }
                } else {
                    retObj.put("status", (Object)false);
                    retObj.put("message", (Object)("\u5f53\u524d\u7528\u6237\u4e0d\u662f" + (String)sealMsg.get("KeySerial") + "\uff0c\u6ca1\u6709\u5220\u9664\u6743\u9650\uff01"));
                }
            } else if (PdfName.WIDGET.equals((Object)subtype) && PdfName.SIG.equals((Object)ft)) {
                PRStream kgProperty = (PRStream)annot.getAsStream(new PdfName("KGPROPERTY"));
                PRStream isp = (PRStream)annot.getAsStream(new PdfName("ISP"));
                if (kgProperty != null || isp != null) {
                    JSONObject obj = null;
                    obj = kgProperty != null ? PdfUtils.parseKgProperty(kgProperty) : PdfUtils.parseISP(isp);
                    if (obj.getString("scanStamp") != null && "1".equals(obj.getString("scanStamp"))) {
                        if (params.getString("qrCodeUserUid").equals(obj.getString("scanUserId"))) {
                            JSONObject delSeals = this.deleteSig(pdfReader, pdfStamper, annot);
                            retObj.put("status", (Object)true);
                            retObj.put("delSeals", (Object)delSeals);
                        } else {
                            retObj.put("status", (Object)false);
                            retObj.put("message", (Object)("\u5f53\u524d\u626b\u7801\u7528\u6237\u4e0d\u662f" + obj.get((Object)"scanUserName") + "\uff0c\u6ca1\u6709\u5220\u9664\u6743\u9650\uff01"));
                        }
                    } else if (keySN.equals(obj.getString("keySN"))) {
                        JSONObject delSeals = this.deleteSig(pdfReader, pdfStamper, annot);
                        retObj.put("status", (Object)true);
                        retObj.put("delSeals", (Object)delSeals);
                    } else {
                        retObj.put("status", (Object)false);
                        retObj.put("message", (Object)("\u5f53\u524d\u7528\u6237\u4e0d\u662f" + obj.get((Object)"keySN") + "\uff0c\u6ca1\u6709\u5220\u9664\u6743\u9650\uff01"));
                    }
                } else {
                    retObj.put("status", (Object)false);
                    retObj.put("message", (Object)"\u975e\u91d1\u683c\u4ea7\u54c1\u52a0\u76d6\u5370\u7ae0\uff0c\u4e0d\u652f\u6301\u5220\u9664\uff01");
                }
            }
            hummer.getPdfStamper().close();
        }
        catch (Exception e) {
            try {
                if (!(e instanceof KGServerInterfaceErrorException)) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                retObj.put("status", (Object)false);
                retObj.put("message", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                PdfUtils.close(in);
                PdfUtils.close(out);
                if (hummer != null) {
                    hummer.close();
                }
                if (retObj.getBooleanValue("status")) {
                    pdfFileResource.success();
                } else {
                    pdfFileResource.fail();
                }
                throw throwable;
            }
            PdfUtils.close(in);
            PdfUtils.close(out);
            if (hummer != null) {
                hummer.close();
            }
            if (retObj.getBooleanValue("status")) {
                pdfFileResource.success();
            } else {
                pdfFileResource.fail();
            }
        }
        PdfUtils.close(in);
        PdfUtils.close(out);
        if (hummer != null) {
            hummer.close();
        }
        if (retObj.getBooleanValue("status")) {
            pdfFileResource.success();
        } else {
            pdfFileResource.fail();
        }
        response.getWriter().write(retObj.toJSONString());
    }

    private JSONObject deleteDzqzChildlist(PdfReader pdfReader, PdfStamper pdfStamper, PdfArray childlist) {
        JSONObject delSeals = new JSONObject();
        int startPage = 0;
        for (int i = 0; i < childlist.size(); i += 2) {
            JSONArray delarray;
            PdfIndirectReference pageRef = childlist.getAsIndirectObject(i);
            PdfIndirectReference annotRef = childlist.getAsIndirectObject(i + 1);
            PdfDictionary pageDic = (PdfDictionary)PdfReader.getPdfObject((PdfObject)pageRef);
            PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
            for (int idx = 0; idx < annots.length(); ++idx) {
                PdfDictionary _annot = annots.getAsDict(idx);
                if (_annot.getIndRef().getNumber() != annotRef.getNumber()) continue;
                annots.remove(idx);
                break;
            }
            pdfStamper.markUsed((PdfObject)annots);
            pdfStamper.markUsed((PdfObject)pageDic);
            PdfNumber straddleNumber = pdfReader.getCatalog().getAsNumber(KGElectronicSealName.STRADDLE);
            if (straddleNumber != null) {
                int numb = straddleNumber.intValue();
                PdfDictionary root = pdfReader.getCatalog();
                root.put(KGElectronicSealName.STRADDLE, (PdfObject)new PdfNumber(--numb));
                pdfStamper.markUsed((PdfObject)root);
            }
            int pageIndex = -1;
            while (startPage < pdfReader.getNumberOfPages()) {
                PRIndirectReference currentRef = pdfReader.getPageOrigRef(startPage + 1);
                if (currentRef.getNumber() == pageRef.getNumber()) {
                    pageIndex = startPage;
                    break;
                }
                ++startPage;
            }
            if ((delarray = delSeals.getJSONArray(String.valueOf(pageIndex))) != null) {
                delarray.add((Object)(annotRef.getNumber() + "R"));
                continue;
            }
            delarray = new JSONArray();
            delarray.add((Object)(annotRef.getNumber() + "R"));
            delSeals.put(String.valueOf(pageIndex), (Object)delarray);
        }
        return delSeals;
    }

    private JSONObject deleteSig(PdfReader pdfReader, PdfStamper pdfStamper, PdfDictionary annot) {
        PdfDictionary vdic = annot.getAsDict(PdfName.V);
        int number = vdic.getIndRef().getNumber();
        PRAcroForm acroForm = pdfReader.getAcroForm();
        PdfArray fields = acroForm.getAsArray(PdfName.FIELDS);
        int sealNumber = 0;
        int i = 0;
        while (i < fields.size()) {
            PdfDictionary dic = fields.getAsDict(i);
            PdfDictionary sigV = dic.getAsDict(PdfName.V);
            if (sigV != null && number == sigV.getIndRef().getNumber()) {
                fields.remove(i);
                ++sealNumber;
                continue;
            }
            ++i;
        }
        pdfStamper.markUsed((PdfObject)acroForm);
        pdfStamper.markUsed((PdfObject)pdfReader.getCatalog());
        JSONObject delSeals = new JSONObject();
        for (int i2 = 0; i2 < pdfReader.getNumberOfPages(); ++i2) {
            PdfDictionary pageDic = pdfReader.getPageN(i2 + 1);
            PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
            if (annots == null) continue;
            JSONArray delarray = new JSONArray();
            int k = 0;
            while (k < annots.size()) {
                PdfDictionary dic = annots.getAsDict(k);
                PdfDictionary sigV = dic.getAsDict(PdfName.V);
                if (sigV != null && number == sigV.getIndRef().getNumber()) {
                    annots.remove(k);
                    --sealNumber;
                    delarray.add((Object)(dic.getIndRef().getNumber() + "R"));
                    continue;
                }
                ++k;
            }
            if (delarray.size() > 0) {
                delSeals.put(String.valueOf(i2), (Object)delarray);
            }
            pdfStamper.markUsed((PdfObject)annots);
            pdfStamper.markUsed((PdfObject)pageDic);
            if (sealNumber == 0) break;
        }
        return delSeals;
    }
}

