/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.alibaba.fastjson.JSONObject;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.x509.Certificate;

public class CertExpiryVerifyAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        String certBase64 = params.getString("cert");
        KGBase64 base64 = new KGBase64();
        byte[] cert = base64.decode(certBase64);
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)cert);
        Certificate certificate = Certificate.getInstance((Object)seq);
        Date endDate = certificate.getEndDate().getDate();
        Date nowDate = Calendar.getInstance().getTime();
        JSONObject retObj = new JSONObject();
        int certStatus = 0;
        int ret = KGDateUtils.compareDate((Date)nowDate, (Date)endDate);
        if (ret >= 0) {
            certStatus = 0;
        } else {
            certStatus = 2;
            int days = this.numberOfDaysApart(nowDate, endDate) + 1;
            if (days <= 40) {
                certStatus = 1;
                retObj.put("days", (Object)days);
            }
        }
        retObj.put("status", (Object)true);
        retObj.put("certStatus", (Object)certStatus);
        response.getWriter().write(retObj.toJSONString());
    }

    public int numberOfDaysApart(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }
}

