/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer;

import com.alibaba.fastjson.JSONObject;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.HttpClientSupportSSL;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.action.AddWatermarkAction;
import com.kinggrid.pdfviewer.action.CertExpiryVerifyAction;
import com.kinggrid.pdfviewer.action.CheckLastoneAction;
import com.kinggrid.pdfviewer.action.DeleteSealAction;
import com.kinggrid.pdfviewer.action.DownloadAction;
import com.kinggrid.pdfviewer.action.GetAnnotsListAction;
import com.kinggrid.pdfviewer.action.GetFontsAction;
import com.kinggrid.pdfviewer.action.GetLicenseInfoAction;
import com.kinggrid.pdfviewer.action.GetPhoneAction;
import com.kinggrid.pdfviewer.action.GetPrepareSealAction;
import com.kinggrid.pdfviewer.action.GetQrCodeImageAction;
import com.kinggrid.pdfviewer.action.GetQrCodeUserInfoAction;
import com.kinggrid.pdfviewer.action.GetSealsAction;
import com.kinggrid.pdfviewer.action.GetUserAction;
import com.kinggrid.pdfviewer.action.HandleCilentSealAction;
import com.kinggrid.pdfviewer.action.ImageToBase64Action;
import com.kinggrid.pdfviewer.action.ImageToTransparenceAction;
import com.kinggrid.pdfviewer.action.ImportAnnotsAction;
import com.kinggrid.pdfviewer.action.ReWriteSigDataAction;
import com.kinggrid.pdfviewer.action.SendCaptchaAction;
import com.kinggrid.pdfviewer.action.StampSealAction;
import com.kinggrid.pdfviewer.action.VerifyAllSealAction;
import com.kinggrid.pdfviewer.action.VerifyBlockChainAction;
import com.kinggrid.pdfviewer.action.VerifySealAction;
import com.kinggrid.pdfviewer.action.VerifySealOnLoadAction;
import com.kinggrid.pdfviewer.action.annot.AddAnnotAction;
import com.kinggrid.pdfviewer.action.annot.DeleteAnnotAction;
import com.kinggrid.pdfviewer.action.ofd.CheckLastoneOfdAction;
import com.kinggrid.pdfviewer.action.ofd.DeleteSealOfdAction;
import com.kinggrid.pdfviewer.action.ofd.DownloadOfdAction;
import com.kinggrid.pdfviewer.action.ofd.HandleClientSealOfdAction;
import com.kinggrid.pdfviewer.action.ofd.ReWriteSigDataOfdAction;
import com.kinggrid.pdfviewer.action.ofd.StampSealOfdAction;
import com.kinggrid.pdfviewer.action.ofd.VerifySealOfdAction;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.io.IOUtils;
import org.kg.bouncycastle.jce.provider.BouncyCastleProvider;

public class PdfViewer {
    private static final String CHARSET = "UTF-8";
    private static final Map<String, PdfActionInter> map = new HashMap<String, PdfActionInter>();
    private static final Map<String, PdfActionInter> mapOfd = new HashMap<String, PdfActionInter>();
    private static final Cache cache;

    public static void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        PdfViewer.execute(request, response, null);
    }

    public static void execute(HttpServletRequest request, HttpServletResponse response, PdfFileResource pdfFileResource) throws Exception {
        request.setCharacterEncoding(CHARSET);
        response.setCharacterEncoding(CHARSET);
        response.setContentType("application/json;charset=UTF-8");
        String contentType = request.getContentType();
        JSONObject reqJsonObj = null;
        String action = null;
        if (contentType != null && contentType.startsWith("application/json")) {
            String content = new String(IOUtils.toByteArray((InputStream)request.getInputStream()), CHARSET);
            reqJsonObj = JSONObject.parseObject((String)content);
            action = reqJsonObj.getString("action");
        } else {
            action = request.getParameter("action");
        }
        String documentId = null;
        String certOrigin = null;
        String docType = request.getParameter("docType");
        boolean isKeySign = false;
        if (reqJsonObj != null) {
            documentId = reqJsonObj.getString("documentId");
            certOrigin = reqJsonObj.getString("certOrigin");
            boolean bl = isKeySign = "stampSeal".equals(action) && "1".equals(certOrigin);
        }
        if (Contants.ENABLE_CONCURRENCY_LIMIT && ("stampSeal".equals(action) || "deleteSeal".equals(action) || "improtAnnots".equals(action) || "addWatermark".equals(action)) && (PdfViewer.getCacheValue(documentId) != null || !PdfViewer.setCache(documentId, "documentId"))) {
            JSONObject retObj = new JSONObject();
            retObj.put("status", (Object)false);
            retObj.put("message", (Object)"\u5f53\u524d\u6587\u6863\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\uff0c\u8bf7\u60a8\u7a0d\u540e\u518d\u64cd\u4f5c\uff01");
            response.getWriter().print(retObj.toJSONString());
            return;
        }
        try {
            PdfActionInter pdfAction = null;
            pdfAction = "1".equals(docType) ? mapOfd.get(action) : map.get(action);
            if (pdfAction == null) {
                throw new IllegalArgumentException("aciton not exist\uff1a" + action);
            }
            pdfAction.execute(request, response, action, reqJsonObj, pdfFileResource);
        }
        catch (Exception e) {
            if (Contants.ENABLE_CONCURRENCY_LIMIT && isKeySign) {
                PdfViewer.removeCache(documentId);
            }
            throw e;
        }
        finally {
            if (Contants.ENABLE_CONCURRENCY_LIMIT && ("stampSeal".equals(action) || "deleteSeal".equals(action) || "reWriteSigData".equals(action) || "improtAnnots".equals(action) || "addWatermark".equals(action)) && !isKeySign) {
                PdfViewer.removeCache(documentId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setCache(String key, String value) {
        cache.acquireWriteLockOnKey((Object)key);
        if (cache.get((Serializable)((Object)key)) != null) {
            return false;
        }
        try {
            Element element = new Element((Serializable)((Object)key), (Serializable)((Object)value));
            cache.put(element);
            boolean bl = true;
            return bl;
        }
        finally {
            cache.releaseWriteLockOnKey((Object)key);
        }
    }

    public static String getCacheValue(String key) {
        Element element = cache.get((Serializable)((Object)key));
        if (element == null) {
            return null;
        }
        return element.getObjectValue().toString();
    }

    public static void removeCache(String key) {
        cache.remove((Serializable)((Object)key));
    }

    public static void put(String key, PdfActionInter obj) {
        map.put(key, obj);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        map.put("download", new DownloadAction());
        map.put("getSeals", new GetSealsAction());
        map.put("stampSeal", new StampSealAction());
        map.put("verifySealOnLoad", new VerifySealOnLoadAction());
        map.put("verifySeal", new VerifySealAction());
        map.put("verifyBlockChain", new VerifyBlockChainAction());
        map.put("deleteSeal", new DeleteSealAction());
        map.put("handleCilentSeal", new HandleCilentSealAction());
        map.put("reWriteSigData", new ReWriteSigDataAction());
        map.put("checkLastone", new CheckLastoneAction());
        map.put("verifyAllSeal", new VerifyAllSealAction());
        map.put("getAnnotsList", new GetAnnotsListAction());
        map.put("imageToTransparence", new ImageToTransparenceAction());
        map.put("improtAnnots", new ImportAnnotsAction());
        map.put("addWatermark", new AddWatermarkAction());
        map.put("imageToBase64", new ImageToBase64Action());
        map.put("getFonts", new GetFontsAction());
        map.put("sendCaptcha", new SendCaptchaAction());
        map.put("getPhone", new GetPhoneAction());
        map.put("getUser", new GetUserAction());
        map.put("getLicenseInfo", new GetLicenseInfoAction());
        map.put("getPrepareSeal", new GetPrepareSealAction());
        map.put("addAnnot", new AddAnnotAction());
        map.put("deleteAnnot", new DeleteAnnotAction());
        map.put("getQrCodeImage", new GetQrCodeImageAction());
        map.put("getQrCodeUserInfo", new GetQrCodeUserInfoAction());
        map.put("certExpiryVerify", new CertExpiryVerifyAction());
        mapOfd.put("download", new DownloadOfdAction());
        mapOfd.put("getSeals", new GetSealsAction());
        mapOfd.put("stampSeal", new StampSealOfdAction());
        mapOfd.put("handleCilentSeal", new HandleClientSealOfdAction());
        mapOfd.put("reWriteSigData", new ReWriteSigDataOfdAction());
        mapOfd.put("verifySeal", new VerifySealOfdAction());
        mapOfd.put("verifyBlockChain", new VerifyBlockChainAction());
        mapOfd.put("deleteSeal", new DeleteSealOfdAction());
        mapOfd.put("checkLastone", new CheckLastoneOfdAction());
        mapOfd.put("sendCaptcha", new SendCaptchaAction());
        mapOfd.put("getPhone", new GetPhoneAction());
        mapOfd.put("getFonts", new GetFontsAction());
        mapOfd.put("imageToBase64", new ImageToBase64Action());
        mapOfd.put("addWatermark", new AddWatermarkAction());
        mapOfd.put("getLicenseInfo", new GetLicenseInfoAction());
        mapOfd.put("certExpiryVerify", new CertExpiryVerifyAction());
        HttpClientSupportSSL.init();
        InputStream in = null;
        try {
            in = PdfViewer.class.getResourceAsStream("/ehcache-pdfviewer.xml");
            CacheManager cacheManager = CacheManager.create((InputStream)in);
            cache = cacheManager.getCache("pdfviewerCache");
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

