/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer;

import com.kinggrid.encrypt.KGBase64;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class License {
    private static License license = new License();
    private static final String BASE64TABLE = "=ABCDEFGHIJKLabcdefghijklmnopqrstuvwxyzMNOPQRSTUVWXYZ0123456789+/";
    private static final String LIC = "/iSignature_Cloud_API.lic";
    private static String filePath = null;
    private static long lastModified = -1L;
    private static String companyName;
    private static String issue_date;

    public static String getCompanyName() {
        License.license();
        return companyName;
    }

    public static String getIssueDate() {
        License.license();
        return issue_date;
    }

    public static void license() {
        if (license.isReplaced()) {
            License.readLic(license.getLicenseFromLic());
        }
    }

    private boolean isReplaced() {
        if (lastModified == -1L) {
            return true;
        }
        if (filePath != null) {
            File file = new File(filePath);
            if (file.exists()) {
                long newLastModified = file.lastModified();
                return newLastModified != lastModified;
            }
            return false;
        }
        return false;
    }

    private static void readLic(String content) {
        if (content == null) {
            companyName = "\u91d1\u683c\u79d1\u6280\u6f14\u793a\u4e13\u7528\uff0c\u8bf7\u8d2d\u4e70\u6b63\u5f0f\u7248\uff01";
            return;
        }
        try {
            Document document = DocumentHelper.parseText((String)content);
            Node iCloudRead = document.selectSingleNode("/kinggrid/iCloudRead");
            if (iCloudRead == null) {
                companyName = "\u91d1\u683c\u79d1\u6280\u6f14\u793a\u4e13\u7528\uff0c\u8bf7\u8d2d\u4e70\u6b63\u5f0f\u7248\uff01";
            } else {
                companyName = document.selectSingleNode("/kinggrid/iSignature_PDF_API/item[@name='company']").getText();
                issue_date = document.selectSingleNode("/kinggrid/iSignature_PDF_API/item[@name='expiredDateTime']").getText();
            }
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private String getLicenseFromLic() {
        InputStream in = null;
        String license = null;
        try {
            File file = null;
            if (filePath != null) {
                file = new File(filePath);
            } else {
                URL url = License.class.getResource(LIC);
                if (url != null) {
                    filePath = URLDecoder.decode(url.getPath(), "UTF-8");
                    file = new File(filePath);
                }
            }
            if (file != null && file.exists()) {
                lastModified = file.lastModified();
                in = new FileInputStream(file);
            } else {
                lastModified = System.currentTimeMillis();
                in = License.class.getResourceAsStream(LIC);
            }
            if (in == null) {
                throw new IllegalArgumentException("\u8bf7\u6309\u8981\u6c42\u653e\u7f6e\u6388\u6743\u6587\u4ef6iSignature_Cloud_API.lic");
            }
            in = new BufferedInputStream(in);
            byte[] buff = new byte[in.available()];
            in.read(buff);
            KGBase64 base64 = new KGBase64();
            base64.setBase64Table(BASE64TABLE);
            license = new String(base64.decode(new String(buff)), "UTF-8");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                License.close(in);
                throw throwable;
            }
        }
        License.close(in);
        return license;
    }

    public static void setLicenseFilePath(String licenseFilePath) {
        filePath = licenseFilePath;
    }

    private static void close(Closeable able) {
        try {
            if (able != null) {
                able.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        issue_date = null;
    }
}

