/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageUtils {
    public static byte[] imgToTransparence(byte[] imagebyte) throws IOException {
        BufferedImage bi;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(imagebyte);
        BufferedImage image = bi = ImageIO.read(byteArrayInputStream);
        ImageIcon imageIcon = new ImageIcon(image);
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
        Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
        g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        int alpha = 0;
        for (int i = bufferedImage.getMinY(); i < bufferedImage.getHeight(); ++i) {
            for (int j = bufferedImage.getMinX(); j < bufferedImage.getWidth(); ++j) {
                int rgb = bufferedImage.getRGB(j, i);
                int R = (rgb & 0xFF0000) >> 16;
                int G = (rgb & 0xFF00) >> 8;
                int B = rgb & 0xFF;
                if (255 - R < 30 && 255 - G < 30 && 255 - B < 30) {
                    rgb = alpha + 1 << 24 | rgb & 0xFFFFFF;
                }
                bufferedImage.setRGB(j, i, rgb);
            }
        }
        g2D.drawImage((Image)bufferedImage, 0, 0, imageIcon.getImageObserver());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

