/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.pdf.electronicseal.impl;

import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.security.PdfPKCS7;
import com.alibaba.fastjson.JSONObject;
import com.kgofd.encrypt.SM2;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.encrypt.KGSignature;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.pdf.executes.customize.DisposeSigndataToClient;
import com.kinggrid.pdf.executes.entity.SignSealInfo;
import com.kinggrid.pdf.utils.AnalyticalSealUtil;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.PVHttpUtil;
import com.kinggrid.pdfviewer.pdf.electronicseal.VerifyDigitalSignature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.kg.bouncycastle.asn1.x509.TBSCertificateStructure;

public class VerifyDigitalSignatureSoftVImpl
implements VerifyDigitalSignature {
    private Date date;

    @Override
    public boolean verify(byte[] cert, byte[] sigData, String newDigest, PdfDictionary annot, Map<String, String> sealMap, JSONObject obj) {
        try {
            boolean sigEffectiveness = false;
            KGBase64 base64 = new KGBase64();
            String sigDataBase64 = new String(sigData);
            PdfString eSType = annot.getAsString(new PdfName("ESType"));
            if (base64.decode(sigDataBase64)[0] == 48 && annot.getAsString(new PdfName("ESType")) == null) {
                PdfPKCS7 pdfPKCS7 = new PdfPKCS7(base64.decode(sigDataBase64), new PdfName("KG"), "KGBC");
                byte[] extSignature = pdfPKCS7.getDigest();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate oCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert));
                sigEffectiveness = KGSignature.verify((Certificate)oCert, (byte[])extSignature, (byte[])newDigest.getBytes(), (String)pdfPKCS7.getDigestAlgorithm());
            } else if (eSType != null) {
                PVHttpUtil pvHttpUtil;
                Map<String, Object> map;
                if (new PdfString("GB").equals(eSType) && Contants.CHECK_SEAL_STATS && !"0".equals((map = (pvHttpUtil = new PVHttpUtil()).checkSealStats(Contants.URL, sigDataBase64)).get("code"))) {
                    throw new KGServerInterfaceErrorException("\u9a8c\u8bc1\u5370\u7ae0\u72b6\u6001\u6709\u6548\u6027\u5931\u8d25\uff1a" + map.get("message"));
                }
                ASN1Sequence sequence = DERSequence.getInstance((Object)base64.decode(sigDataBase64));
                SignSealInfo signSealInfo = AnalyticalSealUtil.sealinfo((ASN1Sequence)sequence);
                byte[] signVal = signSealInfo.getSignData();
                if (signVal.length != 64) {
                    signVal = VerifyDigitalSignatureSoftVImpl.sigDataAns1To64bit(signVal);
                }
                sigEffectiveness = this.sm2Verify(signSealInfo.getTosignData(), signSealInfo.getCert(), signVal);
                String signDate = signSealInfo.getSignDate();
                this.date = KGDateUtils.parseGMT2Date((String)signDate);
                if (sigEffectiveness) {
                    MessageDigest messageDigest = MessageDigest.getInstance("SM3", "KGBC");
                    messageDigest.update(newDigest.getBytes());
                    byte[] newSM3Hash = messageDigest.digest();
                    if (!Arrays.equals(signSealInfo.getHash(), newSM3Hash)) {
                        sigEffectiveness = false;
                    }
                }
            } else {
                byte[] signbyte = DisposeSigndataToClient.dismantleSigndata((byte[])sigDataBase64.getBytes());
                if (signbyte.length != 64) {
                    signbyte = VerifyDigitalSignatureSoftVImpl.sigDataAns1To64bit(signbyte);
                }
                sigEffectiveness = this.sm2Verify(newDigest.getBytes("UTF-8"), cert, signbyte);
            }
            return sigEffectiveness;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String esType(PdfDictionary annot, Map<String, String> sealMap) {
        return null;
    }

    public Date getSignDate() {
        return this.date;
    }

    private boolean sm2Verify(byte[] msg, byte[] cert, byte[] signedData) throws IOException {
        TBSCertificateStructure tbsCert = VerifyDigitalSignatureSoftVImpl.getTbsCert(cert);
        byte[] pk = VerifyDigitalSignatureSoftVImpl.getPubkey(tbsCert);
        SM2 sm2 = new SM2(true);
        return sm2.Verify(msg, signedData, pk);
    }

    public static byte[] getPubkey(TBSCertificateStructure tbsCert) {
        SubjectPublicKeyInfo subPublicKeyInfo = tbsCert.getSubjectPublicKeyInfo();
        byte[] pubkey = subPublicKeyInfo.getPublicKeyData().getBytes();
        byte[] pk = new byte[64];
        System.arraycopy(pubkey, 1, pk, 0, 64);
        return pk;
    }

    public static TBSCertificateStructure getTbsCert(byte[] cert) throws IOException {
        ASN1Sequence certSeq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])cert);
        return TBSCertificateStructure.getInstance((Object)certSeq.getObjectAt(0));
    }

    private static byte[] sigDataAns1To64bit(byte[] signData) throws IOException {
        int srcPos;
        int dest;
        ASN1Sequence sequense = ASN1Sequence.getInstance((Object)signData);
        ASN1Integer ans1Int0 = (ASN1Integer)sequense.getObjectAt(0);
        ASN1Integer ans1Int1 = (ASN1Integer)sequense.getObjectAt(1);
        byte[] sig1 = ans1Int0.getValue().toByteArray();
        byte[] sig2 = ans1Int1.getValue().toByteArray();
        byte[] buff = new byte[64];
        if (sig1.length < 32) {
            dest = 32 - sig1.length;
            System.arraycopy(sig1, 0, buff, dest, sig1.length);
        } else {
            srcPos = sig1.length == 32 ? 0 : sig1.length - 32;
            System.arraycopy(sig1, srcPos, buff, 0, 32);
        }
        if (sig2.length < 32) {
            dest = 32 - sig2.length;
            System.arraycopy(sig2, 0, buff, dest, sig2.length);
        } else {
            srcPos = sig2.length == 32 ? 0 : sig2.length - 32;
            System.arraycopy(sig2, srcPos, buff, 32, 32);
        }
        return buff;
    }
}

