/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action.ofd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kgofd.ofd.KGOfdHummer;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.ofd.OfdUtils;
import com.kinggrid.pdfviewer.ofd.gb.SesSignature;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERSequence;

public class ReWriteSigDataOfdAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        String stampType = params.getString("stampType");
        String documentId = params.getString("documentId");
        if (pdfFileResource == null) {
            pdfFileResource = PdfFileResourceManager.getPdfFileResource();
        }
        pdfFileResource.init(request, response, action, documentId, "1");
        pdfFileResource.getkeySN(params.getString("keySN"));
        String preFile = pdfFileResource.getPrePdfFile();
        Boolean error = params.getBoolean("error");
        if (error != null && error.booleanValue()) {
            pdfFileResource.fail();
            JSONObject retObj = new JSONObject();
            retObj.put("status", (Object)true);
            response.getWriter().println(retObj.toJSONString());
            return;
        }
        JSONArray arr = params.getJSONArray("data");
        String cert = params.getString("cert");
        if ("0".equals(stampType)) {
            KGBase64 base64 = new KGBase64();
            try {
                for (int i = 0; i < arr.size(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    KGOfdHummer hummer = new KGOfdHummer();
                    byte[] data = OfdUtils.sigData64bit2Ans1(base64.decode(obj.getString("signData")));
                    try {
                        if ("GM".equals(obj.getString("sealType"))) {
                            String signData = base64.encode(data);
                            hummer.doSignature(signData, obj.getString("signDirPath"), preFile);
                            continue;
                        }
                        byte[] tosignData = base64.decode(obj.getString("toSignData"));
                        ASN1Sequence toSignD = DERSequence.getInstance((Object)tosignData);
                        DERSequence ses_signature = SesSignature.getSesSignature(toSignD, base64.decode(cert), data);
                        hummer.doSignature(ses_signature.getEncoded(), obj.getString("signDirPath"), preFile);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } else {
            throw new RuntimeException("OFD\u4e0d\u652f\u6301\u8fd9\u79cd\u7b7e\u540d\u65b9\u5f0f\u3002");
        }
        pdfFileResource.success();
        JSONObject retObj = new JSONObject();
        retObj.put("status", (Object)true);
        response.getWriter().println(retObj.toJSONString());
    }
}

