/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action.ofd;

import com.alibaba.fastjson.JSONObject;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.encrypt.SM2;
import com.kgofd.ofd.KGExecute;
import com.kgofd.ofd.KGOfdHummer;
import com.kgofd.ofd.executes.DeleteSignature;
import com.kgofd.ofd.seal.Seal;
import com.kgofd.ofd.seal.SealUtil;
import com.kgofd.ofd.utils.KGOfdUtils;
import com.kgofd.ofd.utils.ServerSignUtil;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.MsgServerUtils;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.SignatureStampUtils;
import com.kinggrid.pdfviewer.ofd.OfdUtils;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.IOUtils;
import org.kg.bouncycastle.asn1.ASN1OctetString;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.x509.TBSCertificateStructure;

public class DeleteSealOfdAction
implements PdfActionInter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        JSONObject retObj;
        block21: {
            String documentId = params.getString("documentId");
            int page = params.getIntValue("page");
            float x = params.getFloatValue("x");
            float y = params.getFloatValue("y");
            if (pdfFileResource == null) {
                pdfFileResource = PdfFileResourceManager.getPdfFileResource();
            }
            pdfFileResource.init(request, response, action, documentId, "1");
            String keySN = pdfFileResource.getkeySN(params.getString("keySN"));
            retObj = new JSONObject();
            KGOfdHummer hummer = null;
            String tmpFile = Contants.USER_TMP + File.separator + UUID.randomUUID().toString();
            try {
                Map<String, Object> map;
                if (Contants.VERIFY_CAPTCHA) {
                    MsgServerUtils.verifyCaptcha(keySN, params.getString("captcha"));
                }
                if (Contants.VERIFYPWD) {
                    MsgServerUtils.verifyPwd(keySN, params.getString("password"));
                }
                if ((map = OfdUtils.getOfdSignOfXY((hummer = OfdUtils.getOfdHummer(pdfFileResource.getPdfFile(), params.getString("pdfPwd"), tmpFile)).getZipFile(), page, x, y)) == null) {
                    retObj.put("status", (Object)false);
                    retObj.put("message", (Object)"\u5370\u7ae0\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u52a0\u8f7d\u6587\u6863\uff01");
                    response.getWriter().write(retObj.toJSONString());
                    return;
                }
                this.isHavePermission(params, keySN, hummer.getZipFile(), (String)map.get("signedValuePath"));
                DeleteSignature deleteSignature = new DeleteSignature();
                deleteSignature.setDeleteLastOneSeal(true);
                hummer.addExecute((KGExecute)deleteSignature);
                hummer.doExecute();
                File file = new File(tmpFile);
                FileInputStream input = null;
                OutputStream out = null;
                try {
                    input = new FileInputStream(file);
                    out = pdfFileResource.getSavePdfFileSteam();
                    IOUtils.copy((InputStream)input, (OutputStream)out);
                }
                finally {
                    if (input != null) {
                        PdfUtils.close(input);
                    }
                    if (out != null) {
                        PdfUtils.close(out);
                    }
                    if (file.exists()) {
                        file.delete();
                    }
                }
                retObj.put("status", (Object)true);
            }
            catch (Exception e) {
                retObj.put("status", (Object)false);
                File file = new File(tmpFile);
                if (file.exists()) {
                    file.delete();
                }
                if (e instanceof KGServerInterfaceErrorException) {
                    retObj.put("status", (Object)false);
                    retObj.put("message", (Object)e.getMessage());
                    break block21;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                if (retObj.getBooleanValue("status")) {
                    pdfFileResource.success();
                } else {
                    pdfFileResource.fail();
                }
            }
        }
        response.getWriter().write(retObj.toJSONString());
    }

    private void isHavePermission(JSONObject params, String keySN, ZipFile zipfile, String signedValuePath) throws ZipException, IOException, NoSuchAlgorithmException {
        boolean success;
        byte[] signedValue = KGOfdUtils.getFileByte((ZipFile)zipfile, (String)signedValuePath);
        ASN1Sequence sesSignature = ASN1Sequence.getInstance((Object)signedValue);
        ASN1Sequence toSign = (ASN1Sequence)sesSignature.getObjectAt(0);
        ASN1Sequence eseal = (ASN1Sequence)toSign.getObjectAt(1);
        Seal seal = SealUtil.getSeal((byte[])eseal.getEncoded());
        String sealType = seal.getSealType();
        ASN1OctetString cert = null;
        cert = "GM".equals(sealType) ? (ASN1OctetString)toSign.getObjectAt(5) : (ASN1OctetString)sesSignature.getObjectAt(1);
        byte[] certOcetes = cert.getOctets();
        KGBase64 base64 = new KGBase64();
        String certOrigin = params.getString("certOrigin");
        String rand = null;
        String signedBase64 = null;
        if ("0".equals(certOrigin)) {
            rand = this.getRandom();
            if ("GB".equals(sealType)) {
                SignatureStampUtils signatureStampUtils = new SignatureStampUtils(Contants.STAMP_SYSTEM_URL, Contants.SALT, Contants.APPID, seal.getEsid(), "1", "title");
                JSONObject retObj = signatureStampUtils.textDigitalSign(rand.getBytes());
                signedBase64 = retObj.getString("signData");
            } else {
                signedBase64 = ServerSignUtil.signByISignatureServerSM2((String)Contants.URL, (String)base64.encode(rand.getBytes()), (String)keySN);
            }
        } else if ("1".equals(certOrigin)) {
            rand = params.getString("rand");
            signedBase64 = params.getString("signedBase64");
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u5220\u9664 certOrigin\u4e3a\uff1a" + certOrigin + " \u6a21\u5f0f\u7684\u5370\u7ae0");
        }
        SM2 sm2 = new SM2(true);
        byte[] pubkey = this.getPubkey(certOcetes);
        byte[] signedData = base64.decode(signedBase64);
        if (signedData.length != 64) {
            signedData = KGOfdUtils.sigDataAns1To64bit((byte[])signedData);
        }
        if (!(success = sm2.Verify(rand.getBytes(), signedData, this.dealPubKey(pubkey)))) {
            throw new KGServerInterfaceErrorException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5220\u9664\u6743\u9650\uff01");
        }
    }

    private byte[] dealPubKey(byte[] pubKey) {
        byte[] pk = pubKey;
        if (pk.length == 65) {
            System.arraycopy(pubKey, 1, pk, 0, 64);
        }
        return pk;
    }

    private byte[] getPubkey(byte[] signCert) throws ZipException, IOException {
        ASN1Sequence certSeq = ASN1Sequence.getInstance((Object)signCert);
        TBSCertificateStructure tbsCertificate = TBSCertificateStructure.getInstance((Object)certSeq.getObjectAt(0));
        return tbsCertificate.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
    }

    private String getRandom() {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 32; ++i) {
            int number = random.nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }
}

