/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.security.PdfPKCS7;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.exception.KGErrorSm2VerifyException;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.executes.electronicseal.KGDefaultMessageDigest;
import com.kinggrid.pdf.executes.electronicseal.KGMessageDigest;
import com.kinggrid.pdf.executes.signature.VerifySignatureSM2;
import com.kinggrid.pdf.utils.KGPdfUtils;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.DocumentException;

public class VerifySealOnLoadAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        String documentId = params.getString("documentId");
        int page = params.getIntValue("page");
        String indRefNumber = params.getString("indRefNumber");
        if (pdfFileResource == null) {
            pdfFileResource = PdfFileResourceManager.getPdfFileResource();
        }
        pdfFileResource.init(request, response, action, documentId);
        KGPdfHummer hummer = null;
        InputStream in = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        JSONObject sealObj = null;
        try {
            String pdfFile = pdfFileResource.getPdfFile();
            in = pdfFileResource.getPdfFileStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            hummer = PdfUtils.getPdfHummerOfdqzqRead(pdfFile, in, byteArrayOutputStream, params.getString("pdfPwd"));
            PdfReader pdfReader = hummer.getPdfReader();
            PdfDictionary pageDic = pdfReader.getPageN(page);
            PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
            if (annots != null) {
                for (int i = 0; i < annots.size(); ++i) {
                    String id;
                    PdfDictionary annot = annots.getAsDict(i);
                    PdfName subtype = annot.getAsName(PdfName.SUBTYPE);
                    PdfName ft = annot.getAsName(PdfName.FT);
                    PRIndirectReference indRef = annot.getIndRef();
                    if (indRef == null || !indRefNumber.equals(id = indRef.getNumber() + "R")) continue;
                    if (KGElectronicSealName.SEAL.equals((Object)subtype)) {
                        PdfIndirectReference parentRef = annot.getAsIndirectObject(PdfName.PARENT);
                        if (parentRef != null) {
                            annot = (PdfDictionary)PdfReader.getPdfObject((PdfObject)parentRef);
                        }
                        sealObj = this.parseSeal(annot, pdfReader, pdfFileResource.getDocumentName());
                        continue;
                    }
                    if (!PdfName.WIDGET.equals((Object)subtype) || !PdfName.SIG.equals((Object)ft)) continue;
                    sealObj = this.parseSig(annot, pdfReader, pdfFileResource.getDocumentName());
                }
            }
            if (sealObj == null) {
                sealObj = new JSONObject();
                sealObj.put("status", (Object)false);
            } else {
                sealObj.put("status", (Object)true);
            }
            response.getWriter().write(sealObj.toJSONString());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                PdfUtils.close(in);
                PdfUtils.close(byteArrayOutputStream);
                if (hummer != null) {
                    hummer.close();
                }
                throw throwable;
            }
        }
        PdfUtils.close(in);
        PdfUtils.close(byteArrayOutputStream);
        if (hummer != null) {
            hummer.close();
        }
    }

    private JSONObject parseSeal(PdfDictionary annot, PdfReader pdfReader, String documentName) throws IOException, GeneralSecurityException {
        JSONObject sealObj = new JSONObject();
        String id = annot.getIndRef().getNumber() + "R";
        sealObj.put("id", (Object)id);
        Map sealMap = KGPdfUtils.parseSeal((PdfDictionary)annot);
        String hash = (String)sealMap.get("strMd5");
        KGDefaultMessageDigest messageDigest = null;
        if (Contants.MESSAGE_DIGEST_CLASS != null) {
            try {
                messageDigest = (KGMessageDigest)Contants.MESSAGE_DIGEST_CLASS.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            messageDigest = new KGDefaultMessageDigest();
        }
        JSONObject jObject = PdfUtils.verifyEletronicSeal(pdfReader, annot, (KGMessageDigest)messageDigest, hash);
        sealObj.put("effectiveness", (Object)jObject.getBoolean("effectiveness"));
        return sealObj;
    }

    private JSONObject parseSig(PdfDictionary annot, PdfReader pdfReader, String documentName) throws IOException, DocumentException, GeneralSecurityException {
        JSONObject sealObj = new JSONObject();
        String id = annot.getIndRef().getNumber() + "R";
        sealObj.put("id", (Object)id);
        PdfDictionary v = annot.getAsDict(PdfName.V);
        String filterValue = v.getAsName(PdfName.FILTER).toString();
        boolean res = true;
        if (filterValue.toUpperCase().equals("/GM.PkiLite".toUpperCase())) {
            VerifySignatureSM2 verifySignatureSM2 = new VerifySignatureSM2(v, null, pdfReader);
            try {
                verifySignatureSM2.verify();
            }
            catch (KGErrorSm2VerifyException e) {
                res = false;
            }
        } else {
            String name = annot.getAsString(PdfName.T).toUnicodeString();
            PdfPKCS7 pk = pdfReader.getAcroFields().verifySignature(name);
            res = pk.verify();
        }
        sealObj.put("effectiveness", (Object)res);
        return sealObj;
    }
}

