/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.security.PdfPKCS7;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.exception.KGErrorSm2VerifyException;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.executes.electronicseal.KGDefaultMessageDigest;
import com.kinggrid.pdf.executes.electronicseal.KGMessageDigest;
import com.kinggrid.pdf.executes.entity.SignSealInfo;
import com.kinggrid.pdf.executes.signature.VerifySignatureSM2;
import com.kinggrid.pdf.utils.KGPdfUtils;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.License;
import com.kinggrid.pdfviewer.PVHttpUtil;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import com.kinggrid.pdfviewer.pdf.electronicseal.ElectronicSealFactory;
import com.kinggrid.pdfviewer.pdf.electronicseal.VerifyDigitalSignature;
import com.kinggrid.pdfviewer.pdf.electronicseal.impl.VerifyDigitalSignatureImpl;
import com.kinggrid.pdfviewer.pdf.electronicseal.impl.VerifyDigitalSignatureSoftVImpl;
import com.kinggrid.pdfviewer.utils.CertUtils;
import com.kinggrid.pdfviewer.utils.StampUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.DocumentException;
import org.kg.bouncycastle.cert.X509CertificateHolder;
import org.kg.bouncycastle.cms.CMSSignedData;
import org.kg.bouncycastle.cms.SignerInformation;
import org.kg.bouncycastle.tsp.TimeStampToken;
import org.kg.bouncycastle.util.Selector;

public class VerifySealAction
implements PdfActionInter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        block14: {
            documentId = params.getString("documentId");
            page = params.getIntValue("page");
            x = params.getFloatValue("x");
            y = params.getFloatValue("y");
            if (pdfFileResource == null) {
                pdfFileResource = PdfFileResourceManager.getPdfFileResource();
            }
            pdfFileResource.init(request, response, action, documentId);
            hummer = null;
            in = null;
            byteArrayOutputStream = null;
            retObj = new JSONObject();
            try {
                pdfFile = pdfFileResource.getPdfFile();
                in = pdfFileResource.getPdfFileStream();
                byteArrayOutputStream = new ByteArrayOutputStream();
                hummer = PdfUtils.getPdfHummerOfdqzqRead(pdfFile, in, byteArrayOutputStream, params.getString("pdfPwd"));
                pdfReader = hummer.getPdfReader();
                map = PdfUtils.getPdfDictionaryOfXY(pdfReader, page, x, y);
                if (map != null) {
                    annot = (PdfDictionary)map.get("annot");
                    subtype = annot.getAsName(PdfName.SUBTYPE);
                    ft = annot.getAsName(PdfName.FT);
                    sealObj = null;
                    if (KGElectronicSealName.SEAL.equals((Object)subtype)) {
                        parentRef = annot.getAsIndirectObject(PdfName.PARENT);
                        if (parentRef != null) {
                            annot = (PdfDictionary)PdfReader.getPdfObject((PdfObject)parentRef);
                        }
                        sealObj = this.parseSeal(annot, pdfReader, pdfFileResource.getDocumentName(), params);
                    } else if (PdfName.WIDGET.equals((Object)subtype) && PdfName.SIG.equals((Object)ft)) {
                        sealObj = this.parseSig(annot, pdfReader, pdfFileResource.getDocumentName());
                    }
                    retObj.put("status", (Object)true);
                    retObj.put("seal", (Object)sealObj);
                    break block14;
                }
                retObj.put("status", (Object)false);
                retObj.put("message", (Object)"\u5370\u7ae0\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u52a0\u8f7d\u6587\u6863\uff01");
            }
            catch (Exception e) {
                try {
                    if (!(e instanceof KGServerInterfaceErrorException)) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    retObj.put("status", (Object)false);
                    retObj.put("message", (Object)e.getMessage());
                }
                catch (Throwable var22_23) {
                    PdfUtils.close(in);
                    PdfUtils.close(byteArrayOutputStream);
                    if (hummer != null) {
                        hummer.close();
                    }
                    throw var22_23;
                }
                PdfUtils.close(in);
                PdfUtils.close(byteArrayOutputStream);
                if (hummer != null) {
                    hummer.close();
                } else {
                    ** GOTO lbl66
                }
            }
        }
        PdfUtils.close(in);
        PdfUtils.close(byteArrayOutputStream);
        if (hummer != null) {
            hummer.close();
        }
        retObj.put("companyName", (Object)License.getCompanyName());
        response.getWriter().write(retObj.toJSONString());
    }

    private JSONObject parseSeal(PdfDictionary annot, PdfReader pdfReader, String documentName, JSONObject params) throws IOException, GeneralSecurityException {
        String certOrigin = params.getString("certOrigin");
        JSONObject sealObj = new JSONObject();
        sealObj.put("stampType", (Object)"0");
        Map sealMap = KGPdfUtils.parseSeal((PdfDictionary)annot);
        sealObj.put("appName", sealMap.get("AppName"));
        sealObj.put("keySN", sealMap.get("KeySerial"));
        String userName = (String)sealMap.get("UserName");
        if (userName == null) {
            userName = "";
        }
        sealObj.put("userName", (Object)userName);
        sealObj.put("unitName", sealMap.get("CompName"));
        sealObj.put("signSN", sealMap.get("SealSerial"));
        sealObj.put("signName", sealMap.get("KeyName"));
        sealObj.put("createTime", sealMap.get("CreateTime"));
        sealObj.put("documentName", (Object)documentName);
        String hash = (String)sealMap.get("strMd5");
        KGDefaultMessageDigest messageDigest = null;
        if (Contants.MESSAGE_DIGEST_CLASS != null) {
            try {
                messageDigest = (KGMessageDigest)Contants.MESSAGE_DIGEST_CLASS.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            messageDigest = new KGDefaultMessageDigest();
        }
        JSONObject jObject = PdfUtils.verifyEletronicSeal(pdfReader, annot, (KGMessageDigest)messageDigest, hash);
        sealObj.put("effectiveness", (Object)jObject.getBoolean("effectiveness"));
        PdfIndirectReference certRef = annot.getAsIndirectObject(new PdfName("certContext"));
        PdfIndirectReference signDataRef = annot.getAsIndirectObject(new PdfName("certSignMsg"));
        if (certRef != null && signDataRef != null && !"-1".equals(certOrigin)) {
            PRStream certStream = (PRStream)pdfReader.getPdfObject(certRef.getNumber());
            byte[] certData = PdfReader.getStreamBytesRaw((PRStream)certStream);
            if (PdfName.FLATEDECODE.equals((Object)certStream.get(PdfName.FILTER))) {
                certData = PdfReader.FlateDecode((byte[])certData);
            }
            String cert = new String(certData, "UTF-16LE");
            cert = cert.replaceAll("\r\n", "");
            if ((cert = cert.replaceAll("\n", "")).indexOf("-----BEGIN CERTIFICATE-----") != -1) {
                int bidx = "-----BEGIN CERTIFICATE-----".length();
                int eidx = cert.indexOf("-----END CERTIFICATE-----");
                cert = cert.substring(bidx, eidx);
            }
            KGBase64 base64 = new KGBase64();
            byte[] certb = base64.decode(cert);
            JSONObject object = CertUtils.parseCert(certb);
            PRStream signDataStream = (PRStream)pdfReader.getPdfObject(signDataRef.getNumber());
            byte[] signData = PdfReader.getStreamBytesRaw((PRStream)signDataStream);
            if (PdfName.FLATEDECODE.equals((Object)signDataStream.get(PdfName.FILTER))) {
                signData = PdfReader.FlateDecode((byte[])signData);
            }
            String sigData = new String(signData, "UTF-16LE");
            String new_hash = jObject.getString("new_hash");
            if (Contants.SOFTVERIFY) {
                boolean sigEffectiveness = false;
                VerifyDigitalSignatureSoftVImpl verifyDigitalSignatureSoftVImpl = new VerifyDigitalSignatureSoftVImpl();
                sigEffectiveness = verifyDigitalSignatureSoftVImpl.verify(certb, sigData.getBytes(), new_hash, annot, sealMap, object);
                Date signDate = verifyDigitalSignatureSoftVImpl.getSignDate();
                object.put("sigEffectiveness", (Object)sigEffectiveness);
                if (signDate != null) {
                    sealObj.put("stampID", (Object)StampUtils.getStampID(signDate, sigData));
                }
            } else if ("0".equals(certOrigin)) {
                boolean sigEffectiveness = false;
                byte[] _sigdata = base64.decode(sigData);
                VerifyDigitalSignatureImpl verifyDigitalSignatureDefault = new VerifyDigitalSignatureImpl();
                sigEffectiveness = verifyDigitalSignatureDefault.verify(certb, _sigdata, new_hash, annot, sealMap, object);
                object.put("sigEffectiveness", (Object)sigEffectiveness);
            } else if ("1".equals(certOrigin)) {
                object.put("newHash", (Object)new_hash);
                object.put("sigData", (Object)sigData);
                if (annot.getAsString(new PdfName("bSignByCalibrary")) != null && !"".equals(annot.getAsString(new PdfName("bSignByCalibrary")).toString())) {
                    object.put("bSignByCalibrary", (Object)annot.getAsString(new PdfName("bSignByCalibrary")));
                }
            } else if ("2".equals(certOrigin)) {
                boolean sigEffectiveness = false;
                byte[] _sigdata = base64.decode(sigData);
                VerifyDigitalSignature verifyDigitalSignature = ElectronicSealFactory.getVerifyDigitalSignature();
                sigEffectiveness = verifyDigitalSignature.verify(certb, _sigdata, new_hash, annot, sealMap, object);
                object.put("sigEffectiveness", (Object)sigEffectiveness);
            }
            sealObj.put("cert", (Object)object);
        }
        return sealObj;
    }

    private JSONObject parseSig(PdfDictionary annot, PdfReader pdfReader, String documentName) throws IOException, DocumentException, GeneralSecurityException {
        JSONObject sealObj = null;
        PRStream kgProperty = (PRStream)annot.getAsStream(new PdfName("KGPROPERTY"));
        if (kgProperty != null) {
            sealObj = PdfUtils.parseKgProperty(kgProperty);
            sealObj.put("documentName", (Object)documentName);
        } else {
            PRStream isp = (PRStream)annot.getAsStream(new PdfName("ISP"));
            if (isp != null) {
                sealObj = PdfUtils.parseISP(isp);
                sealObj.put("documentName", (Object)documentName);
            }
        }
        if (sealObj == null) {
            sealObj = new JSONObject();
        }
        sealObj.put("stampType", (Object)"1");
        String name = annot.getAsString(PdfName.T).toUnicodeString();
        PdfDictionary v = annot.getAsDict(PdfName.V);
        String filterValue = v.getAsName(PdfName.FILTER).toString();
        boolean res = true;
        JSONObject certobj = null;
        String signDateTime = null;
        if (filterValue.toUpperCase().equals("/GM.PkiLite".toUpperCase())) {
            KGBase64 base64;
            PVHttpUtil pvHttpUtil;
            Map<String, Object> map;
            VerifySignatureSM2 verifySignatureSM2 = new VerifySignatureSM2(v, null, pdfReader);
            try {
                verifySignatureSM2.verify();
            }
            catch (KGErrorSm2VerifyException e) {
                res = false;
            }
            SignSealInfo signSealInfo = verifySignatureSM2.getSignSealInfo();
            String timeInfo = signSealInfo.getSignDate();
            Date date = KGDateUtils.parseZ2Date((String)timeInfo);
            signDateTime = KGDateUtils.dateTime((Date)date);
            String esid = signSealInfo.getEsId();
            certobj = CertUtils.parseCert(signSealInfo.getCert());
            String subjectDN = certobj.getString("subjectDN");
            if (subjectDN.length() == 14 && esid.length() == 14 && subjectDN.equals(esid) && Contants.CHECK_SEAL_STATS && !"0".equals((map = (pvHttpUtil = new PVHttpUtil()).checkSealStats(Contants.URL, (base64 = new KGBase64()).encode(signSealInfo.getSesSignature()))).get("code"))) {
                throw new KGServerInterfaceErrorException("\u9a8c\u8bc1\u5370\u7ae0\u72b6\u6001\u6709\u6548\u6027\u5931\u8d25\uff1a" + map.get("message"));
            }
            sealObj.put("stampID", (Object)StampUtils.getStampID(date, signSealInfo.getSesSignature()));
        } else {
            PdfPKCS7 pk = pdfReader.getAcroFields().verifySignature(name);
            res = pk.verify();
            certobj = CertUtils.parseCert(pk.getSigningCertificate().getEncoded());
            signDateTime = KGDateUtils.dateTime((Date)pk.getSignDate().getTime());
            TimeStampToken timeStampToken = pk.getTimeStampToken();
            if (timeStampToken != null) {
                CMSSignedData cmsSignedData = timeStampToken.toCMSSignedData();
                Collection signaturesCollection = cmsSignedData.getSignerInfos().getSigners();
                SignerInformation signerInformation = (SignerInformation)signaturesCollection.iterator().next();
                Collection x509Certificates = timeStampToken.getCertificates().getMatches((Selector)signerInformation.getSID());
                X509CertificateHolder certificate = (X509CertificateHolder)x509Certificates.iterator().next();
                JSONObject tsaCert = CertUtils.parseCert(certificate.getEncoded());
                boolean tsaEffectiveness = pk.verifyTimestampImprint();
                Date tsaTime = pk.getTimeStampDate().getTime();
                boolean certEffectiveness = this.verifyTsaTime(tsaTime, tsaCert.getString("notBefore"), tsaCert.getString("notAfter"));
                JSONObject tsaObject = new JSONObject();
                tsaObject.put("tsaEffectiveness", (Object)(tsaEffectiveness && certEffectiveness ? 1 : 0));
                tsaObject.put("tsaTime", (Object)KGDateUtils.dateTime((Date)tsaTime));
                tsaObject.put("tsaCert", (Object)tsaCert);
                sealObj.put("tsaInfo", (Object)tsaObject);
            }
        }
        certobj.put("effectiveness", (Object)res);
        if (res) {
            if (pdfReader.getAcroFields().signatureCoversWholeDocument(name)) {
                certobj.put("appendContent", (Object)false);
            } else {
                certobj.put("appendContent", (Object)true);
            }
        }
        sealObj.put("cert", (Object)certobj);
        sealObj.put("signDateTime", (Object)signDateTime);
        return sealObj;
    }

    private boolean verifyTsaTime(Date tsaTime, String notBefore, String notAfter) {
        Date notBeforeDate = KGDateUtils.parse2Date((String)notBefore, (String)"yyyy-MM-dd HH:mm:ss");
        Date notAfterDate = KGDateUtils.parse2Date((String)notAfter, (String)"yyyy-MM-dd HH:mm:ss");
        return KGDateUtils.compareDate((Date)tsaTime, (Date)notBeforeDate) >= 0 && KGDateUtils.compareDate((Date)tsaTime, (Date)notAfterDate) <= 0;
    }
}

