/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.executes.PdfElectronicSealDetails;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VerifyAllSealAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        String documentId = params.getString("documentId");
        if (pdfFileResource == null) {
            pdfFileResource = PdfFileResourceManager.getPdfFileResource();
        }
        pdfFileResource.init(request, response, action, documentId);
        KGPdfHummer hummer = null;
        InputStream in = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        JSONObject retObj = new JSONObject();
        try {
            String pdfFile = pdfFileResource.getPdfFile();
            in = pdfFileResource.getPdfFileStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            hummer = PdfUtils.getPdfHummerOfdqzqRead(pdfFile, in, byteArrayOutputStream, params.getString("pdfPwd"));
            PdfElectronicSealDetails pdfElectronicSealDetails = new PdfElectronicSealDetails();
            hummer.addExecute((KGExecute)pdfElectronicSealDetails);
            hummer.doExecute();
            JSONArray jArray = new JSONArray();
            List signinfos = pdfElectronicSealDetails.getSeals();
            for (PdfElectronicSealDetails.Signinfo signinfo : signinfos) {
                JSONObject sealObject = new JSONObject();
                sealObject.put("newHash", (Object)signinfo.getNewHash());
                sealObject.put("effectiveness", (Object)(!signinfo.isTamper() ? 1 : 0));
                if (signinfo.getSignData() != null) {
                    sealObject.put("sigData", (Object)new String(signinfo.getSignData(), "UTF-8"));
                }
                jArray.add((Object)sealObject);
            }
            retObj.put("status", (Object)true);
            retObj.put("signInfoArray", (Object)jArray);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                PdfUtils.close(in);
                PdfUtils.close(byteArrayOutputStream);
                if (hummer != null) {
                    hummer.close();
                }
                throw throwable;
            }
        }
        PdfUtils.close(in);
        PdfUtils.close(byteArrayOutputStream);
        if (hummer != null) {
            hummer.close();
        }
        response.getWriter().write(retObj.toJSONString());
    }
}

