/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.parser.PdfReaderContentParser;
import com.KGitextpdf.text.pdf.parser.RenderListener;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.exception.KGErrorSm2VerifyException;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.kgcore.KGHttpUtils;
import com.kinggrid.kgcore.LogEntity;
import com.kinggrid.pdf.DigitalSignatureByKey;
import com.kinggrid.pdf.DigitalSignatureByKeySM2;
import com.kinggrid.pdf.ElectronicSignatureByKey;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.SignatureInter;
import com.kinggrid.pdf.core.Coordinate;
import com.kinggrid.pdf.core.KGTextMarginFinder;
import com.kinggrid.pdf.enmu.XYType;
import com.kinggrid.pdf.executes.AbstractSign;
import com.kinggrid.pdf.executes.PdfElectronicSeal4KG;
import com.kinggrid.pdf.executes.PdfSignature4KG;
import com.kinggrid.pdf.executes.PdfSignature4SM2;
import com.kinggrid.pdf.executes.electronicseal.KGMessageDigest;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicExecute;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicExecuteFactory;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicSig;
import com.kinggrid.pdf.executes.entity.QfzSealData;
import com.kinggrid.pdf.signinter.DigitalSignature;
import com.kinggrid.pdf.signinter.DigitalSignatureByGB;
import com.kinggrid.pdf.signinter.DigitalSignatureByServer;
import com.kinggrid.pdf.signinter.DigitalSignatureByServerSM2;
import com.kinggrid.pdf.signinter.DigitalSignatureSM2ByServer;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.MsgServerUtils;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.exception.KGNotFindTextException;
import com.kinggrid.pdfviewer.pdf.DigitalSignatureOnlineClient;
import com.kinggrid.pdfviewer.pdf.KGPdfElectronicSigOnline;
import com.kinggrid.pdfviewer.pdf.KGPdfElectronicThirdSig;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import com.kinggrid.pdfviewer.pdf.electronicseal.ElectronicSealFactory;
import com.kinggrid.pdfviewer.pdf.electronicseal.PdfElectronicSig;
import com.kinggrid.pdfviewer.pdf.electronicseal.ThridPartySig;
import com.kinggrid.pdfviewer.utils.CertUtils;
import com.kinggrid.pdfviewer.utils.ConnectSignatureQrcode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kg.bouncycastle.util.encoders.Hex;

public class StampSealAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        JSONArray sigobj;
        JSONObject stampobj;
        JSONObject retObj;
        String qrCodeUid;
        block26: {
            String documentId = params.getString("documentId");
            String stampType = params.getString("stampType");
            JSONArray seals = params.getJSONArray("seals");
            if (seals == null || seals.size() == 0) {
                return;
            }
            String keySN = seals.getJSONObject(0).getString("keySN");
            qrCodeUid = params.getString("qrCodeUid");
            retObj = new JSONObject();
            if (pdfFileResource == null) {
                pdfFileResource = PdfFileResourceManager.getPdfFileResource();
            }
            pdfFileResource.init(request, response, action, documentId);
            pdfFileResource.setUserId(keySN);
            stampobj = null;
            try {
                if (Contants.VERIFY_CAPTCHA) {
                    String captcha = params.getString("captcha");
                    if (captcha == null || "".equals(captcha)) {
                        throw new RuntimeException("\u624b\u673a\u9a8c\u8bc1\u7801\u4e3a\u7a7a\uff01");
                    }
                    MsgServerUtils.verifyCaptcha(keySN, captcha);
                }
                if ("0".equals(stampType)) {
                    stampobj = this.dzqz(request, response, seals, pdfFileResource, params);
                    break block26;
                }
                if ("1".equals(stampType)) {
                    stampobj = this.sig(request, response, seals, pdfFileResource, params);
                    break block26;
                }
                if ("2".equals(stampType)) {
                    stampobj = this.sm2Sig(request, response, seals, pdfFileResource, params);
                    break block26;
                }
                retObj.put("status", (Object)false);
                retObj.put("message", (Object)("stampType\u53c2\u6570\u5f02\u5e38\uff1a" + stampType));
                response.getWriter().write(retObj.toJSONString());
                return;
            }
            catch (Throwable e) {
                if (qrCodeUid != null && qrCodeUid.length() > 0) {
                    try {
                        ConnectSignatureQrcode.deleteQrUid(qrCodeUid);
                    }
                    catch (NoSuchAlgorithmException e1) {
                        throw new RuntimeException(e1.getMessage(), e1);
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1.getMessage(), e1);
                    }
                }
                pdfFileResource.fail();
                if (e instanceof KGServerInterfaceErrorException) {
                    retObj.put("status", (Object)false);
                    retObj.put("message", (Object)e.getMessage());
                    response.getWriter().write(retObj.toJSONString());
                    return;
                }
                if (e instanceof DocumentException) {
                    if ("Append mode requires a document without errors even if recovery was possible.".equals(e.getMessage())) {
                        retObj.put("status", (Object)false);
                        retObj.put("message", (Object)"PDF\u6587\u6863\u683c\u5f0f\u6709\u95ee\u9898\uff0c\u8bf7\u5904\u7406\u540e\u518d\u505a\u7b7e\u7ae0\uff01");
                        response.getWriter().write(retObj.toJSONString());
                        return;
                    }
                    throw new RuntimeException(e.getMessage(), e);
                }
                if (e instanceof KGNotFindTextException) {
                    retObj.put("status", (Object)false);
                    retObj.put("message", (Object)e.getMessage());
                    response.getWriter().write(retObj.toJSONString());
                    return;
                }
                if (e.getCause() instanceof UnknownHostException) {
                    retObj.put("status", (Object)false);
                    retObj.put("message", (Object)("\u8fde\u63a5\u65f6\u95f4\u6233\u670d\u52a1\u5668\u5931\u8d25\uff1a" + Contants.TSA_URL));
                    response.getWriter().write(retObj.toJSONString());
                    return;
                }
                if (e.getCause() instanceof KGErrorSm2VerifyException) {
                    retObj.put("status", (Object)false);
                    retObj.put("message", (Object)e.getMessage());
                    response.getWriter().write(retObj.toJSONString());
                    return;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        retObj.put("status", (Object)true);
        JSONArray textPositions = stampobj.getJSONArray("textPositions");
        if (textPositions != null) {
            retObj.put("textPositions", (Object)textPositions);
        }
        if ((sigobj = stampobj.getJSONArray("sigobj")) != null && sigobj.size() > 0) {
            retObj.put("sigObj", (Object)sigobj);
            pdfFileResource.preSuccess();
        } else {
            if (qrCodeUid != null && qrCodeUid.length() > 0) {
                try {
                    ConnectSignatureQrcode.deleteQrUid(qrCodeUid);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            pdfFileResource.success();
        }
        response.getWriter().write(retObj.toJSONString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject dzqz(HttpServletRequest request, HttpServletResponse response, JSONArray seals, PdfFileResource pdfFileResource, JSONObject params) throws IOException, DocumentException, KGNotFindTextException {
        JSONObject retobj = new JSONObject();
        KGPdfHummer hummer = null;
        InputStream in = null;
        OutputStream out = null;
        KGBase64 base64 = new KGBase64();
        String keySN = seals.getJSONObject(0).getString("keySN");
        try {
            String pdfFile = pdfFileResource.getPdfFile();
            in = pdfFileResource.getPdfFileStream();
            out = pdfFileResource.getSavePdfFileSteam();
            hummer = PdfUtils.getPdfHummer(pdfFile, in, out, params.getString("pdfPwd"));
            ArrayList<KGPdfElectronicExecute> pdfElectronicExecutes = new ArrayList<KGPdfElectronicExecute>();
            for (int i = 0; i < seals.size(); ++i) {
                KGPdfElectronicExecute pdfElectronicExecute;
                JSONObject obj = seals.getJSONObject(i);
                PdfElectronicSeal4KG pdfElectronicSeal = new PdfElectronicSeal4KG(null, 0, null);
                if (!obj.getBooleanValue("isStampOfQfz")) {
                    String imgFormat = obj.getString("imgExt");
                    float width = obj.getFloatValue("width");
                    float height = obj.getFloatValue("height");
                    String imgdata = obj.getString("imgdata");
                    int index = imgdata.indexOf(44);
                    byte[] imgb = base64.decode(imgdata.substring(index + 1));
                    pdfElectronicSeal.setImage(imgb, imgFormat, (int)width, (int)height);
                }
                pdfElectronicSeal.setSealData(obj.getString("sealData"));
                pdfElectronicSeal.setSealMsg(obj.getString("keySN"), obj.getString("unitName"), obj.getString("userName"), obj.getString("signSN"), obj.getString("signName"));
                pdfElectronicSeal.setBSignByCalibraryValue(obj.getString("bSignByCalibrary"));
                if (Contants.MESSAGE_DIGEST_CLASS != null) {
                    KGMessageDigest messageDigest = null;
                    try {
                        messageDigest = (KGMessageDigest)Contants.MESSAGE_DIGEST_CLASS.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    pdfElectronicSeal.setMessageDigest(messageDigest);
                }
                if ((pdfElectronicExecute = this.getPdfElectronicSig(params, keySN, obj, request, response, pdfFileResource)) != null) {
                    pdfElectronicExecutes.add(pdfElectronicExecute);
                    pdfElectronicSeal.addExtraExecute(pdfElectronicExecute);
                }
                if ("GB".equalsIgnoreCase(obj.getString("sealtag"))) {
                    pdfElectronicSeal.addExtraExecute(new KGPdfElectronicExecute(){

                        public void execute(PdfStamper arg0, PdfAnnotation annot, int arg2, String arg3) {
                            annot.put(new PdfName("ESType"), (PdfObject)new PdfString("GB"));
                        }
                    });
                }
                this.setPosition(obj, (AbstractSign)pdfElectronicSeal);
                if (obj.getBooleanValue("isStampOfText")) {
                    JSONArray positions = this.findTextPosition(hummer.getPdfReader(), pdfElectronicSeal.getPagens(), obj.getString("text"));
                    if (positions.size() > 0) {
                        int startPage = positions.getJSONObject(0).getInteger("page");
                        pdfElectronicSeal.setStartPage(startPage);
                        retobj.put("textPositions", (Object)positions);
                    } else {
                        throw new KGNotFindTextException("\u5173\u952e\u5b57\u4e0d\u5b58\u5728\uff1a" + obj.getString("text"));
                    }
                }
                if (Contants.SAVELOG) {
                    this.saveLog(obj, params.getString("documentId"), pdfFileResource.getDocumentName(), this.getIpAddress(request));
                }
                hummer.addExecute((KGExecute)pdfElectronicSeal);
            }
            hummer.doExecute();
            JSONArray sigobjArray = new JSONArray();
            for (int i = 0; i < pdfElectronicExecutes.size(); ++i) {
                KGPdfElectronicExecute pdfElectronicExecute = (KGPdfElectronicExecute)pdfElectronicExecutes.get(i);
                JSONObject obj = seals.getJSONObject(i);
                if (!(pdfElectronicExecute instanceof ElectronicSignatureByKey)) continue;
                ElectronicSignatureByKey electronicSignatureByKey = (ElectronicSignatureByKey)pdfElectronicExecute;
                String needSigMessage = electronicSignatureByKey.getHash();
                String sigKeepData = electronicSignatureByKey.getKeepData();
                JSONObject sigobj = new JSONObject();
                sigobj.put("needSigMessage", (Object)needSigMessage);
                sigobj.put("sigKeepData", (Object)sigKeepData);
                sigobj.put("sealtag", (Object)obj.getString("sealtag"));
                sigobj.put("signSN", (Object)obj.getString("signSN"));
                if (obj.getString("bSignByCalibrary") != null && !"".equals(obj.getString("bSignByCalibrary"))) {
                    sigobj.put("bSignByCalibrary", (Object)obj.getString("bSignByCalibrary"));
                }
                sigobjArray.add((Object)sigobj);
            }
            retobj.put("sigobj", (Object)sigobjArray);
        }
        catch (Throwable throwable) {
            PdfUtils.close(in);
            PdfUtils.close(out);
            if (hummer != null) {
                hummer.close();
            }
            throw throwable;
        }
        PdfUtils.close(in);
        PdfUtils.close(out);
        if (hummer != null) {
            hummer.close();
        }
        return retobj;
    }

    private void setPosition(JSONObject obj, AbstractSign abstractSign) {
        if (obj.getBooleanValue("isStampOfQfz")) {
            JSONArray qfzSealArray = obj.getJSONArray("qfzSeal");
            abstractSign.setQfzData(true);
            abstractSign.setStartPage(qfzSealArray.getJSONObject(0).getIntValue("page"));
            HashMap qfzSealMap = new HashMap();
            for (int i = 0; i < qfzSealArray.size(); ++i) {
                JSONObject qfzSealObject = qfzSealArray.getJSONObject(i);
                int page = qfzSealObject.getIntValue("page");
                float imgHeight = qfzSealObject.getFloatValue("height");
                float top = qfzSealObject.getFloatValue("top");
                JSONArray sealdataArray = qfzSealObject.getJSONArray("sealdata");
                ArrayList<QfzSealData> list = new ArrayList<QfzSealData>();
                for (int j = 0; j < sealdataArray.size(); ++j) {
                    JSONObject sealdataObject = sealdataArray.getJSONObject(j);
                    float left = sealdataObject.getFloatValue("left");
                    float imgWidth = sealdataObject.getFloatValue("width");
                    Rectangle rectangle = new Rectangle(left, top - imgHeight, left + imgWidth, top);
                    String imgdata = sealdataObject.getString("imgdata");
                    String imgBase64 = imgdata.substring(imgdata.indexOf(44) + 1);
                    KGBase64 base64 = new KGBase64();
                    Image image = null;
                    try {
                        image = Image.getInstance((byte[])base64.decode(imgBase64));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    QfzSealData qfzSealData = new QfzSealData();
                    qfzSealData.setImage(image);
                    qfzSealData.setRect(rectangle);
                    list.add(qfzSealData);
                }
                qfzSealMap.put(page, list);
            }
            abstractSign.qfz(qfzSealMap);
        } else {
            String numbPages = obj.getString("page");
            abstractSign.setPagen(numbPages);
            float width = obj.getFloatValue("width");
            float height = obj.getFloatValue("height");
            if (obj.getBooleanValue("isContinuityStampCheck")) {
                String[] arrayPages = numbPages.split("-");
                int page = Integer.valueOf(arrayPages[0]);
                abstractSign.setQfzData(true);
                abstractSign.setStartPage(page);
                float xsacle = obj.getFloatValue("xsacle");
                float ysacle = obj.getFloatValue("ysacle");
                abstractSign.setLeftTopPercent(XYType.TOP_LEFT, xsacle, ysacle);
            } else if (obj.getBooleanValue("isStampOfText")) {
                String[] arrayPages = numbPages.split("-");
                int page = Integer.valueOf(arrayPages[0]);
                abstractSign.setQfzData(true);
                abstractSign.setStartPage(page);
                abstractSign.setText(obj.getString("text"));
            } else {
                if (obj.getBooleanValue("isStampOfXY")) {
                    String[] arrayPages = numbPages.split("-");
                    int page = Integer.valueOf(arrayPages[0]);
                    abstractSign.setQfzData(true);
                    abstractSign.setStartPage(page);
                }
                float left = obj.getFloatValue("left");
                float top = obj.getFloatValue("top");
                float x = left + width / 2.0f;
                float y = top + height / 2.0f;
                abstractSign.setXY(XYType.TOP_LEFT, x, y);
            }
        }
    }

    private JSONArray findTextPosition(PdfReader pdfReader, int[] pages, String text) throws IOException {
        JSONArray positions = new JSONArray();
        PdfReaderContentParser pdfReaderContentParser = new PdfReaderContentParser(pdfReader);
        for (int i = 0; i < pages.length; ++i) {
            int pageNumb = pages[i];
            if (pageNumb < 1) continue;
            if (pageNumb > pdfReader.getNumberOfPages()) break;
            int rotation = pdfReader.getPageRotation(pageNumb);
            Rectangle pageRect = pdfReader.getPageSize(pageNumb);
            float width = pageRect.getWidth();
            float height = pageRect.getHeight();
            Rectangle pageRectWithRotation = pdfReader.getPageSizeWithRotation(pageNumb);
            KGTextMarginFinder textMarginFinder = new KGTextMarginFinder();
            textMarginFinder.setTexts(text);
            pdfReaderContentParser.processContent(pageNumb, (RenderListener)textMarginFinder);
            List coordinates = textMarginFinder.getPositions();
            for (Coordinate coordinate : coordinates) {
                float x = coordinate.getX();
                float y = coordinate.getY();
                float tmp = x;
                if (rotation == 90) {
                    x = y;
                    y = width - tmp;
                } else if (rotation == 180) {
                    x = width - x;
                    y = height - y;
                } else if (rotation == 270) {
                    x = height - y;
                    y = tmp;
                }
                y = pageRectWithRotation.getHeight() - y;
                JSONObject textPositon = new JSONObject();
                textPositon.put("page", (Object)pageNumb);
                textPositon.put("x", (Object)Float.valueOf(x));
                textPositon.put("y", (Object)Float.valueOf(y));
                positions.add((Object)textPositon);
            }
        }
        return positions;
    }

    private KGPdfElectronicExecute getPdfElectronicSig(JSONObject params, String keySN, JSONObject signinfo, HttpServletRequest request, HttpServletResponse response, PdfFileResource pdfFileResource) {
        String certOrigin = params.getString("certOrigin");
        String sealType = signinfo.getString("sealtag");
        String algorithmType = params.getString("algorithmType");
        Object pdfElectronicExecute = null;
        if ("0".equals(certOrigin)) {
            if ("PT".equals(sealType)) {
                pdfElectronicExecute = null;
                DigitalSignatureByServer digitalSignatureByServer = new DigitalSignatureByServer(Contants.URL, keySN);
                digitalSignatureByServer.setSignSN(signinfo.getString("signSN"));
                if (algorithmType.equals("RSA")) {
                    if (Contants.SERVER_SIG_P1) {
                        KGPdfElectronicSig electronicSig = new KGPdfElectronicSig();
                        electronicSig.setCertMsg((DigitalSignature)digitalSignatureByServer);
                        pdfElectronicExecute = electronicSig;
                    } else {
                        KGPdfElectronicSigOnline electronicSig = new KGPdfElectronicSigOnline();
                        electronicSig.setDigitalSignature(digitalSignatureByServer);
                        pdfElectronicExecute = electronicSig;
                    }
                } else if (algorithmType.equals("SM2")) {
                    if (Contants.SERVER_SIG_P1) {
                        KGPdfElectronicSig electronicSig = new KGPdfElectronicSig();
                        electronicSig.setSignatureAlgorithm("SM2");
                        DigitalSignatureOnlineClient digitalsignatureonlineclient = new DigitalSignatureOnlineClient(Contants.URL, keySN, signinfo.getString("signSN"));
                        electronicSig.setCertMsg((DigitalSignature)digitalsignatureonlineclient);
                        pdfElectronicExecute = electronicSig;
                    } else {
                        DigitalSignatureByServerSM2 digitalSignatureByServerSM2 = new DigitalSignatureByServerSM2(Contants.URL, keySN);
                        digitalSignatureByServerSM2.setClientVerify(false);
                        pdfElectronicExecute = KGPdfElectronicExecuteFactory.getKGPdfElectronicSigSM2((DigitalSignature)digitalSignatureByServerSM2);
                    }
                }
            } else if ("GB".equals(sealType) || "1".equals(Contants.CENTRALIZED_SEAL_ORIGIN)) {
                DigitalSignatureByGB digitalSignatureByGB = new DigitalSignatureByGB(Contants.STAMP_SYSTEM_URL, Contants.SALT, Contants.APPID, signinfo.getString("esid"), pdfFileResource.getDocumentId(), pdfFileResource.getDocumentName());
                digitalSignatureByGB.setQrCodeUid(params.getString("qrCodeUid"));
                pdfElectronicExecute = KGPdfElectronicExecuteFactory.getKGPdfElectronicSigGB((DigitalSignature)digitalSignatureByGB);
            } else if ("GM".equals(sealType)) {
                DigitalSignatureByServerSM2 digitalSignatureByServerSM2 = new DigitalSignatureByServerSM2(Contants.URL, keySN);
                digitalSignatureByServerSM2.setClientVerify(true);
                pdfElectronicExecute = KGPdfElectronicExecuteFactory.getKGPdfElectronicSigSM2((DigitalSignature)digitalSignatureByServerSM2);
            }
        } else if ("1".equals(certOrigin)) {
            pdfElectronicExecute = new ElectronicSignatureByKey();
        } else if ("2".equals(certOrigin)) {
            ThridPartySig thridPartySig = ElectronicSealFactory.getThridPartySig();
            PdfElectronicSig pdfElectronicSig = thridPartySig.getPdfElectronicSig(params, signinfo, request, response);
            pdfElectronicExecute = new KGPdfElectronicThirdSig(pdfElectronicSig);
        }
        return pdfElectronicExecute;
    }

    public JSONObject sm2Sig(HttpServletRequest request, HttpServletResponse response, JSONArray seals, PdfFileResource pdfFileResource, JSONObject params) throws IOException, DocumentException, GeneralSecurityException, KGNotFindTextException {
        String pdfFile = pdfFileResource.getPdfFile();
        InputStream in = pdfFileResource.getPdfFileStream();
        OutputStream out = pdfFileResource.getSavePdfFileSteam();
        String documentName = pdfFileResource.getDocumentName();
        String ipAddress = this.getIpAddress(request);
        String certOrigin = params.getString("certOrigin");
        String cert = params.getString("cert");
        KGBase64 base64 = new KGBase64();
        JSONObject retobj = new JSONObject();
        if ("0".equals(certOrigin)) {
            retobj = this.cycleDoSig(seals, params, pdfFile, in, out, documentName, ipAddress);
        } else if ("1".equals(certOrigin)) {
            KGPdfHummer hummer = PdfUtils.getPdfHummerOfSig(pdfFile, in, out, params.getString("pdfPwd"));
            String sealdata = seals.getJSONObject(0).getString("sealData");
            hummer.setGBGMSeal4PdfDigitalSignature(base64.decode(sealdata));
            DigitalSignatureByKeySM2 digitalSignatureByKeySM2 = new DigitalSignatureByKeySM2();
            if (cert == null) {
                hummer.setCertificate(null, (SignatureInter)digitalSignatureByKeySM2);
            } else {
                hummer.setCertificate(CertUtils.convertCertToCertificate(base64.decode(cert)), (SignatureInter)digitalSignatureByKeySM2);
            }
            JSONObject obj = seals.getJSONObject(0);
            PdfSignature4SM2 pdfSignature4sm2 = new PdfSignature4SM2();
            this.setPosition(obj, (AbstractSign)pdfSignature4sm2);
            if (obj.getBooleanValue("isStampOfText")) {
                JSONArray positions = this.findTextPosition(hummer.getPdfReader(), pdfSignature4sm2.getPagens(), obj.getString("text"));
                if (positions.size() > 0) {
                    retobj.put("textPositions", (Object)positions);
                } else {
                    throw new KGNotFindTextException("\u5173\u952e\u5b57\u4e0d\u5b58\u5728\uff1a" + obj.getString("text"));
                }
            }
            pdfSignature4sm2.kgProperty(hummer.getPdfReader(), obj.getString("keySN"), obj.getString("userName"), obj.getString("unitName"), obj.getString("signSN"), obj.getString("signName"), "0", "", ipAddress);
            if (Contants.SAVELOG) {
                this.saveLog(obj, params.getString("documentId"), documentName, ipAddress);
            }
            hummer.addExecute((KGExecute)pdfSignature4sm2);
            hummer.doSignature();
            if (digitalSignatureByKeySM2 != null) {
                JSONObject sigobj = new JSONObject();
                sigobj.put("needSigMessage", (Object)digitalSignatureByKeySM2.getHash());
                sigobj.put("sigKeepData", (Object)digitalSignatureByKeySM2.getSigKeepData());
                JSONArray array = new JSONArray();
                array.add((Object)sigobj);
                retobj.put("sigobj", (Object)array);
            }
        } else {
            throw new IllegalArgumentException("certOrigin \u4e0d\u6b63\u786e\uff1a" + certOrigin);
        }
        return retobj;
    }

    public JSONObject sig(HttpServletRequest request, HttpServletResponse response, JSONArray seals, PdfFileResource pdfFileResource, JSONObject params) throws IOException, DocumentException, GeneralSecurityException, KGNotFindTextException {
        String pdfFile = pdfFileResource.getPdfFile();
        InputStream in = pdfFileResource.getPdfFileStream();
        OutputStream out = pdfFileResource.getSavePdfFileSteam();
        String documentName = pdfFileResource.getDocumentName();
        String ipAddress = this.getIpAddress(request);
        JSONObject retobj = new JSONObject();
        KGBase64 base64 = new KGBase64();
        String sealType = params.getString("sealType");
        String certOrigin = params.getString("certOrigin");
        if ("PT".equals(sealType) && Contants.SIG_WITH_DIFFERENT_CERT && !"1".equals(certOrigin)) {
            this.cycleDoSig(seals, params, pdfFile, in, out, documentName, ipAddress);
        } else {
            KGPdfHummer hummer = PdfUtils.getPdfHummerOfSig(pdfFile, in, out, params.getString("pdfPwd"));
            hummer.setPdfSignature(null);
            if (Contants.TSA_URL != null && Contants.TSA_URL.length() != 0) {
                hummer.setTSAClient(Contants.TSA_URL, Contants.TSA_USERNAME, Contants.TSA_PASSWORD);
            }
            DigitalSignatureByKey digitalSignatureByKey = null;
            if ("0".equals(certOrigin)) {
                String keySN = seals.getJSONObject(0).getString("keySN");
                DigitalSignatureByServer digitalSignatureByServer = new DigitalSignatureByServer(Contants.URL, keySN);
                hummer.setCertificate((DigitalSignature)digitalSignatureByServer);
            } else if ("1".equals(certOrigin)) {
                digitalSignatureByKey = new DigitalSignatureByKey();
                digitalSignatureByKey.setSigType(1);
                hummer.setCertificate(null, (SignatureInter)digitalSignatureByKey);
            } else {
                throw new IllegalArgumentException("certOrigin \u4e0d\u6b63\u786e\uff1a" + certOrigin);
            }
            for (int i = 0; i < seals.size(); ++i) {
                JSONObject obj = seals.getJSONObject(i);
                PdfSignature4KG pdfSignature = new PdfSignature4KG(null, 0, null);
                if (!obj.getBooleanValue("isStampOfQfz")) {
                    String imgFormat = obj.getString("imgExt");
                    float width = obj.getFloatValue("width");
                    float height = obj.getFloatValue("height");
                    String imgdata = obj.getString("imgdata");
                    int index = imgdata.indexOf(44);
                    byte[] imgb = base64.decode(imgdata.substring(index + 1));
                    pdfSignature.setImage(imgb, imgFormat, (int)width, (int)height);
                }
                pdfSignature.kgProperty(hummer.getPdfReader(), obj.getString("keySN"), obj.getString("userName"), obj.getString("unitName"), obj.getString("signSN"), obj.getString("signName"), "0", "", this.getIpAddress(request));
                this.setPosition(obj, (AbstractSign)pdfSignature);
                if (obj.getBooleanValue("isStampOfText")) {
                    JSONArray positions = this.findTextPosition(hummer.getPdfReader(), pdfSignature.getPagens(), obj.getString("text"));
                    if (positions.size() > 0) {
                        retobj.put("textPositions", (Object)positions);
                    } else {
                        throw new KGNotFindTextException("\u5173\u952e\u5b57\u4e0d\u5b58\u5728\uff1a" + obj.getString("text"));
                    }
                }
                if (Contants.SAVELOG) {
                    this.saveLog(obj, params.getString("documentId"), documentName, ipAddress);
                }
                hummer.addExecute((KGExecute)pdfSignature);
            }
            hummer.doSignature();
            if (digitalSignatureByKey != null) {
                byte[] hash_data = Hex.decode((String)digitalSignatureByKey.getHash());
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                hash_data = messageDigest.digest(hash_data);
                String needSigMessage = new String(Hex.encode((byte[])hash_data));
                String sigKeepData = digitalSignatureByKey.getSigKeepData();
                JSONObject sigobj = new JSONObject();
                sigobj.put("needSigMessage", (Object)needSigMessage);
                sigobj.put("sigKeepData", (Object)sigKeepData);
                JSONArray array = new JSONArray();
                array.add((Object)sigobj);
                retobj.put("sigobj", (Object)array);
            }
        }
        return retobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject cycleDoSig(JSONArray seals, JSONObject params, String pdfFile, InputStream in, OutputStream out, String documentName, String ipAddress) throws IOException, DocumentException, GeneralSecurityException, KGNotFindTextException {
        JSONObject retobj = new JSONObject();
        int size = seals.size();
        if (size == 1) {
            retobj = this.doSig(pdfFile, in, out, params, seals.getJSONObject(0), documentName, ipAddress);
            return retobj;
        }
        String tmp = System.getProperty("user.dir") + File.separator + UUID.randomUUID().toString();
        FileOutputStream fileOutputStream = new FileOutputStream(tmp);
        try {
            this.doSig(pdfFile, in, fileOutputStream, params, seals.getJSONObject(0), documentName, ipAddress);
        }
        catch (Throwable e) {
            File file = new File(tmp);
            if (file.exists()) {
                file.delete();
            }
            throw new RuntimeException(e);
        }
        for (int i = 1; i < seals.size() - 1; ++i) {
            String _tmp = System.getProperty("user.dir") + File.separator + UUID.randomUUID().toString();
            FileInputStream tmpIn = new FileInputStream(tmp);
            FileOutputStream _tmpOut = new FileOutputStream(_tmp);
            try {
                this.doSig(null, tmpIn, _tmpOut, params, seals.getJSONObject(i), documentName, ipAddress);
                continue;
            }
            finally {
                File f = new File(tmp);
                if (f.exists()) {
                    f.delete();
                }
                tmp = _tmp;
            }
        }
        FileInputStream tmpIn = new FileInputStream(tmp);
        try {
            this.doSig(null, tmpIn, out, params, seals.getJSONObject(seals.size() - 1), documentName, ipAddress);
        }
        finally {
            File f = new File(tmp);
            if (f.exists()) {
                f.delete();
            }
        }
        return retobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject doSig(String pdfFile, InputStream in, OutputStream out, JSONObject params, JSONObject seal, String documentName, String ipAddress) throws IOException, DocumentException, GeneralSecurityException, KGNotFindTextException {
        KGPdfHummer hummer = null;
        KGBase64 base64 = new KGBase64();
        JSONObject retobj = new JSONObject();
        try {
            hummer = PdfUtils.getPdfHummerOfSig(pdfFile, in, out, params.getString("pdfPwd"));
            if (Contants.TSA_URL != null && Contants.TSA_URL.length() != 0) {
                hummer.setTSAClient(Contants.TSA_URL, Contants.TSA_USERNAME, Contants.TSA_PASSWORD);
            }
            int version = seal.getInteger("version");
            PdfSignature4KG pdfSignature = null;
            if (version == 0) {
                hummer.setPdfSignature(null);
                DigitalSignatureByServer digitalSignatureByServer = new DigitalSignatureByServer(Contants.URL, seal.getString("keySN"));
                digitalSignatureByServer.setSignSN(seal.getString("signSN"));
                hummer.setCertificate((DigitalSignature)digitalSignatureByServer);
                PdfSignature4KG pdfSignature4KG = new PdfSignature4KG(null, 0, null);
                if (!seal.getBooleanValue("isStampOfQfz")) {
                    String imgFormat = seal.getString("imgExt");
                    float width = seal.getFloatValue("width");
                    float height = seal.getFloatValue("height");
                    String imgdata = seal.getString("imgdata");
                    int index = imgdata.indexOf(44);
                    byte[] imgb = base64.decode(imgdata.substring(index + 1));
                    pdfSignature4KG.setImage(imgb, imgFormat, (int)width, (int)height);
                }
                pdfSignature4KG.kgProperty(hummer.getPdfReader(), seal.getString("keySN"), seal.getString("userName"), seal.getString("unitName"), seal.getString("signSN"), seal.getString("signName"), "0", "", ipAddress);
                this.setPosition(seal, (AbstractSign)pdfSignature4KG);
                pdfSignature = pdfSignature4KG;
            } else {
                hummer.setGBGMSeal4PdfDigitalSignature(base64.decode(seal.getString("sealData")));
                String qrCodeUid = params.getString("qrCodeUid");
                String sealtag = seal.getString("sealtag");
                if (sealtag != null && "GB".equals(sealtag) || "1".equals(Contants.CENTRALIZED_SEAL_ORIGIN)) {
                    DigitalSignatureByGB digitalSignatureByGB = new DigitalSignatureByGB(Contants.STAMP_SYSTEM_URL, Contants.SALT, Contants.APPID, seal.getString("esid"), "1", "title");
                    digitalSignatureByGB.setQrCodeUid(qrCodeUid);
                    hummer.setCertificate((DigitalSignature)digitalSignatureByGB);
                } else {
                    DigitalSignatureSM2ByServer digitalSignatureSM2ByServer = new DigitalSignatureSM2ByServer(Contants.URL, seal.getString("keySN"));
                    digitalSignatureSM2ByServer.setSignSN(seal.getString("signSN"));
                    hummer.setCertificate((DigitalSignature)digitalSignatureSM2ByServer);
                }
                PdfSignature4SM2 pdfSignature4sm2 = new PdfSignature4SM2();
                this.setPosition(seal, (AbstractSign)pdfSignature4sm2);
                pdfSignature4sm2.kgProperty(hummer.getPdfReader(), seal.getString("keySN"), seal.getString("userName"), seal.getString("unitName"), seal.getString("signSN"), seal.getString("signName"), "0", "", ipAddress, qrCodeUid == null ? "0" : "1", params.getString("qrCodeUserUid"), params.getString("qrCodeUserName"));
                pdfSignature = pdfSignature4sm2;
            }
            if (seal.getBooleanValue("isStampOfText")) {
                JSONArray positions = this.findTextPosition(hummer.getPdfReader(), pdfSignature.getPagens(), seal.getString("text"));
                if (positions.size() > 0) {
                    retobj.put("textPositions", (Object)positions);
                } else {
                    throw new KGNotFindTextException("\u5173\u952e\u5b57\u4e0d\u5b58\u5728\uff1a" + seal.getString("text"));
                }
            }
            if (Contants.SAVELOG) {
                this.saveLog(seal, params.getString("documentId"), documentName, ipAddress);
            }
            hummer.addExecute((KGExecute)pdfSignature);
            hummer.doSignature();
        }
        finally {
            PdfUtils.close(in);
            PdfUtils.close(out);
            if (hummer != null) {
                hummer.close();
            }
        }
        return retobj;
    }

    private void saveLog(JSONObject seal, String documentId, String documentName, String ipAddress) {
        LogEntity logEntity = new LogEntity();
        logEntity.setLogType("00");
        logEntity.setLogSort("13");
        logEntity.setKeySN(seal.getString("keySN"));
        logEntity.setSignSN(seal.getString("signSN"));
        logEntity.setDocumentID(documentId);
        logEntity.setDocumentName(documentName);
        logEntity.setLogIP(ipAddress);
        if (Contants.VERIFY_CAPTCHA) {
            logEntity.setLogMemo("\u76d6\u7ae0\u6210\u529f\u3010\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1" + seal.getString("phone") + "\u3011");
        }
        KGHttpUtils http = new KGHttpUtils();
        http.saveLog(Contants.URL, logEntity);
    }

    public String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

