/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.KGitextpdf.text.pdf.security.TSAClient;
import com.KGitextpdf.text.pdf.security.TSAClientBouncyCastle;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.exception.KGErrorSm2VerifyException;
import com.kinggrid.kgcore.gm.SealGM;
import com.kinggrid.kgcore.gm.SealUtil;
import com.kinggrid.pdf.DigitalSignatureByKey;
import com.kinggrid.pdf.DigitalSignatureByKeySM2;
import com.kinggrid.pdf.ElectronicSignatureByKey;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.executes.customize.DisposeSigndataToClient;
import com.kinggrid.pdf.executes.signature.sm2.GMSesSignature;
import com.kinggrid.pdf.executes.signature.sm2.SesSignature;
import com.kinggrid.pdf.utils.Asn1Utils;
import com.kinggrid.pdf.utils.VerifyCertUtils;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import com.kinggrid.pdfviewer.utils.CertUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.util.encoders.Hex;

public class ReWriteSigDataAction
implements PdfActionInter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        block32: {
            File file;
            String stampType = params.getString("stampType");
            String documentId = params.getString("documentId");
            if (pdfFileResource == null) {
                pdfFileResource = PdfFileResourceManager.getPdfFileResource();
            }
            pdfFileResource.init(request, response, action, documentId);
            pdfFileResource.getkeySN(params.getString("keySN"));
            String preFile = pdfFileResource.getPrePdfFile();
            Boolean error = params.getBoolean("error");
            if (error != null && error.booleanValue()) {
                pdfFileResource.fail();
                JSONObject retObj = new JSONObject();
                retObj.put("status", (Object)true);
                response.getWriter().println(retObj.toJSONString());
                return;
            }
            JSONArray arr = params.getJSONArray("data");
            String cert = params.getString("cert");
            if ("1".equals(stampType)) {
                X509Certificate x509Certificate = null;
                try {
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    x509Certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(Hex.decode((String)cert)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    for (int i = 0; i < arr.size(); ++i) {
                        JSONObject obj = arr.getJSONObject(i);
                        String sigKeepData = obj.getString("sigKeepData");
                        String sigData = obj.getString("sigData");
                        DigitalSignatureByKey digitalSignatureByKey = new DigitalSignatureByKey();
                        digitalSignatureByKey.setSigKeepData(sigKeepData);
                        digitalSignatureByKey.setChain((Certificate[])new X509Certificate[]{x509Certificate});
                        if (Contants.TSA_URL != null && Contants.TSA_URL.length() != 0) {
                            digitalSignatureByKey.setTsaClient((TSAClient)new TSAClientBouncyCastle(Contants.TSA_URL, Contants.TSA_USERNAME, Contants.TSA_PASSWORD));
                        }
                        sigData = digitalSignatureByKey.reversalContents(sigData);
                        digitalSignatureByKey.setExtSignature(Hex.decode((String)sigData));
                        digitalSignatureByKey.rewriteContentsPKCS7(preFile, null);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            if ("2".equals(stampType)) {
                KGBase64 base64 = new KGBase64();
                try {
                    for (int i = 0; i < arr.size(); ++i) {
                        JSONObject obj = arr.getJSONObject(i);
                        String needSigMessage = obj.getString("needSigMessage");
                        String sigKeepData = obj.getString("sigKeepData");
                        String sigData = obj.getString("sigedData");
                        DigitalSignatureByKeySM2 digitalSignatureByKeySM2 = new DigitalSignatureByKeySM2();
                        digitalSignatureByKeySM2.setSigKeepData(sigKeepData);
                        byte[] encodedSig = null;
                        if (digitalSignatureByKeySM2.getSealVersion() == 2) {
                            encodedSig = GMSesSignature.getGMSesSignature((ASN1Sequence)ASN1Sequence.getInstance((Object)base64.decode(needSigMessage)), (byte[])base64.decode(sigData)).getEncoded();
                        } else {
                            ASN1Sequence toSignSeq = ASN1Sequence.getInstance((Object)base64.decode(needSigMessage));
                            byte[] certBytes = base64.decode(cert);
                            ASN1Sequence esealSeq = (ASN1Sequence)toSignSeq.getObjectAt(1);
                            SealGM sealInfo = SealUtil.getSealInfo((byte[])esealSeq.getEncoded());
                            Certificate certificate = CertUtils.convertCertToCertificate(certBytes);
                            VerifyCertUtils.verifySignCert((SealGM)sealInfo, (Certificate[])new Certificate[]{certificate});
                            encodedSig = SesSignature.getSesSignature((ASN1Sequence)toSignSeq, (byte[])certBytes, (byte[])base64.decode(sigData), null).getEncoded();
                        }
                        digitalSignatureByKeySM2.write(preFile, Hex.toHexString((byte[])encodedSig).getBytes());
                    }
                }
                catch (Exception e) {
                    pdfFileResource.fail();
                    if (e instanceof KGErrorSm2VerifyException) {
                        JSONObject retObj = new JSONObject();
                        retObj.put("status", (Object)false);
                        retObj.put("message", (Object)e.getMessage());
                        response.getWriter().write(retObj.toJSONString());
                        return;
                    }
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            KGPdfHummer hummer = null;
            FileOutputStream fileOutputStream = null;
            String tmp = Contants.USER_TMP + File.separator + UUID.randomUUID().toString();
            String pwd = params.getString("pdfPwd");
            byte[] password = null;
            if (pwd != null && pwd.length() > 0) {
                password = pwd.getBytes("UTF-8");
            }
            fileOutputStream = new FileOutputStream(tmp);
            hummer = KGPdfHummer.createInstance((String)preFile, (byte[])password, (boolean)true, (OutputStream)fileOutputStream, (boolean)true);
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                String sigKeepData = obj.getString("sigKeepData");
                String certSignMsg = obj.getString("certSignMsg");
                if (params.getBooleanValue("externalSign")) {
                    KGBase64 base64 = new KGBase64();
                    byte[] signedDecode = base64.decode(certSignMsg);
                    if (signedDecode.length == 64) {
                        signedDecode = Asn1Utils.sigData64bit2Ans1((byte[])signedDecode);
                    }
                    certSignMsg = new String(DisposeSigndataToClient.spellSignadata((String)cert, (byte[])signedDecode));
                }
                ElectronicSignatureByKey electronicSignatureByKey = new ElectronicSignatureByKey();
                electronicSignatureByKey.setKeepData(sigKeepData);
                electronicSignatureByKey.setSig(certSignMsg, cert);
                hummer.addExecute((KGExecute)electronicSignatureByKey.getRewriteSig());
            }
            hummer.doExecute();
            PdfUtils.close(fileOutputStream);
            if (hummer != null) {
                hummer.close();
            }
            if (!(file = new File(tmp)).exists()) break block32;
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(file);
                out = new FileOutputStream(preFile);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                file.delete();
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            file.delete();
            break block32;
            catch (Exception e) {
                try {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    File file2;
                    PdfUtils.close(fileOutputStream);
                    if (hummer != null) {
                        hummer.close();
                    }
                    if ((file2 = new File(tmp)).exists()) {
                        FileInputStream in2 = null;
                        FileOutputStream out2 = null;
                        try {
                            in2 = new FileInputStream(file2);
                            out2 = new FileOutputStream(preFile);
                            IOUtils.copy((InputStream)in2, (OutputStream)out2);
                        }
                        catch (Throwable throwable2) {
                            IOUtils.closeQuietly(in2);
                            IOUtils.closeQuietly(out2);
                            file2.delete();
                            throw throwable2;
                        }
                        IOUtils.closeQuietly((InputStream)in2);
                        IOUtils.closeQuietly((OutputStream)out2);
                        file2.delete();
                    }
                    throw throwable;
                }
            }
        }
        pdfFileResource.success();
        JSONObject retObj = new JSONObject();
        retObj.put("status", (Object)true);
        response.getWriter().println(retObj.toJSONString());
    }
}

