/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.alibaba.fastjson.JSONObject;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.executes.postil.PdfPostil;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ImportAnnotsAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        String documentId = null;
        boolean saveAs = false;
        String annotsData = null;
        if (request.getParameter("saveAs") != null) {
            documentId = request.getParameter("documentId");
            saveAs = Boolean.parseBoolean(request.getParameter("saveAs"));
            annotsData = request.getParameter("annotsData");
        } else {
            documentId = params.getString("documentId");
            annotsData = params.getString("annotsData");
        }
        if (pdfFileResource == null) {
            pdfFileResource = PdfFileResourceManager.getPdfFileResource();
        }
        pdfFileResource.init(request, response, action, documentId);
        JSONObject retObj = new JSONObject();
        KGPdfHummer hummer = null;
        InputStream in = null;
        OutputStream out = null;
        String pdfFile = pdfFileResource.getPdfFile();
        try {
            in = pdfFileResource.getPdfFileStream();
            if (saveAs) {
                response.setContentType("application/pdf");
                response.addHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", documentId));
                out = response.getOutputStream();
            } else {
                out = pdfFileResource.getSavePdfFileSteam();
            }
            hummer = PdfUtils.getPdfHummer(pdfFile, in, out, null);
            PdfPostil pdfPostil = new PdfPostil();
            ArrayList<String> list = new ArrayList<String>();
            list.add(annotsData);
            pdfPostil.setPostilArray(list);
            hummer.addExecute((KGExecute)pdfPostil);
            hummer.doExecute();
        }
        catch (Throwable e) {
            try {
                pdfFileResource.fail();
                retObj.put("status", (Object)false);
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                PdfUtils.close(in);
                PdfUtils.close(out);
                if (hummer != null) {
                    hummer.close();
                }
                throw throwable;
            }
        }
        PdfUtils.close(in);
        PdfUtils.close(out);
        if (hummer != null) {
            hummer.close();
        }
        if (!saveAs) {
            pdfFileResource.success();
            retObj.put("status", (Object)true);
            response.getWriter().write(retObj.toJSONString());
        }
    }
}

