/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.kgcore.gm.SealGM;
import com.kinggrid.kgcore.gm.SealUtil;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.PVHttpUtil;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kg.bouncycastle.util.encoders.Hex;

public class HandleCilentSealAction
implements PdfActionInter {
    private static final boolean CHECKAUTHORIZATION = false;

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        JSONObject retObj = new JSONObject();
        if (pdfFileResource == null) {
            pdfFileResource = PdfFileResourceManager.getPdfFileResource();
        }
        String keySN = pdfFileResource.getkeySN(params.getString("keySN"));
        JSONArray clientSeals = params.getJSONArray("seals");
        String unitName = params.getString("unitName");
        String stampType = params.getString("stampType");
        KGBase64 base64 = new KGBase64();
        JSONArray seals = new JSONArray();
        for (int i = 0; i < clientSeals.size(); ++i) {
            String clientSeal;
            if ("2".equals(stampType)) {
                clientSeal = clientSeals.getString(i);
                byte[] seal = base64.decode(clientSeal);
                SealGM sealObject = SealUtil.getSealInfo((byte[])seal);
                JSONObject sealObj = new JSONObject();
                sealObj.put("keySN", (Object)keySN);
                sealObj.put("unitName", (Object)unitName);
                sealObj.put("signName", (Object)sealObject.getName());
                sealObj.put("width", (Object)Float.valueOf((float)sealObject.getWidth() * 2.8346457f));
                sealObj.put("height", (Object)Float.valueOf((float)sealObject.getHeight() * 2.8346457f));
                String imgType = sealObject.getPicType();
                sealObj.put("imgExt", (Object)imgType);
                sealObj.put("signSN", (Object)"");
                byte[] imgdata = sealObject.getPicData();
                sealObj.put("imgdata", (Object)("data:image/" + imgType + ";base64," + base64.encode(imgdata)));
                sealObj.put("sealData", (Object)clientSeal);
                seals.add((Object)sealObj);
                continue;
            }
            clientSeal = clientSeals.getJSONObject(i);
            JSONObject sealObj = new JSONObject();
            sealObj.put("keySN", (Object)keySN);
            sealObj.put("userName", (Object)clientSeal.getString("username"));
            sealObj.put("unitName", (Object)unitName);
            sealObj.put("signSN", (Object)clientSeal.getString("signsn"));
            sealObj.put("signName", (Object)clientSeal.getString("signname"));
            sealObj.put("width", (Object)Float.valueOf(clientSeal.getFloat("width").floatValue() * 28.346457f));
            sealObj.put("height", (Object)Float.valueOf(clientSeal.getFloat("height").floatValue() * 28.346457f));
            String imgType = clientSeal.getString("imgext").substring(1);
            sealObj.put("imgExt", (Object)imgType);
            String imgdata = clientSeal.getString("imgdata");
            String signsn = imgdata.substring(0, 65);
            base64.setBase64Table(signsn);
            byte[] imgb = base64.decode(imgdata.substring(65));
            String table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
            base64.setBase64Table(table);
            sealObj.put("imgdata", (Object)("data:image/" + imgType + ";base64," + base64.encode(imgb)));
            sealObj.put("sealtag", (Object)clientSeal.getString("sealtag"));
            seals.add((Object)sealObj);
        }
        retObj.put("status", (Object)true);
        retObj.put("seals", (Object)seals);
        if (Contants.getProperty("appKey") != null) {
            retObj.put("appKey", (Object)Contants.getProperty("appKey"));
        }
        response.getWriter().println(retObj.toJSONString());
    }

    private JSONObject getRandomN(String randomA) throws Exception {
        String url = Contants.getProperty("yypt.url") + "/api/auth/jwt/getRandomN";
        JSONObject queryJson = new JSONObject();
        queryJson.put("appKey", (Object)Contants.getProperty("appKey"));
        queryJson.put("randomA", (Object)randomA);
        KGBase64 base64 = new KGBase64();
        String data = base64.encode(queryJson.toString().getBytes("UTF-8"));
        JSONObject dataObj = new JSONObject();
        dataObj.put("data", (Object)data);
        PVHttpUtil httpUtil = new PVHttpUtil();
        String result = httpUtil.getResult(url, dataObj);
        return JSONObject.parseObject((String)result);
    }

    private JSONObject authKeySnByAppkey(String keysn) throws Exception {
        String url = Contants.getProperty("yypt.url") + "/api/auth/jwt/authKeySnByAppkey";
        String randomA = this.getRandomNumber();
        JSONObject retObj = this.getRandomN(randomA);
        if (!"0".equals(retObj.getString("code"))) {
            return retObj;
        }
        KGBase64 base64 = new KGBase64();
        String dataStr = new String(base64.decode(retObj.getString("data")));
        String checkCode = this.md5Hex(JSONObject.parseObject((String)dataStr).getString("randomN") + Contants.getProperty("appSalt"));
        JSONObject queryJson = new JSONObject();
        queryJson.put("appKey", (Object)Contants.getProperty("appKey"));
        queryJson.put("randomA", (Object)randomA);
        queryJson.put("checkCode", (Object)checkCode);
        queryJson.put("keySn", (Object)keysn);
        String data = base64.encode(queryJson.toString().getBytes("UTF-8"));
        JSONObject dataObj = new JSONObject();
        dataObj.put("data", (Object)data);
        PVHttpUtil httpUtil = new PVHttpUtil();
        String result = httpUtil.getResult(url, dataObj);
        return JSONObject.parseObject((String)result);
    }

    private String md5Hex(String inputStr) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(inputStr.getBytes("utf-8"));
        byte[] result = md5.digest();
        return new String(Hex.encode((byte[])result));
    }

    public String getRandomNumber() {
        Random random = new Random();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            builder.append(random.nextInt(10));
        }
        return builder.toString();
    }
}

