/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.kgcore.IMsgServer;
import com.kinggrid.kgcore.KGHttpUtils;
import com.kinggrid.kgcore.enmu.KGQueryByEnum;
import com.kinggrid.kgcore.enmu.KGServerTypeEnum;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.MsgServerUtils;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetUserAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        JSONObject retObj = new JSONObject();
        if (pdfFileResource == null) {
            pdfFileResource = PdfFileResourceManager.getPdfFileResource();
        }
        String keysn = pdfFileResource.getkeySN(params.getString("keySN"));
        String pwd = params.getString("password");
        String userInfo = null;
        try {
            MsgServerUtils.verifyPwd(keysn, pwd);
            userInfo = this.getServerSeal(Contants.URL, KGServerTypeEnum.AUTO, keysn, null);
        }
        catch (Exception e) {
            String message = null;
            if (!(e instanceof KGServerInterfaceErrorException)) {
                throw new RuntimeException(e);
            }
            message = e.getMessage();
            retObj.put("status", (Object)false);
            retObj.put("message", (Object)message);
            response.getWriter().write(retObj.toJSONString());
            return;
        }
        String[] userinfo_arr = userInfo.split(",");
        retObj.put("keySN", (Object)userinfo_arr[0]);
        retObj.put("userName", (Object)userinfo_arr[1]);
        retObj.put("unitName", (Object)userinfo_arr[2]);
        KGBase64 base64 = new KGBase64();
        String signSN = base64.encode("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUV".getBytes("utf-8")) + "=";
        retObj.put("signSN", (Object)signSN);
        retObj.put("status", (Object)true);
        response.getWriter().write(retObj.toJSONString());
    }

    public String getServerSeal(String url, KGServerTypeEnum serverTypeEnum, String keySN, String sealName) {
        KGHttpUtils httpUtils = new KGHttpUtils();
        if (serverTypeEnum == KGServerTypeEnum.GA) {
            return this.getGAServerSeal(url, keySN, sealName);
        }
        IMsgServer msgServer = new IMsgServer();
        msgServer.setCharset("GBK");
        msgServer.SetMsgByName("OPTION", "GETNETFILESIGNATURES");
        if (KGQueryByEnum.KEYSN == httpUtils.getQueryBy()) {
            msgServer.SetMsgByName("VIRTUALKEYNUMBER", keySN);
        } else if (KGQueryByEnum.USERCODE == httpUtils.getQueryBy()) {
            msgServer.SetMsgByName("USERCODE", keySN);
        }
        msgServer.SetMsgByName("SIGNATURENAME", sealName);
        httpUtils.sendPacktToServer(url, msgServer);
        String userInfo = msgServer.GetMsgByName("USERINFO");
        return userInfo;
    }

    public String getGAServerSeal(String url, String keySN, String sealName) {
        String[] signs;
        String userinfo = null;
        KGHttpUtils httpUtils = new KGHttpUtils();
        IMsgServer msgServer = new IMsgServer();
        msgServer.setCharset("GBK");
        msgServer.SetMsgByName("OPTION", "CHECKSIGNBYALL");
        msgServer.SetMsgByName("COMMAND", "GETKEYSIGNINFO");
        msgServer.SetMsgByName("SIGNPRIORPUB", "8");
        msgServer.SetMsgByName("KEYSN", keySN);
        httpUtils.sendPacktToServer(url, msgServer);
        String signsString = msgServer.GetMsgByName("SIGNPOWER");
        if (signsString != null && (signs = signsString.split(";")).length > 0) {
            String[] sign = signs[0].split(",");
            String userName = msgServer.DecodeBase64(sign[12]);
            String unitName = msgServer.DecodeBase64(sign[10]);
            userinfo = keySN + "," + userName + "," + unitName;
        }
        return userinfo;
    }
}

